package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for JBOD storage.
   */
  public class JbodStorageBuilder extends io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl<io.strimzi.api.kafka.model.storage.JbodStorageBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.storage.JbodStorage,io.strimzi.api.kafka.model.storage.JbodStorageBuilder> {

    io.strimzi.api.kafka.model.storage.JbodStorageFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public JbodStorageBuilder() {
        this(true);
    }

    public JbodStorageBuilder(java.lang.Boolean validationEnabled) {
        this(new JbodStorage(), validationEnabled);
    }

    public JbodStorageBuilder(io.strimzi.api.kafka.model.storage.JbodStorageFluent<?> fluent) {
        this(fluent, true);
    }

    public JbodStorageBuilder(io.strimzi.api.kafka.model.storage.JbodStorageFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new JbodStorage(), validationEnabled);
    }

    public JbodStorageBuilder(io.strimzi.api.kafka.model.storage.JbodStorageFluent<?> fluent,io.strimzi.api.kafka.model.storage.JbodStorage instance) {
        this(fluent, instance, true);
    }

    public JbodStorageBuilder(io.strimzi.api.kafka.model.storage.JbodStorageFluent<?> fluent,io.strimzi.api.kafka.model.storage.JbodStorage instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withVolumes(instance.getVolumes());
        
        this.validationEnabled = validationEnabled; 
    }

    public JbodStorageBuilder(io.strimzi.api.kafka.model.storage.JbodStorage instance) {
        this(instance,true);
    }

    public JbodStorageBuilder(io.strimzi.api.kafka.model.storage.JbodStorage instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withVolumes(instance.getVolumes());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.storage.JbodStorage build() {
        JbodStorage buildable = new JbodStorage();
        buildable.setVolumes(fluent.getVolumes());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JbodStorageBuilder that = (JbodStorageBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
