package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Representation for JBOD storage.
   */
  public interface JbodStorageFluent<A extends io.strimzi.api.kafka.model.storage.JbodStorageFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public A addToVolumes(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder);
    public A addToVolumes(int index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder);
    public A addToVolumes(int index,io.strimzi.api.kafka.model.storage.SingleVolumeStorage item);
    public A setToVolumes(int index,io.strimzi.api.kafka.model.storage.SingleVolumeStorage item);
    public A addToVolumes(io.strimzi.api.kafka.model.storage.SingleVolumeStorage... items);
    public A addAllToVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> items);
    public A removeFromVolumes(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder);
    public A removeFromVolumes(io.strimzi.api.kafka.model.storage.SingleVolumeStorage... items);
    public A removeAllFromVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> items);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumes instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> getVolumes();
    public java.util.List<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> buildVolumes();
    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildVolume(int index);
    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildFirstVolume();
    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildLastVolume();
    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> predicate);
    public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> predicate);
    public A withVolumes(java.util.List<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> volumes);
    public A withVolumes(io.strimzi.api.kafka.model.storage.SingleVolumeStorage... volumes);
    public java.lang.Boolean hasVolumes();
    public A addToPersistentClaimStorageVolumes(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorage item);
    public A setToPersistentClaimStorageVolumes(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorage item);
    public A addToPersistentClaimStorageVolumes(io.strimzi.api.kafka.model.storage.PersistentClaimStorage... items);
    public A addAllToPersistentClaimStorageVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.PersistentClaimStorage> items);
    public A removeFromPersistentClaimStorageVolumes(io.strimzi.api.kafka.model.storage.PersistentClaimStorage... items);
    public A removeAllFromPersistentClaimStorageVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.PersistentClaimStorage> items);
    public A removeMatchingFromPersistentClaimStorageVolumes(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> predicate);
    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.PersistentClaimStorageVolumesNested<A> setNewPersistentClaimStorageVolumeLike(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorage item);
    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolume();
    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolumeLike(io.strimzi.api.kafka.model.storage.PersistentClaimStorage item);
    public A addToEphemeralStorageVolumes(int index,io.strimzi.api.kafka.model.storage.EphemeralStorage item);
    public A setToEphemeralStorageVolumes(int index,io.strimzi.api.kafka.model.storage.EphemeralStorage item);
    public A addToEphemeralStorageVolumes(io.strimzi.api.kafka.model.storage.EphemeralStorage... items);
    public A addAllToEphemeralStorageVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.EphemeralStorage> items);
    public A removeFromEphemeralStorageVolumes(io.strimzi.api.kafka.model.storage.EphemeralStorage... items);
    public A removeAllFromEphemeralStorageVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.EphemeralStorage> items);
    public A removeMatchingFromEphemeralStorageVolumes(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> predicate);
    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.EphemeralStorageVolumesNested<A> setNewEphemeralStorageVolumeLike(int index,io.strimzi.api.kafka.model.storage.EphemeralStorage item);
    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolume();
    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolumeLike(io.strimzi.api.kafka.model.storage.EphemeralStorage item);
      
  /**
   * Representation for persistent claim-based storage.
   */
  public interface PersistentClaimStorageVolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<io.strimzi.api.kafka.model.storage.JbodStorageFluent.PersistentClaimStorageVolumesNested<N>> {

            public N and();
            public N endPersistentClaimStorageVolume();    }


      
  /**
   * Representation for ephemeral storage.
   */
  public interface EphemeralStorageVolumesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.storage.EphemeralStorageFluent<io.strimzi.api.kafka.model.storage.JbodStorageFluent.EphemeralStorageVolumesNested<N>> {

            public N and();
            public N endEphemeralStorageVolume();    }


}
