package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

  
  /**
   * Representation for JBOD storage.
   */
  public class JbodStorageFluentImpl<A extends io.strimzi.api.kafka.model.storage.JbodStorageFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.storage.JbodStorageFluent<A> {

    private java.util.List<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> volumes;

    public JbodStorageFluentImpl() {
    }

    public JbodStorageFluentImpl(io.strimzi.api.kafka.model.storage.JbodStorage instance) {
        this.withVolumes(instance.getVolumes());
    }

    public A addToVolumes(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        _visitables.get("volumes").add(builder);this.volumes.add(builder); return (A)this;
    }

    public A addToVolumes(int index,io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        _visitables.get("volumes").add(index, builder);this.volumes.add(index, builder); return (A)this;
    }

    public A addToVolumes(int index,io.strimzi.api.kafka.model.storage.SingleVolumeStorage item) {
        if (item instanceof io.strimzi.api.kafka.model.storage.PersistentClaimStorage){addToPersistentClaimStorageVolumes(index, (io.strimzi.api.kafka.model.storage.PersistentClaimStorage)item);}
         else if (item instanceof io.strimzi.api.kafka.model.storage.EphemeralStorage){addToEphemeralStorageVolumes(index, (io.strimzi.api.kafka.model.storage.EphemeralStorage)item);}
        
        return (A)this;
    }

    public A setToVolumes(int index,io.strimzi.api.kafka.model.storage.SingleVolumeStorage item) {
        if (item instanceof io.strimzi.api.kafka.model.storage.PersistentClaimStorage){setToPersistentClaimStorageVolumes(index, (io.strimzi.api.kafka.model.storage.PersistentClaimStorage)item);}
         else if (item instanceof io.strimzi.api.kafka.model.storage.EphemeralStorage){setToEphemeralStorageVolumes(index, (io.strimzi.api.kafka.model.storage.EphemeralStorage)item);}
        
        return (A)this;
    }

    public A addToVolumes(io.strimzi.api.kafka.model.storage.SingleVolumeStorage... items) {
         if (items != null && items.length > 0 && this.volumes== null) {this.volumes = new ArrayList<VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        for (io.strimzi.api.kafka.model.storage.SingleVolumeStorage item : items) { 
        if (item instanceof io.strimzi.api.kafka.model.storage.PersistentClaimStorage){addToPersistentClaimStorageVolumes((io.strimzi.api.kafka.model.storage.PersistentClaimStorage)item);}
         else if (item instanceof io.strimzi.api.kafka.model.storage.EphemeralStorage){addToEphemeralStorageVolumes((io.strimzi.api.kafka.model.storage.EphemeralStorage)item);}
        
        else {  VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder = builderOf(item); _visitables.get("volumes").add(builder);this.volumes.add(builder); }
        } return (A)this;
    }

    public A addAllToVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> items) {
         if (items != null && items.size() > 0 && this.volumes== null) {this.volumes = new ArrayList<VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        for (io.strimzi.api.kafka.model.storage.SingleVolumeStorage item : items) { 
        if (item instanceof io.strimzi.api.kafka.model.storage.PersistentClaimStorage){addToPersistentClaimStorageVolumes((io.strimzi.api.kafka.model.storage.PersistentClaimStorage)item);}
         else if (item instanceof io.strimzi.api.kafka.model.storage.EphemeralStorage){addToEphemeralStorageVolumes((io.strimzi.api.kafka.model.storage.EphemeralStorage)item);}
        
        else {  VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder = builderOf(item); _visitables.get("volumes").add(builder);this.volumes.add(builder); }
        } return (A)this;
    }

    public A removeFromVolumes(io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        _visitables.get("volumes").remove(builder);this.volumes.remove(builder); return (A)this;
    }

    public A removeFromVolumes(io.strimzi.api.kafka.model.storage.SingleVolumeStorage... items) {
        for (io.strimzi.api.kafka.model.storage.SingleVolumeStorage item : items) {if (item instanceof io.strimzi.api.kafka.model.storage.PersistentClaimStorage){removeFromPersistentClaimStorageVolumes((io.strimzi.api.kafka.model.storage.PersistentClaimStorage)item);}
         else if (item instanceof io.strimzi.api.kafka.model.storage.EphemeralStorage){removeFromEphemeralStorageVolumes((io.strimzi.api.kafka.model.storage.EphemeralStorage)item);}
        
        else {  VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder = builderOf(item); _visitables.get("volumes").remove(builder);this.volumes.remove(builder); }
        } return (A)this;
    }

    public A removeAllFromVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> items) {
        for (io.strimzi.api.kafka.model.storage.SingleVolumeStorage item : items) {if (item instanceof io.strimzi.api.kafka.model.storage.PersistentClaimStorage){removeFromPersistentClaimStorageVolumes((io.strimzi.api.kafka.model.storage.PersistentClaimStorage)item);}
         else if (item instanceof io.strimzi.api.kafka.model.storage.EphemeralStorage){removeFromEphemeralStorageVolumes((io.strimzi.api.kafka.model.storage.EphemeralStorage)item);}
        
        else {  VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder = builderOf(item); _visitables.get("volumes").remove(builder);this.volumes.remove(builder); }
        } return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildVolumes instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> getVolumes() {
        return build(volumes);
    }

    public java.util.List<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> buildVolumes() {
        return build(volumes);
    }

    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildLastVolume() {
        return this.volumes.get(volumes.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.storage.SingleVolumeStorage buildMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> predicate) {
        for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingVolume(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> predicate) {
        for (io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(java.util.List<io.strimzi.api.kafka.model.storage.SingleVolumeStorage> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>(); for (io.strimzi.api.kafka.model.storage.SingleVolumeStorage item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(io.strimzi.api.kafka.model.storage.SingleVolumeStorage... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (io.strimzi.api.kafka.model.storage.SingleVolumeStorage item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public java.lang.Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public A addToPersistentClaimStorageVolumes(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorage item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToPersistentClaimStorageVolumes(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorage item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToPersistentClaimStorageVolumes(io.strimzi.api.kafka.model.storage.PersistentClaimStorage... items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorage item : items) {io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToPersistentClaimStorageVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.PersistentClaimStorage> items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorage item : items) {io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromPersistentClaimStorageVolumes(io.strimzi.api.kafka.model.storage.PersistentClaimStorage... items) {
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorage item : items) {io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromPersistentClaimStorageVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.PersistentClaimStorage> items) {
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorage item : items) {io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPersistentClaimStorageVolumes(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolume() {
        return new io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl.PersistentClaimStorageVolumesNestedImpl();
    }

    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolumeLike(io.strimzi.api.kafka.model.storage.PersistentClaimStorage item) {
        return new io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl.PersistentClaimStorageVolumesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.PersistentClaimStorageVolumesNested<A> setNewPersistentClaimStorageVolumeLike(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorage item) {
        return new io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl.PersistentClaimStorageVolumesNestedImpl(index, item);
    }

    public A addToEphemeralStorageVolumes(int index,io.strimzi.api.kafka.model.storage.EphemeralStorage item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToEphemeralStorageVolumes(int index,io.strimzi.api.kafka.model.storage.EphemeralStorage item) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToEphemeralStorageVolumes(io.strimzi.api.kafka.model.storage.EphemeralStorage... items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        for (io.strimzi.api.kafka.model.storage.EphemeralStorage item : items) {io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToEphemeralStorageVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.EphemeralStorage> items) {
        if (this.volumes == null) {this.volumes = new java.util.ArrayList<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>>();}
        for (io.strimzi.api.kafka.model.storage.EphemeralStorage item : items) {io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromEphemeralStorageVolumes(io.strimzi.api.kafka.model.storage.EphemeralStorage... items) {
        for (io.strimzi.api.kafka.model.storage.EphemeralStorage item : items) {io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromEphemeralStorageVolumes(java.util.Collection<io.strimzi.api.kafka.model.storage.EphemeralStorage> items) {
        for (io.strimzi.api.kafka.model.storage.EphemeralStorage item : items) {io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEphemeralStorageVolumes(java.util.function.Predicate<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?>> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.builder.VisitableBuilder<? extends io.strimzi.api.kafka.model.storage.SingleVolumeStorage,?> builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolume() {
        return new io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl.EphemeralStorageVolumesNestedImpl();
    }

    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolumeLike(io.strimzi.api.kafka.model.storage.EphemeralStorage item) {
        return new io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl.EphemeralStorageVolumesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.storage.JbodStorageFluent.EphemeralStorageVolumesNested<A> setNewEphemeralStorageVolumeLike(int index,io.strimzi.api.kafka.model.storage.EphemeralStorage item) {
        return new io.strimzi.api.kafka.model.storage.JbodStorageFluentImpl.EphemeralStorageVolumesNestedImpl(index, item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JbodStorageFluentImpl that = (JbodStorageFluentImpl) o;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(volumes,  super.hashCode());
    }

      
  /**
   * Representation for persistent claim-based storage.
   */
  public class PersistentClaimStorageVolumesNestedImpl<N> extends io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl<io.strimzi.api.kafka.model.storage.JbodStorageFluent.PersistentClaimStorageVolumesNested<N>> implements io.strimzi.api.kafka.model.storage.JbodStorageFluent.PersistentClaimStorageVolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder builder;
        private final int index;

            PersistentClaimStorageVolumesNestedImpl(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorage item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(this, item);
                        
            }

            PersistentClaimStorageVolumesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder(this);
                        
            }

            public N and() {
                return (N) JbodStorageFluentImpl.this.setToVolumes(index,builder.build());
            }

            public N endPersistentClaimStorageVolume() {
                return and();
            }
    }


      
  /**
   * Representation for ephemeral storage.
   */
  public class EphemeralStorageVolumesNestedImpl<N> extends io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl<io.strimzi.api.kafka.model.storage.JbodStorageFluent.EphemeralStorageVolumesNested<N>> implements io.strimzi.api.kafka.model.storage.JbodStorageFluent.EphemeralStorageVolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder builder;
        private final int index;

            EphemeralStorageVolumesNestedImpl(int index,io.strimzi.api.kafka.model.storage.EphemeralStorage item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(this, item);
                        
            }

            EphemeralStorageVolumesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder(this);
                        
            }

            public N and() {
                return (N) JbodStorageFluentImpl.this.setToVolumes(index,builder.build());
            }

            public N endEphemeralStorageVolume() {
                return and();
            }
    }


}
