package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for persistent claim-based storage.
   */
  public class PersistentClaimStorageBuilder extends io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl<io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.storage.PersistentClaimStorage,io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder> {

    io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PersistentClaimStorageBuilder() {
        this(true);
    }

    public PersistentClaimStorageBuilder(java.lang.Boolean validationEnabled) {
        this(new PersistentClaimStorage(), validationEnabled);
    }

    public PersistentClaimStorageBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<?> fluent) {
        this(fluent, true);
    }

    public PersistentClaimStorageBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PersistentClaimStorage(), validationEnabled);
    }

    public PersistentClaimStorageBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<?> fluent,io.strimzi.api.kafka.model.storage.PersistentClaimStorage instance) {
        this(fluent, instance, true);
    }

    public PersistentClaimStorageBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<?> fluent,io.strimzi.api.kafka.model.storage.PersistentClaimStorage instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSize(instance.getSize());
        
        fluent.withStorageClass(instance.getStorageClass());
        
        fluent.withSelector(instance.getSelector());
        
        fluent.withDeleteClaim(instance.isDeleteClaim());
        
        fluent.withOverrides(instance.getOverrides());
        
        fluent.withId(instance.getId());
        
        this.validationEnabled = validationEnabled; 
    }

    public PersistentClaimStorageBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorage instance) {
        this(instance,true);
    }

    public PersistentClaimStorageBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorage instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSize(instance.getSize());
        
        this.withStorageClass(instance.getStorageClass());
        
        this.withSelector(instance.getSelector());
        
        this.withDeleteClaim(instance.isDeleteClaim());
        
        this.withOverrides(instance.getOverrides());
        
        this.withId(instance.getId());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorage build() {
        PersistentClaimStorage buildable = new PersistentClaimStorage();
        buildable.setSize(fluent.getSize());
        buildable.setStorageClass(fluent.getStorageClass());
        buildable.setSelector(fluent.getSelector());
        buildable.setDeleteClaim(fluent.isDeleteClaim());
        buildable.setOverrides(fluent.getOverrides());
        buildable.setId(fluent.getId());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PersistentClaimStorageBuilder that = (PersistentClaimStorageBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
