package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Representation for persistent claim-based storage.
   */
  public interface PersistentClaimStorageFluent<A extends io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public java.lang.String getSize();
    public A withSize(java.lang.String size);
    public java.lang.Boolean hasSize();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSize instead.
     */
        public A withNewSize(java.lang.String original);
    public java.lang.String getStorageClass();
    public A withStorageClass(java.lang.String storageClass);
    public java.lang.Boolean hasStorageClass();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withStorageClass instead.
     */
        public A withNewStorageClass(java.lang.String original);
    public A addToSelector(java.lang.String key,java.lang.String value);
    public A addToSelector(java.util.Map<java.lang.String,java.lang.String> map);
    public A removeFromSelector(java.lang.String key);
    public A removeFromSelector(java.util.Map<java.lang.String,java.lang.String> map);
    public java.util.Map<java.lang.String,java.lang.String> getSelector();
    public <K,V>A withSelector(java.util.Map<java.lang.String,java.lang.String> selector);
    public java.lang.Boolean hasSelector();
    public boolean isDeleteClaim();
    public A withDeleteClaim(boolean deleteClaim);
    public java.lang.Boolean hasDeleteClaim();
    public A addToOverrides(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item);
    public A setToOverrides(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item);
    public A addToOverrides(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride... items);
    public A addAllToOverrides(java.util.Collection<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> items);
    public A removeFromOverrides(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride... items);
    public A removeAllFromOverrides(java.util.Collection<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> items);
    public A removeMatchingFromOverrides(java.util.function.Predicate<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> predicate);
    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildOverrides instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> getOverrides();
    public java.util.List<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> buildOverrides();
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride buildOverride(int index);
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride buildFirstOverride();
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride buildLastOverride();
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride buildMatchingOverride(java.util.function.Predicate<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> predicate);
    public java.lang.Boolean hasMatchingOverride(java.util.function.Predicate<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> predicate);
    public A withOverrides(java.util.List<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> overrides);
    public A withOverrides(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride... overrides);
    public java.lang.Boolean hasOverrides();
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> addNewOverride();
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> addNewOverrideLike(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item);
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> setNewOverrideLike(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item);
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> editOverride(int index);
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> editFirstOverride();
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> editLastOverride();
    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> editMatchingOverride(java.util.function.Predicate<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> predicate);
    public java.lang.Integer getId();
    public A withId(java.lang.Integer id);
    public java.lang.Boolean hasId();
      
  /**
   * Configures persistent claim overrides for storage - allows to override storage class with per broker configuration
   */
  public interface OverridesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluent<io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<N>> {

            public N and();
            public N endOverride();    }


}
