package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Representation for persistent claim-based storage.
   */
  public class PersistentClaimStorageFluentImpl<A extends io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent<A> {

    private java.lang.String size;
    private java.lang.String storageClass;
    private java.util.Map<java.lang.String,java.lang.String> selector;
    private boolean deleteClaim;
    private java.util.List<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> overrides;
    private java.lang.Integer id;

    public PersistentClaimStorageFluentImpl() {
    }

    public PersistentClaimStorageFluentImpl(io.strimzi.api.kafka.model.storage.PersistentClaimStorage instance) {
        this.withSize(instance.getSize());
        
        this.withStorageClass(instance.getStorageClass());
        
        this.withSelector(instance.getSelector());
        
        this.withDeleteClaim(instance.isDeleteClaim());
        
        this.withOverrides(instance.getOverrides());
        
        this.withId(instance.getId());
    }

    public java.lang.String getSize() {
        return this.size;
    }

    public A withSize(java.lang.String size) {
        this.size=size; return (A) this;
    }

    public java.lang.Boolean hasSize() {
        return this.size != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSize instead.
     */
        public A withNewSize(java.lang.String original) {
        return (A)withSize(new String(original));
    }

    public java.lang.String getStorageClass() {
        return this.storageClass;
    }

    public A withStorageClass(java.lang.String storageClass) {
        this.storageClass=storageClass; return (A) this;
    }

    public java.lang.Boolean hasStorageClass() {
        return this.storageClass != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withStorageClass instead.
     */
        public A withNewStorageClass(java.lang.String original) {
        return (A)withStorageClass(new String(original));
    }

    public A addToSelector(java.lang.String key,java.lang.String value) {
        if(this.selector == null && key != null && value != null) { this.selector = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
    }

    public A addToSelector(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.selector == null && map != null) { this.selector = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(); }
        if(map != null) { this.selector.putAll(map);} return (A)this;
    }

    public A removeFromSelector(java.lang.String key) {
        if(this.selector == null) { return (A) this; }
        if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
    }

    public A removeFromSelector(java.util.Map<java.lang.String,java.lang.String> map) {
        if(this.selector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
    }

    public java.util.Map<java.lang.String,java.lang.String> getSelector() {
        return this.selector;
    }

    public <K,V>A withSelector(java.util.Map<java.lang.String,java.lang.String> selector) {
        if (selector == null) { this.selector =  null;} else {this.selector = new java.util.LinkedHashMap<java.lang.String,java.lang.String>(selector);} return (A) this;
    }

    public java.lang.Boolean hasSelector() {
        return this.selector != null;
    }

    public boolean isDeleteClaim() {
        return this.deleteClaim;
    }

    public A withDeleteClaim(boolean deleteClaim) {
        this.deleteClaim=deleteClaim; return (A) this;
    }

    public java.lang.Boolean hasDeleteClaim() {
        return true;
    }

    public A addToOverrides(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item) {
        if (this.overrides == null) {this.overrides = new java.util.ArrayList<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder>();}
        io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").add(index >= 0 ? index : _visitables.get("overrides").size(), builder);this.overrides.add(index >= 0 ? index : overrides.size(), builder); return (A)this;
    }

    public A setToOverrides(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item) {
        if (this.overrides == null) {this.overrides = new java.util.ArrayList<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder>();}
        io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder(item);
        if (index < 0 || index >= _visitables.get("overrides").size()) { _visitables.get("overrides").add(builder); } else { _visitables.get("overrides").set(index, builder);}
        if (index < 0 || index >= overrides.size()) { overrides.add(builder); } else { overrides.set(index, builder);}
         return (A)this;
    }

    public A addToOverrides(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride... items) {
        if (this.overrides == null) {this.overrides = new java.util.ArrayList<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder>();}
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item : items) {io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
    }

    public A addAllToOverrides(java.util.Collection<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> items) {
        if (this.overrides == null) {this.overrides = new java.util.ArrayList<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder>();}
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item : items) {io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").add(builder);this.overrides.add(builder);} return (A)this;
    }

    public A removeFromOverrides(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride... items) {
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item : items) {io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
    }

    public A removeAllFromOverrides(java.util.Collection<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> items) {
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item : items) {io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder(item);_visitables.get("overrides").remove(builder);if (this.overrides != null) {this.overrides.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromOverrides(java.util.function.Predicate<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> predicate) {
        if (overrides == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> each = overrides.iterator();
        final List visitables = _visitables.get("overrides");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildOverrides instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> getOverrides() {
        return build(overrides);
    }

    public java.util.List<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> buildOverrides() {
        return build(overrides);
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride buildOverride(int index) {
        return this.overrides.get(index).build();
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride buildFirstOverride() {
        return this.overrides.get(0).build();
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride buildLastOverride() {
        return this.overrides.get(overrides.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride buildMatchingOverride(java.util.function.Predicate<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> predicate) {
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder item: overrides) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingOverride(java.util.function.Predicate<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> predicate) {
        for (io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder item: overrides) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withOverrides(java.util.List<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride> overrides) {
        if (this.overrides != null) { _visitables.get("overrides").removeAll(this.overrides);}
        if (overrides != null) {this.overrides = new java.util.ArrayList<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder>(); for (io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item : overrides){this.addToOverrides(item);}} else { this.overrides = null;} return (A) this;
    }

    public A withOverrides(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride... overrides) {
        if (this.overrides != null) {this.overrides.clear();}
        if (overrides != null) {for (io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item :overrides){ this.addToOverrides(item);}} return (A) this;
    }

    public java.lang.Boolean hasOverrides() {
        return overrides != null && !overrides.isEmpty();
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> addNewOverride() {
        return new io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl.OverridesNestedImpl();
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> addNewOverrideLike(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item) {
        return new io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl.OverridesNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> setNewOverrideLike(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item) {
        return new io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl.OverridesNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> editOverride(int index) {
        if (overrides.size() <= index) throw new RuntimeException("Can't edit overrides. Index exceeds size.");
        return setNewOverrideLike(index, buildOverride(index));
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> editFirstOverride() {
        if (overrides.size() == 0) throw new RuntimeException("Can't edit first overrides. The list is empty.");
        return setNewOverrideLike(0, buildOverride(0));
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> editLastOverride() {
        int index = overrides.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last overrides. The list is empty.");
        return setNewOverrideLike(index, buildOverride(index));
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<A> editMatchingOverride(java.util.function.Predicate<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> predicate) {
        int index = -1;
        for (int i=0;i<overrides.size();i++) { 
        if (predicate.test(overrides.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching overrides. No match found.");
        return setNewOverrideLike(index, buildOverride(index));
    }

    public java.lang.Integer getId() {
        return this.id;
    }

    public A withId(java.lang.Integer id) {
        this.id=id; return (A) this;
    }

    public java.lang.Boolean hasId() {
        return this.id != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PersistentClaimStorageFluentImpl that = (PersistentClaimStorageFluentImpl) o;
        if (size != null ? !size.equals(that.size) :that.size != null) return false;
        if (storageClass != null ? !storageClass.equals(that.storageClass) :that.storageClass != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (deleteClaim != that.deleteClaim) return false;
        if (overrides != null ? !overrides.equals(that.overrides) :that.overrides != null) return false;
        if (id != null ? !id.equals(that.id) :that.id != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(size,  storageClass,  selector,  deleteClaim,  overrides,  id,  super.hashCode());
    }

      
  /**
   * Configures persistent claim overrides for storage - allows to override storage class with per broker configuration
   */
  public class OverridesNestedImpl<N> extends io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluentImpl<io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<N>> implements io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluent.OverridesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder builder;
        private final int index;

            OverridesNestedImpl(int index,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder(this, item);
                        
            }

            OverridesNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder(this);
                        
            }

            public N and() {
                return (N) PersistentClaimStorageFluentImpl.this.setToOverrides(index,builder.build());
            }

            public N endOverride() {
                return and();
            }
    }


}
