package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Configures persistent claim overrides for storage - allows to override storage class with per broker configuration
   */
  public class PersistentClaimStorageOverrideBuilder extends io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluentImpl<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideBuilder> {

    io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PersistentClaimStorageOverrideBuilder() {
        this(true);
    }

    public PersistentClaimStorageOverrideBuilder(java.lang.Boolean validationEnabled) {
        this(new PersistentClaimStorageOverride(), validationEnabled);
    }

    public PersistentClaimStorageOverrideBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluent<?> fluent) {
        this(fluent, true);
    }

    public PersistentClaimStorageOverrideBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PersistentClaimStorageOverride(), validationEnabled);
    }

    public PersistentClaimStorageOverrideBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluent<?> fluent,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride instance) {
        this(fluent, instance, true);
    }

    public PersistentClaimStorageOverrideBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluent<?> fluent,io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withBroker(instance.getBroker());
        
        fluent.withStorageClass(instance.getStorageClass());
        
        this.validationEnabled = validationEnabled; 
    }

    public PersistentClaimStorageOverrideBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride instance) {
        this(instance,true);
    }

    public PersistentClaimStorageOverrideBuilder(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withBroker(instance.getBroker());
        
        this.withStorageClass(instance.getStorageClass());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride build() {
        PersistentClaimStorageOverride buildable = new PersistentClaimStorageOverride();
        buildable.setBroker(fluent.getBroker());
        buildable.setStorageClass(fluent.getStorageClass());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PersistentClaimStorageOverrideBuilder that = (PersistentClaimStorageOverrideBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
