package io.strimzi.api.kafka.model.storage;

import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

  
  /**
   * Configures persistent claim overrides for storage - allows to override storage class with per broker configuration
   */
  public class PersistentClaimStorageOverrideFluentImpl<A extends io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverrideFluent<A> {

    private java.lang.Integer broker;
    private java.lang.String storageClass;

    public PersistentClaimStorageOverrideFluentImpl() {
    }

    public PersistentClaimStorageOverrideFluentImpl(io.strimzi.api.kafka.model.storage.PersistentClaimStorageOverride instance) {
        this.withBroker(instance.getBroker());
        
        this.withStorageClass(instance.getStorageClass());
    }

    public java.lang.Integer getBroker() {
        return this.broker;
    }

    public A withBroker(java.lang.Integer broker) {
        this.broker=broker; return (A) this;
    }

    public java.lang.Boolean hasBroker() {
        return this.broker != null;
    }

    public java.lang.String getStorageClass() {
        return this.storageClass;
    }

    public A withStorageClass(java.lang.String storageClass) {
        this.storageClass=storageClass; return (A) this;
    }

    public java.lang.Boolean hasStorageClass() {
        return this.storageClass != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withStorageClass instead.
     */
        public A withNewStorageClass(java.lang.String original) {
        return (A)withStorageClass(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PersistentClaimStorageOverrideFluentImpl that = (PersistentClaimStorageOverrideFluentImpl) o;
        if (broker != null ? !broker.equals(that.broker) :that.broker != null) return false;
        if (storageClass != null ? !storageClass.equals(that.storageClass) :that.storageClass != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(broker,  storageClass,  super.hashCode());
    }

}
