package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a BuildConfig template for Strimzi resources.
   */
  public class BuildConfigTemplateBuilder extends io.strimzi.api.kafka.model.template.BuildConfigTemplateFluentImpl<io.strimzi.api.kafka.model.template.BuildConfigTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.BuildConfigTemplate,io.strimzi.api.kafka.model.template.BuildConfigTemplateBuilder> {

    io.strimzi.api.kafka.model.template.BuildConfigTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public BuildConfigTemplateBuilder() {
        this(true);
    }

    public BuildConfigTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new BuildConfigTemplate(), validationEnabled);
    }

    public BuildConfigTemplateBuilder(io.strimzi.api.kafka.model.template.BuildConfigTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public BuildConfigTemplateBuilder(io.strimzi.api.kafka.model.template.BuildConfigTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new BuildConfigTemplate(), validationEnabled);
    }

    public BuildConfigTemplateBuilder(io.strimzi.api.kafka.model.template.BuildConfigTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.BuildConfigTemplate instance) {
        this(fluent, instance, true);
    }

    public BuildConfigTemplateBuilder(io.strimzi.api.kafka.model.template.BuildConfigTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.BuildConfigTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withPullSecret(instance.getPullSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public BuildConfigTemplateBuilder(io.strimzi.api.kafka.model.template.BuildConfigTemplate instance) {
        this(instance,true);
    }

    public BuildConfigTemplateBuilder(io.strimzi.api.kafka.model.template.BuildConfigTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMetadata(instance.getMetadata());
        
        this.withPullSecret(instance.getPullSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.BuildConfigTemplate build() {
        BuildConfigTemplate buildable = new BuildConfigTemplate();
        buildable.setMetadata(fluent.getMetadata());
        buildable.setPullSecret(fluent.getPullSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        BuildConfigTemplateBuilder that = (BuildConfigTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
