package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Strimzi containers.
   */
  public class ContainerTemplateBuilder extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.ContainerTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.ContainerTemplate,io.strimzi.api.kafka.model.template.ContainerTemplateBuilder> {

    io.strimzi.api.kafka.model.template.ContainerTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ContainerTemplateBuilder() {
        this(true);
    }

    public ContainerTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new ContainerTemplate(), validationEnabled);
    }

    public ContainerTemplateBuilder(io.strimzi.api.kafka.model.template.ContainerTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public ContainerTemplateBuilder(io.strimzi.api.kafka.model.template.ContainerTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ContainerTemplate(), validationEnabled);
    }

    public ContainerTemplateBuilder(io.strimzi.api.kafka.model.template.ContainerTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.ContainerTemplate instance) {
        this(fluent, instance, true);
    }

    public ContainerTemplateBuilder(io.strimzi.api.kafka.model.template.ContainerTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.ContainerTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withEnv(instance.getEnv());
        
        fluent.withSecurityContext(instance.getSecurityContext());
        
        this.validationEnabled = validationEnabled; 
    }

    public ContainerTemplateBuilder(io.strimzi.api.kafka.model.template.ContainerTemplate instance) {
        this(instance,true);
    }

    public ContainerTemplateBuilder(io.strimzi.api.kafka.model.template.ContainerTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withEnv(instance.getEnv());
        
        this.withSecurityContext(instance.getSecurityContext());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate build() {
        ContainerTemplate buildable = new ContainerTemplate();
        buildable.setEnv(fluent.getEnv());
        buildable.setSecurityContext(fluent.getSecurityContext());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ContainerTemplateBuilder that = (ContainerTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
