package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.strimzi.api.kafka.model.ContainerEnvVar;
import java.util.function.Predicate;
import io.strimzi.api.kafka.model.ContainerEnvVarBuilder;
import io.strimzi.api.kafka.model.ContainerEnvVarFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.SecurityContext;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Strimzi containers.
   */
  public class ContainerTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.ContainerTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.ContainerTemplateFluent<A> {

    private java.util.List<io.strimzi.api.kafka.model.ContainerEnvVarBuilder> env;
    private io.fabric8.kubernetes.api.model.SecurityContext securityContext;

    public ContainerTemplateFluentImpl() {
    }

    public ContainerTemplateFluentImpl(io.strimzi.api.kafka.model.template.ContainerTemplate instance) {
        this.withEnv(instance.getEnv());
        
        this.withSecurityContext(instance.getSecurityContext());
    }

    public A addToEnv(int index,io.strimzi.api.kafka.model.ContainerEnvVar item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.ContainerEnvVarBuilder>();}
        io.strimzi.api.kafka.model.ContainerEnvVarBuilder builder = new io.strimzi.api.kafka.model.ContainerEnvVarBuilder(item);_visitables.get("env").add(index >= 0 ? index : _visitables.get("env").size(), builder);this.env.add(index >= 0 ? index : env.size(), builder); return (A)this;
    }

    public A setToEnv(int index,io.strimzi.api.kafka.model.ContainerEnvVar item) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.ContainerEnvVarBuilder>();}
        io.strimzi.api.kafka.model.ContainerEnvVarBuilder builder = new io.strimzi.api.kafka.model.ContainerEnvVarBuilder(item);
        if (index < 0 || index >= _visitables.get("env").size()) { _visitables.get("env").add(builder); } else { _visitables.get("env").set(index, builder);}
        if (index < 0 || index >= env.size()) { env.add(builder); } else { env.set(index, builder);}
         return (A)this;
    }

    public A addToEnv(io.strimzi.api.kafka.model.ContainerEnvVar... items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.ContainerEnvVarBuilder>();}
        for (io.strimzi.api.kafka.model.ContainerEnvVar item : items) {io.strimzi.api.kafka.model.ContainerEnvVarBuilder builder = new io.strimzi.api.kafka.model.ContainerEnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A addAllToEnv(java.util.Collection<io.strimzi.api.kafka.model.ContainerEnvVar> items) {
        if (this.env == null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.ContainerEnvVarBuilder>();}
        for (io.strimzi.api.kafka.model.ContainerEnvVar item : items) {io.strimzi.api.kafka.model.ContainerEnvVarBuilder builder = new io.strimzi.api.kafka.model.ContainerEnvVarBuilder(item);_visitables.get("env").add(builder);this.env.add(builder);} return (A)this;
    }

    public A removeFromEnv(io.strimzi.api.kafka.model.ContainerEnvVar... items) {
        for (io.strimzi.api.kafka.model.ContainerEnvVar item : items) {io.strimzi.api.kafka.model.ContainerEnvVarBuilder builder = new io.strimzi.api.kafka.model.ContainerEnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeAllFromEnv(java.util.Collection<io.strimzi.api.kafka.model.ContainerEnvVar> items) {
        for (io.strimzi.api.kafka.model.ContainerEnvVar item : items) {io.strimzi.api.kafka.model.ContainerEnvVarBuilder builder = new io.strimzi.api.kafka.model.ContainerEnvVarBuilder(item);_visitables.get("env").remove(builder);if (this.env != null) {this.env.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.ContainerEnvVarBuilder> predicate) {
        if (env == null) return (A) this;
        final Iterator<io.strimzi.api.kafka.model.ContainerEnvVarBuilder> each = env.iterator();
        final List visitables = _visitables.get("env");
        while (each.hasNext()) {
          io.strimzi.api.kafka.model.ContainerEnvVarBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildEnv instead.
     * @return The buildable object.
     */
        public java.util.List<io.strimzi.api.kafka.model.ContainerEnvVar> getEnv() {
        return build(env);
    }

    public java.util.List<io.strimzi.api.kafka.model.ContainerEnvVar> buildEnv() {
        return build(env);
    }

    public io.strimzi.api.kafka.model.ContainerEnvVar buildEnv(int index) {
        return this.env.get(index).build();
    }

    public io.strimzi.api.kafka.model.ContainerEnvVar buildFirstEnv() {
        return this.env.get(0).build();
    }

    public io.strimzi.api.kafka.model.ContainerEnvVar buildLastEnv() {
        return this.env.get(env.size() - 1).build();
    }

    public io.strimzi.api.kafka.model.ContainerEnvVar buildMatchingEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.ContainerEnvVarBuilder> predicate) {
        for (io.strimzi.api.kafka.model.ContainerEnvVarBuilder item: env) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.ContainerEnvVarBuilder> predicate) {
        for (io.strimzi.api.kafka.model.ContainerEnvVarBuilder item: env) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withEnv(java.util.List<io.strimzi.api.kafka.model.ContainerEnvVar> env) {
        if (this.env != null) { _visitables.get("env").removeAll(this.env);}
        if (env != null) {this.env = new java.util.ArrayList<io.strimzi.api.kafka.model.ContainerEnvVarBuilder>(); for (io.strimzi.api.kafka.model.ContainerEnvVar item : env){this.addToEnv(item);}} else { this.env = null;} return (A) this;
    }

    public A withEnv(io.strimzi.api.kafka.model.ContainerEnvVar... env) {
        if (this.env != null) {this.env.clear();}
        if (env != null) {for (io.strimzi.api.kafka.model.ContainerEnvVar item :env){ this.addToEnv(item);}} return (A) this;
    }

    public java.lang.Boolean hasEnv() {
        return env != null && !env.isEmpty();
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplateFluent.EnvNested<A> addNewEnv() {
        return new io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl.EnvNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplateFluent.EnvNested<A> addNewEnvLike(io.strimzi.api.kafka.model.ContainerEnvVar item) {
        return new io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl.EnvNestedImpl(-1, item);
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplateFluent.EnvNested<A> setNewEnvLike(int index,io.strimzi.api.kafka.model.ContainerEnvVar item) {
        return new io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl.EnvNestedImpl(index, item);
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplateFluent.EnvNested<A> editEnv(int index) {
        if (env.size() <= index) throw new RuntimeException("Can't edit env. Index exceeds size.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplateFluent.EnvNested<A> editFirstEnv() {
        if (env.size() == 0) throw new RuntimeException("Can't edit first env. The list is empty.");
        return setNewEnvLike(0, buildEnv(0));
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplateFluent.EnvNested<A> editLastEnv() {
        int index = env.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last env. The list is empty.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplateFluent.EnvNested<A> editMatchingEnv(java.util.function.Predicate<io.strimzi.api.kafka.model.ContainerEnvVarBuilder> predicate) {
        int index = -1;
        for (int i=0;i<env.size();i++) { 
        if (predicate.test(env.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching env. No match found.");
        return setNewEnvLike(index, buildEnv(index));
    }

    public io.fabric8.kubernetes.api.model.SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(io.fabric8.kubernetes.api.model.SecurityContext securityContext) {
        this.securityContext=securityContext; return (A) this;
    }

    public java.lang.Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ContainerTemplateFluentImpl that = (ContainerTemplateFluentImpl) o;
        if (env != null ? !env.equals(that.env) :that.env != null) return false;
        if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(env,  securityContext,  super.hashCode());
    }

      
  /**
   * Representation for environment variables for Strimzi containers.
   */
  public class EnvNestedImpl<N> extends io.strimzi.api.kafka.model.ContainerEnvVarFluentImpl<io.strimzi.api.kafka.model.template.ContainerTemplateFluent.EnvNested<N>> implements io.strimzi.api.kafka.model.template.ContainerTemplateFluent.EnvNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.ContainerEnvVarBuilder builder;
        private final int index;

            EnvNestedImpl(int index,io.strimzi.api.kafka.model.ContainerEnvVar item) {
                this.index = index;
                this.builder = new io.strimzi.api.kafka.model.ContainerEnvVarBuilder(this, item);
                        
            }

            EnvNestedImpl() {
                this.index = -1;
                this.builder = new io.strimzi.api.kafka.model.ContainerEnvVarBuilder(this);
                        
            }

            public N and() {
                return (N) ContainerTemplateFluentImpl.this.setToEnv(index,builder.build());
            }

            public N endEnv() {
                return and();
            }
    }


}
