package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Cruise Control resources.
   */
  public class CruiseControlTemplateBuilder extends io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl<io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.CruiseControlTemplate,io.strimzi.api.kafka.model.template.CruiseControlTemplateBuilder> {

    io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public CruiseControlTemplateBuilder() {
        this(true);
    }

    public CruiseControlTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new CruiseControlTemplate(), validationEnabled);
    }

    public CruiseControlTemplateBuilder(io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public CruiseControlTemplateBuilder(io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new CruiseControlTemplate(), validationEnabled);
    }

    public CruiseControlTemplateBuilder(io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.CruiseControlTemplate instance) {
        this(fluent, instance, true);
    }

    public CruiseControlTemplateBuilder(io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.CruiseControlTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withApiService(instance.getApiService());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withCruiseControlContainer(instance.getCruiseControlContainer());
        
        fluent.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public CruiseControlTemplateBuilder(io.strimzi.api.kafka.model.template.CruiseControlTemplate instance) {
        this(instance,true);
    }

    public CruiseControlTemplateBuilder(io.strimzi.api.kafka.model.template.CruiseControlTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withCruiseControlContainer(instance.getCruiseControlContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplate build() {
        CruiseControlTemplate buildable = new CruiseControlTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setApiService(fluent.getApiService());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setCruiseControlContainer(fluent.getCruiseControlContainer());
        buildable.setTlsSidecarContainer(fluent.getTlsSidecarContainer());
        buildable.setServiceAccount(fluent.getServiceAccount());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CruiseControlTemplateBuilder that = (CruiseControlTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
