package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

  
  /**
   * Representation of a template for Cruise Control resources.
   */
  public class CruiseControlTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder deployment;
    private io.strimzi.api.kafka.model.template.PodTemplateBuilder pod;
    private io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder apiService;
    private io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder cruiseControlContainer;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder tlsSidecarContainer;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder serviceAccount;

    public CruiseControlTemplateFluentImpl() {
    }

    public CruiseControlTemplateFluentImpl(io.strimzi.api.kafka.model.template.CruiseControlTemplate instance) {
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withCruiseControlContainer(instance.getCruiseControlContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDeployment instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(io.strimzi.api.kafka.model.template.ResourceTemplate deployment) {
        _visitables.get("deployment").remove(this.deployment);
        if (deployment!=null){ this.deployment= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public java.lang.Boolean hasDeployment() {
        return this.deployment != null;
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.DeploymentNested<A> withNewDeployment() {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.DeploymentNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.DeploymentNested<A> withNewDeploymentLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.DeploymentNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.DeploymentNested<A> editDeployment() {
        return withNewDeploymentLike(getDeployment());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.DeploymentNested<A> editOrNewDeployment() {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPod instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(io.strimzi.api.kafka.model.template.PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new io.strimzi.api.kafka.model.template.PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public java.lang.Boolean hasPod() {
        return this.pod != null;
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodNested<A> withNewPod() {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.PodNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodNested<A> withNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.PodNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new io.strimzi.api.kafka.model.template.PodTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodNested<A> editOrNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildApiService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.InternalServiceTemplate getApiService() {
        return this.apiService!=null?this.apiService.build():null;
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplate buildApiService() {
        return this.apiService!=null?this.apiService.build():null;
    }

    public A withApiService(io.strimzi.api.kafka.model.template.InternalServiceTemplate apiService) {
        _visitables.get("apiService").remove(this.apiService);
        if (apiService!=null){ this.apiService= new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} return (A) this;
    }

    public java.lang.Boolean hasApiService() {
        return this.apiService != null;
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ApiServiceNested<A> withNewApiService() {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.ApiServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ApiServiceNested<A> withNewApiServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.ApiServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ApiServiceNested<A> editApiService() {
        return withNewApiServiceLike(getApiService());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ApiServiceNested<A> editOrNewApiService() {
        return withNewApiServiceLike(getApiService() != null ? getApiService(): new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ApiServiceNested<A> editOrNewApiServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return withNewApiServiceLike(getApiService() != null ? getApiService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodDisruptionBudget instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate podDisruptionBudget) {
        _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
        if (podDisruptionBudget!=null){ this.podDisruptionBudget= new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public java.lang.Boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.PodDisruptionBudgetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.PodDisruptionBudgetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildCruiseControlContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getCruiseControlContainer() {
        return this.cruiseControlContainer!=null?this.cruiseControlContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildCruiseControlContainer() {
        return this.cruiseControlContainer!=null?this.cruiseControlContainer.build():null;
    }

    public A withCruiseControlContainer(io.strimzi.api.kafka.model.template.ContainerTemplate cruiseControlContainer) {
        _visitables.get("cruiseControlContainer").remove(this.cruiseControlContainer);
        if (cruiseControlContainer!=null){ this.cruiseControlContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(cruiseControlContainer); _visitables.get("cruiseControlContainer").add(this.cruiseControlContainer);} return (A) this;
    }

    public java.lang.Boolean hasCruiseControlContainer() {
        return this.cruiseControlContainer != null;
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.CruiseControlContainerNested<A> withNewCruiseControlContainer() {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.CruiseControlContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.CruiseControlContainerNested<A> withNewCruiseControlContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.CruiseControlContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.CruiseControlContainerNested<A> editCruiseControlContainer() {
        return withNewCruiseControlContainerLike(getCruiseControlContainer());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.CruiseControlContainerNested<A> editOrNewCruiseControlContainer() {
        return withNewCruiseControlContainerLike(getCruiseControlContainer() != null ? getCruiseControlContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.CruiseControlContainerNested<A> editOrNewCruiseControlContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewCruiseControlContainerLike(getCruiseControlContainer() != null ? getCruiseControlContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsSidecarContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public A withTlsSidecarContainer(io.strimzi.api.kafka.model.template.ContainerTemplate tlsSidecarContainer) {
        _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer);
        if (tlsSidecarContainer!=null){ this.tlsSidecarContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(tlsSidecarContainer); _visitables.get("tlsSidecarContainer").add(this.tlsSidecarContainer);} return (A) this;
    }

    public java.lang.Boolean hasTlsSidecarContainer() {
        return this.tlsSidecarContainer != null;
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainer() {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.TlsSidecarContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.TlsSidecarContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.TlsSidecarContainerNested<A> editTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccount instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(io.strimzi.api.kafka.model.template.ResourceTemplate serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.ServiceAccountNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ServiceAccountNested<A> withNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.CruiseControlTemplateFluentImpl.ServiceAccountNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CruiseControlTemplateFluentImpl that = (CruiseControlTemplateFluentImpl) o;
        if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (apiService != null ? !apiService.equals(that.apiService) :that.apiService != null) return false;
        if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
        if (cruiseControlContainer != null ? !cruiseControlContainer.equals(that.cruiseControlContainer) :that.cruiseControlContainer != null) return false;
        if (tlsSidecarContainer != null ? !tlsSidecarContainer.equals(that.tlsSidecarContainer) :that.tlsSidecarContainer != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployment,  pod,  apiService,  podDisruptionBudget,  cruiseControlContainer,  tlsSidecarContainer,  serviceAccount,  super.hashCode());
    }

      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class DeploymentNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.DeploymentNested<N>> implements io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            DeploymentNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            DeploymentNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlTemplateFluentImpl.this.withDeployment(builder.build());
            }

            public N endDeployment() {
                return and();
            }
    }


      
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodNested<N>> implements io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodTemplateBuilder builder;

            PodNestedImpl(io.strimzi.api.kafka.model.template.PodTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi internal services.
   * It contains additional values applicable to internal services..
   */
  public class ApiServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl<io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ApiServiceNested<N>> implements io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ApiServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder builder;

            ApiServiceNestedImpl(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this, item);
                        
            }

            ApiServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlTemplateFluentImpl.this.withApiService(builder.build());
            }

            public N endApiService() {
                return and();
            }
    }


      
  /**
   * Representation of a Pod disruption Budget template template for Strimzi resources.
   */
  public class PodDisruptionBudgetNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateFluentImpl<io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodDisruptionBudgetNested<N>> implements io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder builder;

            PodDisruptionBudgetNestedImpl(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this, item);
                        
            }

            PodDisruptionBudgetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
            }

            public N endPodDisruptionBudget() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class CruiseControlContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.CruiseControlContainerNested<N>> implements io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.CruiseControlContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            CruiseControlContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            CruiseControlContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlTemplateFluentImpl.this.withCruiseControlContainer(builder.build());
            }

            public N endCruiseControlContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class TlsSidecarContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.TlsSidecarContainerNested<N>> implements io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.TlsSidecarContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            TlsSidecarContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            TlsSidecarContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlTemplateFluentImpl.this.withTlsSidecarContainer(builder.build());
            }

            public N endTlsSidecarContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ServiceAccountNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ServiceAccountNested<N>> implements io.strimzi.api.kafka.model.template.CruiseControlTemplateFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ServiceAccountNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ServiceAccountNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) CruiseControlTemplateFluentImpl.this.withServiceAccount(builder.build());
            }

            public N endServiceAccount() {
                return and();
            }
    }


}
