package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Strimzi resources.
   */
  public class DeploymentTemplateBuilder extends io.strimzi.api.kafka.model.template.DeploymentTemplateFluentImpl<io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.DeploymentTemplate,io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder> {

    io.strimzi.api.kafka.model.template.DeploymentTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public DeploymentTemplateBuilder() {
        this(true);
    }

    public DeploymentTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new DeploymentTemplate(), validationEnabled);
    }

    public DeploymentTemplateBuilder(io.strimzi.api.kafka.model.template.DeploymentTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public DeploymentTemplateBuilder(io.strimzi.api.kafka.model.template.DeploymentTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new DeploymentTemplate(), validationEnabled);
    }

    public DeploymentTemplateBuilder(io.strimzi.api.kafka.model.template.DeploymentTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.DeploymentTemplate instance) {
        this(fluent, instance, true);
    }

    public DeploymentTemplateBuilder(io.strimzi.api.kafka.model.template.DeploymentTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.DeploymentTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withDeploymentStrategy(instance.getDeploymentStrategy());
        
        this.validationEnabled = validationEnabled; 
    }

    public DeploymentTemplateBuilder(io.strimzi.api.kafka.model.template.DeploymentTemplate instance) {
        this(instance,true);
    }

    public DeploymentTemplateBuilder(io.strimzi.api.kafka.model.template.DeploymentTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMetadata(instance.getMetadata());
        
        this.withDeploymentStrategy(instance.getDeploymentStrategy());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.DeploymentTemplate build() {
        DeploymentTemplate buildable = new DeploymentTemplate();
        buildable.setMetadata(fluent.getMetadata());
        buildable.setDeploymentStrategy(fluent.getDeploymentStrategy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        DeploymentTemplateBuilder that = (DeploymentTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
