package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Entity Operator resources.
   */
  public class EntityOperatorTemplateBuilder extends io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl<io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.EntityOperatorTemplate,io.strimzi.api.kafka.model.template.EntityOperatorTemplateBuilder> {

    io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public EntityOperatorTemplateBuilder() {
        this(true);
    }

    public EntityOperatorTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new EntityOperatorTemplate(), validationEnabled);
    }

    public EntityOperatorTemplateBuilder(io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public EntityOperatorTemplateBuilder(io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new EntityOperatorTemplate(), validationEnabled);
    }

    public EntityOperatorTemplateBuilder(io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.EntityOperatorTemplate instance) {
        this(fluent, instance, true);
    }

    public EntityOperatorTemplateBuilder(io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.EntityOperatorTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withTopicOperatorContainer(instance.getTopicOperatorContainer());
        
        fluent.withUserOperatorContainer(instance.getUserOperatorContainer());
        
        fluent.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public EntityOperatorTemplateBuilder(io.strimzi.api.kafka.model.template.EntityOperatorTemplate instance) {
        this(instance,true);
    }

    public EntityOperatorTemplateBuilder(io.strimzi.api.kafka.model.template.EntityOperatorTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withTopicOperatorContainer(instance.getTopicOperatorContainer());
        
        this.withUserOperatorContainer(instance.getUserOperatorContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplate build() {
        EntityOperatorTemplate buildable = new EntityOperatorTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setTopicOperatorContainer(fluent.getTopicOperatorContainer());
        buildable.setUserOperatorContainer(fluent.getUserOperatorContainer());
        buildable.setTlsSidecarContainer(fluent.getTlsSidecarContainer());
        buildable.setServiceAccount(fluent.getServiceAccount());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        EntityOperatorTemplateBuilder that = (EntityOperatorTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
