package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

  
  /**
   * Representation of a template for Entity Operator resources.
   */
  public class EntityOperatorTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder deployment;
    private io.strimzi.api.kafka.model.template.PodTemplateBuilder pod;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder topicOperatorContainer;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder userOperatorContainer;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder tlsSidecarContainer;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder serviceAccount;

    public EntityOperatorTemplateFluentImpl() {
    }

    public EntityOperatorTemplateFluentImpl(io.strimzi.api.kafka.model.template.EntityOperatorTemplate instance) {
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withTopicOperatorContainer(instance.getTopicOperatorContainer());
        
        this.withUserOperatorContainer(instance.getUserOperatorContainer());
        
        this.withTlsSidecarContainer(instance.getTlsSidecarContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDeployment instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(io.strimzi.api.kafka.model.template.ResourceTemplate deployment) {
        _visitables.get("deployment").remove(this.deployment);
        if (deployment!=null){ this.deployment= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public java.lang.Boolean hasDeployment() {
        return this.deployment != null;
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.DeploymentNested<A> withNewDeployment() {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.DeploymentNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.DeploymentNested<A> withNewDeploymentLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.DeploymentNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.DeploymentNested<A> editDeployment() {
        return withNewDeploymentLike(getDeployment());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.DeploymentNested<A> editOrNewDeployment() {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPod instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(io.strimzi.api.kafka.model.template.PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new io.strimzi.api.kafka.model.template.PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public java.lang.Boolean hasPod() {
        return this.pod != null;
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.PodNested<A> withNewPod() {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.PodNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.PodNested<A> withNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.PodNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new io.strimzi.api.kafka.model.template.PodTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.PodNested<A> editOrNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTopicOperatorContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getTopicOperatorContainer() {
        return this.topicOperatorContainer!=null?this.topicOperatorContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildTopicOperatorContainer() {
        return this.topicOperatorContainer!=null?this.topicOperatorContainer.build():null;
    }

    public A withTopicOperatorContainer(io.strimzi.api.kafka.model.template.ContainerTemplate topicOperatorContainer) {
        _visitables.get("topicOperatorContainer").remove(this.topicOperatorContainer);
        if (topicOperatorContainer!=null){ this.topicOperatorContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(topicOperatorContainer); _visitables.get("topicOperatorContainer").add(this.topicOperatorContainer);} return (A) this;
    }

    public java.lang.Boolean hasTopicOperatorContainer() {
        return this.topicOperatorContainer != null;
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> withNewTopicOperatorContainer() {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.TopicOperatorContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> withNewTopicOperatorContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.TopicOperatorContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> editTopicOperatorContainer() {
        return withNewTopicOperatorContainerLike(getTopicOperatorContainer());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> editOrNewTopicOperatorContainer() {
        return withNewTopicOperatorContainerLike(getTopicOperatorContainer() != null ? getTopicOperatorContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TopicOperatorContainerNested<A> editOrNewTopicOperatorContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewTopicOperatorContainerLike(getTopicOperatorContainer() != null ? getTopicOperatorContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildUserOperatorContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getUserOperatorContainer() {
        return this.userOperatorContainer!=null?this.userOperatorContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildUserOperatorContainer() {
        return this.userOperatorContainer!=null?this.userOperatorContainer.build():null;
    }

    public A withUserOperatorContainer(io.strimzi.api.kafka.model.template.ContainerTemplate userOperatorContainer) {
        _visitables.get("userOperatorContainer").remove(this.userOperatorContainer);
        if (userOperatorContainer!=null){ this.userOperatorContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(userOperatorContainer); _visitables.get("userOperatorContainer").add(this.userOperatorContainer);} return (A) this;
    }

    public java.lang.Boolean hasUserOperatorContainer() {
        return this.userOperatorContainer != null;
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.UserOperatorContainerNested<A> withNewUserOperatorContainer() {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.UserOperatorContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.UserOperatorContainerNested<A> withNewUserOperatorContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.UserOperatorContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.UserOperatorContainerNested<A> editUserOperatorContainer() {
        return withNewUserOperatorContainerLike(getUserOperatorContainer());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.UserOperatorContainerNested<A> editOrNewUserOperatorContainer() {
        return withNewUserOperatorContainerLike(getUserOperatorContainer() != null ? getUserOperatorContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.UserOperatorContainerNested<A> editOrNewUserOperatorContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewUserOperatorContainerLike(getUserOperatorContainer() != null ? getUserOperatorContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildTlsSidecarContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildTlsSidecarContainer() {
        return this.tlsSidecarContainer!=null?this.tlsSidecarContainer.build():null;
    }

    public A withTlsSidecarContainer(io.strimzi.api.kafka.model.template.ContainerTemplate tlsSidecarContainer) {
        _visitables.get("tlsSidecarContainer").remove(this.tlsSidecarContainer);
        if (tlsSidecarContainer!=null){ this.tlsSidecarContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(tlsSidecarContainer); _visitables.get("tlsSidecarContainer").add(this.tlsSidecarContainer);} return (A) this;
    }

    public java.lang.Boolean hasTlsSidecarContainer() {
        return this.tlsSidecarContainer != null;
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainer() {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.TlsSidecarContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> withNewTlsSidecarContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.TlsSidecarContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> editTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainer() {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TlsSidecarContainerNested<A> editOrNewTlsSidecarContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewTlsSidecarContainerLike(getTlsSidecarContainer() != null ? getTlsSidecarContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccount instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(io.strimzi.api.kafka.model.template.ResourceTemplate serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.ServiceAccountNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.ServiceAccountNested<A> withNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluentImpl.ServiceAccountNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        EntityOperatorTemplateFluentImpl that = (EntityOperatorTemplateFluentImpl) o;
        if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (topicOperatorContainer != null ? !topicOperatorContainer.equals(that.topicOperatorContainer) :that.topicOperatorContainer != null) return false;
        if (userOperatorContainer != null ? !userOperatorContainer.equals(that.userOperatorContainer) :that.userOperatorContainer != null) return false;
        if (tlsSidecarContainer != null ? !tlsSidecarContainer.equals(that.tlsSidecarContainer) :that.tlsSidecarContainer != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployment,  pod,  topicOperatorContainer,  userOperatorContainer,  tlsSidecarContainer,  serviceAccount,  super.hashCode());
    }

      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class DeploymentNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.DeploymentNested<N>> implements io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            DeploymentNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            DeploymentNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withDeployment(builder.build());
            }

            public N endDeployment() {
                return and();
            }
    }


      
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.PodNested<N>> implements io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodTemplateBuilder builder;

            PodNestedImpl(io.strimzi.api.kafka.model.template.PodTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class TopicOperatorContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TopicOperatorContainerNested<N>> implements io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TopicOperatorContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            TopicOperatorContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            TopicOperatorContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withTopicOperatorContainer(builder.build());
            }

            public N endTopicOperatorContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class UserOperatorContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.UserOperatorContainerNested<N>> implements io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.UserOperatorContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            UserOperatorContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            UserOperatorContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withUserOperatorContainer(builder.build());
            }

            public N endUserOperatorContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class TlsSidecarContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TlsSidecarContainerNested<N>> implements io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.TlsSidecarContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            TlsSidecarContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            TlsSidecarContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withTlsSidecarContainer(builder.build());
            }

            public N endTlsSidecarContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ServiceAccountNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.ServiceAccountNested<N>> implements io.strimzi.api.kafka.model.template.EntityOperatorTemplateFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ServiceAccountNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ServiceAccountNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) EntityOperatorTemplateFluentImpl.this.withServiceAccount(builder.build());
            }

            public N endServiceAccount() {
                return and();
            }
    }


}
