package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Strimzi internal services.
   * It contains additional values applicable to internal services..
   */
  public class InternalServiceTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.MetadataTemplateBuilder metadata;
    private io.strimzi.api.kafka.model.template.IpFamilyPolicy ipFamilyPolicy;
    private java.util.List<io.strimzi.api.kafka.model.template.IpFamily> ipFamilies;

    public InternalServiceTemplateFluentImpl() {
    }

    public InternalServiceTemplateFluentImpl(io.strimzi.api.kafka.model.template.InternalServiceTemplate instance) {
        this.withMetadata(instance.getMetadata());
        
        this.withIpFamilyPolicy(instance.getIpFamilyPolicy());
        
        this.withIpFamilies(instance.getIpFamilies());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.MetadataTemplate getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.strimzi.api.kafka.model.template.MetadataTemplate buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.strimzi.api.kafka.model.template.MetadataTemplate metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.strimzi.api.kafka.model.template.MetadataTemplateBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent.MetadataNested<A> withNewMetadata() {
        return new io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl.MetadataNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent.MetadataNested<A> withNewMetadataLike(io.strimzi.api.kafka.model.template.MetadataTemplate item) {
        return new io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl.MetadataNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.strimzi.api.kafka.model.template.MetadataTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent.MetadataNested<A> editOrNewMetadataLike(io.strimzi.api.kafka.model.template.MetadataTemplate item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public io.strimzi.api.kafka.model.template.IpFamilyPolicy getIpFamilyPolicy() {
        return this.ipFamilyPolicy;
    }

    public A withIpFamilyPolicy(io.strimzi.api.kafka.model.template.IpFamilyPolicy ipFamilyPolicy) {
        this.ipFamilyPolicy=ipFamilyPolicy; return (A) this;
    }

    public java.lang.Boolean hasIpFamilyPolicy() {
        return this.ipFamilyPolicy != null;
    }

    public A addToIpFamilies(int index,io.strimzi.api.kafka.model.template.IpFamily item) {
        if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>();}
        this.ipFamilies.add(index, item);
        return (A)this;
    }

    public A setToIpFamilies(int index,io.strimzi.api.kafka.model.template.IpFamily item) {
        if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>();}
        this.ipFamilies.set(index, item); return (A)this;
    }

    public A addToIpFamilies(io.strimzi.api.kafka.model.template.IpFamily... items) {
        if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>();}
        for (io.strimzi.api.kafka.model.template.IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A addAllToIpFamilies(java.util.Collection<io.strimzi.api.kafka.model.template.IpFamily> items) {
        if (this.ipFamilies == null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>();}
        for (io.strimzi.api.kafka.model.template.IpFamily item : items) {this.ipFamilies.add(item);} return (A)this;
    }

    public A removeFromIpFamilies(io.strimzi.api.kafka.model.template.IpFamily... items) {
        for (io.strimzi.api.kafka.model.template.IpFamily item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public A removeAllFromIpFamilies(java.util.Collection<io.strimzi.api.kafka.model.template.IpFamily> items) {
        for (io.strimzi.api.kafka.model.template.IpFamily item : items) {if (this.ipFamilies!= null){ this.ipFamilies.remove(item);}} return (A)this;
    }

    public java.util.List<io.strimzi.api.kafka.model.template.IpFamily> getIpFamilies() {
        return this.ipFamilies;
    }

    public io.strimzi.api.kafka.model.template.IpFamily getIpFamily(int index) {
        return this.ipFamilies.get(index);
    }

    public io.strimzi.api.kafka.model.template.IpFamily getFirstIpFamily() {
        return this.ipFamilies.get(0);
    }

    public io.strimzi.api.kafka.model.template.IpFamily getLastIpFamily() {
        return this.ipFamilies.get(ipFamilies.size() - 1);
    }

    public io.strimzi.api.kafka.model.template.IpFamily getMatchingIpFamily(java.util.function.Predicate<io.strimzi.api.kafka.model.template.IpFamily> predicate) {
        for (io.strimzi.api.kafka.model.template.IpFamily item: ipFamilies) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingIpFamily(java.util.function.Predicate<io.strimzi.api.kafka.model.template.IpFamily> predicate) {
        for (io.strimzi.api.kafka.model.template.IpFamily item: ipFamilies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withIpFamilies(java.util.List<io.strimzi.api.kafka.model.template.IpFamily> ipFamilies) {
        if (this.ipFamilies != null) { _visitables.get("ipFamilies").removeAll(this.ipFamilies);}
        if (ipFamilies != null) {this.ipFamilies = new java.util.ArrayList<io.strimzi.api.kafka.model.template.IpFamily>(); for (io.strimzi.api.kafka.model.template.IpFamily item : ipFamilies){this.addToIpFamilies(item);}} else { this.ipFamilies = null;} return (A) this;
    }

    public A withIpFamilies(io.strimzi.api.kafka.model.template.IpFamily... ipFamilies) {
        if (this.ipFamilies != null) {this.ipFamilies.clear();}
        if (ipFamilies != null) {for (io.strimzi.api.kafka.model.template.IpFamily item :ipFamilies){ this.addToIpFamilies(item);}} return (A) this;
    }

    public java.lang.Boolean hasIpFamilies() {
        return ipFamilies != null && !ipFamilies.isEmpty();
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        InternalServiceTemplateFluentImpl that = (InternalServiceTemplateFluentImpl) o;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (ipFamilyPolicy != null ? !ipFamilyPolicy.equals(that.ipFamilyPolicy) :that.ipFamilyPolicy != null) return false;
        if (ipFamilies != null ? !ipFamilies.equals(that.ipFamilies) :that.ipFamilies != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metadata,  ipFamilyPolicy,  ipFamilies,  super.hashCode());
    }

      
  /**
   * Representation of a Metadata template for Strimzi pods, statefulsets, deployments and services.
   */
  public class MetadataNestedImpl<N> extends io.strimzi.api.kafka.model.template.MetadataTemplateFluentImpl<io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent.MetadataNested<N>> implements io.strimzi.api.kafka.model.template.InternalServiceTemplateFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.MetadataTemplateBuilder builder;

            MetadataNestedImpl(io.strimzi.api.kafka.model.template.MetadataTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.MetadataTemplateBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.MetadataTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) InternalServiceTemplateFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
