package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation for options to define where and how information will be pushed to remote sources of information
   */
  public class JmxTransOutputDefinitionTemplateBuilder extends io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluentImpl<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate,io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateBuilder> {

    io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public JmxTransOutputDefinitionTemplateBuilder() {
        this(true);
    }

    public JmxTransOutputDefinitionTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new JmxTransOutputDefinitionTemplate(), validationEnabled);
    }

    public JmxTransOutputDefinitionTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public JmxTransOutputDefinitionTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new JmxTransOutputDefinitionTemplate(), validationEnabled);
    }

    public JmxTransOutputDefinitionTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate instance) {
        this(fluent, instance, true);
    }

    public JmxTransOutputDefinitionTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withOutputType(instance.getOutputType());
        
        fluent.withHost(instance.getHost());
        
        fluent.withPort(instance.getPort());
        
        fluent.withFlushDelayInSeconds(instance.getFlushDelayInSeconds());
        
        fluent.withName(instance.getName());
        
        fluent.withTypeNames(instance.getTypeNames());
        
        this.validationEnabled = validationEnabled; 
    }

    public JmxTransOutputDefinitionTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate instance) {
        this(instance,true);
    }

    public JmxTransOutputDefinitionTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withOutputType(instance.getOutputType());
        
        this.withHost(instance.getHost());
        
        this.withPort(instance.getPort());
        
        this.withFlushDelayInSeconds(instance.getFlushDelayInSeconds());
        
        this.withName(instance.getName());
        
        this.withTypeNames(instance.getTypeNames());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate build() {
        JmxTransOutputDefinitionTemplate buildable = new JmxTransOutputDefinitionTemplate();
        buildable.setOutputType(fluent.getOutputType());
        buildable.setHost(fluent.getHost());
        buildable.setPort(fluent.getPort());
        buildable.setFlushDelayInSeconds(fluent.getFlushDelayInSeconds());
        buildable.setName(fluent.getName());
        buildable.setTypeNames(fluent.getTypeNames());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JmxTransOutputDefinitionTemplateBuilder that = (JmxTransOutputDefinitionTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
