package io.strimzi.api.kafka.model.template;

import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

  
  /**
   * Representation for options to define where and how information will be pushed to remote sources of information
   */
  public class JmxTransOutputDefinitionTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplateFluent<A> {

    private java.lang.String outputType;
    private java.lang.String host;
    private java.lang.Integer port;
    private java.lang.Integer flushDelayInSeconds;
    private java.lang.String name;
    private java.util.List<java.lang.String> typeNames;

    public JmxTransOutputDefinitionTemplateFluentImpl() {
    }

    public JmxTransOutputDefinitionTemplateFluentImpl(io.strimzi.api.kafka.model.template.JmxTransOutputDefinitionTemplate instance) {
        this.withOutputType(instance.getOutputType());
        
        this.withHost(instance.getHost());
        
        this.withPort(instance.getPort());
        
        this.withFlushDelayInSeconds(instance.getFlushDelayInSeconds());
        
        this.withName(instance.getName());
        
        this.withTypeNames(instance.getTypeNames());
    }

    public java.lang.String getOutputType() {
        return this.outputType;
    }

    public A withOutputType(java.lang.String outputType) {
        this.outputType=outputType; return (A) this;
    }

    public java.lang.Boolean hasOutputType() {
        return this.outputType != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withOutputType instead.
     */
        public A withNewOutputType(java.lang.String original) {
        return (A)withOutputType(new String(original));
    }

    public java.lang.String getHost() {
        return this.host;
    }

    public A withHost(java.lang.String host) {
        this.host=host; return (A) this;
    }

    public java.lang.Boolean hasHost() {
        return this.host != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withHost instead.
     */
        public A withNewHost(java.lang.String original) {
        return (A)withHost(new String(original));
    }

    public java.lang.Integer getPort() {
        return this.port;
    }

    public A withPort(java.lang.Integer port) {
        this.port=port; return (A) this;
    }

    public java.lang.Boolean hasPort() {
        return this.port != null;
    }

    public java.lang.Integer getFlushDelayInSeconds() {
        return this.flushDelayInSeconds;
    }

    public A withFlushDelayInSeconds(java.lang.Integer flushDelayInSeconds) {
        this.flushDelayInSeconds=flushDelayInSeconds; return (A) this;
    }

    public java.lang.Boolean hasFlushDelayInSeconds() {
        return this.flushDelayInSeconds != null;
    }

    public java.lang.String getName() {
        return this.name;
    }

    public A withName(java.lang.String name) {
        this.name=name; return (A) this;
    }

    public java.lang.Boolean hasName() {
        return this.name != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withName instead.
     */
        public A withNewName(java.lang.String original) {
        return (A)withName(new String(original));
    }

    public A addToTypeNames(int index,java.lang.String item) {
        if (this.typeNames == null) {this.typeNames = new java.util.ArrayList<java.lang.String>();}
        this.typeNames.add(index, item);
        return (A)this;
    }

    public A setToTypeNames(int index,java.lang.String item) {
        if (this.typeNames == null) {this.typeNames = new java.util.ArrayList<java.lang.String>();}
        this.typeNames.set(index, item); return (A)this;
    }

    public A addToTypeNames(java.lang.String... items) {
        if (this.typeNames == null) {this.typeNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.typeNames.add(item);} return (A)this;
    }

    public A addAllToTypeNames(java.util.Collection<java.lang.String> items) {
        if (this.typeNames == null) {this.typeNames = new java.util.ArrayList<java.lang.String>();}
        for (java.lang.String item : items) {this.typeNames.add(item);} return (A)this;
    }

    public A removeFromTypeNames(java.lang.String... items) {
        for (java.lang.String item : items) {if (this.typeNames!= null){ this.typeNames.remove(item);}} return (A)this;
    }

    public A removeAllFromTypeNames(java.util.Collection<java.lang.String> items) {
        for (java.lang.String item : items) {if (this.typeNames!= null){ this.typeNames.remove(item);}} return (A)this;
    }

    public java.util.List<java.lang.String> getTypeNames() {
        return this.typeNames;
    }

    public java.lang.String getTypeName(int index) {
        return this.typeNames.get(index);
    }

    public java.lang.String getFirstTypeName() {
        return this.typeNames.get(0);
    }

    public java.lang.String getLastTypeName() {
        return this.typeNames.get(typeNames.size() - 1);
    }

    public java.lang.String getMatchingTypeName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: typeNames) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingTypeName(java.util.function.Predicate<java.lang.String> predicate) {
        for (java.lang.String item: typeNames) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTypeNames(java.util.List<java.lang.String> typeNames) {
        if (this.typeNames != null) { _visitables.get("typeNames").removeAll(this.typeNames);}
        if (typeNames != null) {this.typeNames = new java.util.ArrayList<java.lang.String>(); for (java.lang.String item : typeNames){this.addToTypeNames(item);}} else { this.typeNames = null;} return (A) this;
    }

    public A withTypeNames(java.lang.String... typeNames) {
        if (this.typeNames != null) {this.typeNames.clear();}
        if (typeNames != null) {for (java.lang.String item :typeNames){ this.addToTypeNames(item);}} return (A) this;
    }

    public java.lang.Boolean hasTypeNames() {
        return typeNames != null && !typeNames.isEmpty();
    }

    public A addNewTypeName(java.lang.String original) {
        return (A)addToTypeNames(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        JmxTransOutputDefinitionTemplateFluentImpl that = (JmxTransOutputDefinitionTemplateFluentImpl) o;
        if (outputType != null ? !outputType.equals(that.outputType) :that.outputType != null) return false;
        if (host != null ? !host.equals(that.host) :that.host != null) return false;
        if (port != null ? !port.equals(that.port) :that.port != null) return false;
        if (flushDelayInSeconds != null ? !flushDelayInSeconds.equals(that.flushDelayInSeconds) :that.flushDelayInSeconds != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (typeNames != null ? !typeNames.equals(that.typeNames) :that.typeNames != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(outputType,  host,  port,  flushDelayInSeconds,  name,  typeNames,  super.hashCode());
    }

}
