package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for JmxTrans resources.
   */
  public class JmxTransTemplateBuilder extends io.strimzi.api.kafka.model.template.JmxTransTemplateFluentImpl<io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.JmxTransTemplate,io.strimzi.api.kafka.model.template.JmxTransTemplateBuilder> {

    io.strimzi.api.kafka.model.template.JmxTransTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public JmxTransTemplateBuilder() {
        this(true);
    }

    public JmxTransTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new JmxTransTemplate(), validationEnabled);
    }

    public JmxTransTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public JmxTransTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new JmxTransTemplate(), validationEnabled);
    }

    public JmxTransTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.JmxTransTemplate instance) {
        this(fluent, instance, true);
    }

    public JmxTransTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.JmxTransTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withContainer(instance.getContainer());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public JmxTransTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransTemplate instance) {
        this(instance,true);
    }

    public JmxTransTemplateBuilder(io.strimzi.api.kafka.model.template.JmxTransTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withContainer(instance.getContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.JmxTransTemplate build() {
        JmxTransTemplate buildable = new JmxTransTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setContainer(fluent.getContainer());
        buildable.setServiceAccount(fluent.getServiceAccount());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JmxTransTemplateBuilder that = (JmxTransTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
