package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Kafka Bridge resources.
   */
  public class KafkaBridgeTemplateBuilder extends io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.KafkaBridgeTemplate,io.strimzi.api.kafka.model.template.KafkaBridgeTemplateBuilder> {

    io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaBridgeTemplateBuilder() {
        this(true);
    }

    public KafkaBridgeTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaBridgeTemplate(), validationEnabled);
    }

    public KafkaBridgeTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaBridgeTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaBridgeTemplate(), validationEnabled);
    }

    public KafkaBridgeTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaBridgeTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaBridgeTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaBridgeTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withApiService(instance.getApiService());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withBridgeContainer(instance.getBridgeContainer());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaBridgeTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate instance) {
        this(instance,true);
    }

    public KafkaBridgeTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withBridgeContainer(instance.getBridgeContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplate build() {
        KafkaBridgeTemplate buildable = new KafkaBridgeTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setApiService(fluent.getApiService());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setBridgeContainer(fluent.getBridgeContainer());
        buildable.setServiceAccount(fluent.getServiceAccount());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaBridgeTemplateBuilder that = (KafkaBridgeTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
