package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

  
  /**
   * Representation of a template for Kafka Bridge resources.
   */
  public class KafkaBridgeTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder deployment;
    private io.strimzi.api.kafka.model.template.PodTemplateBuilder pod;
    private io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder apiService;
    private io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder bridgeContainer;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder serviceAccount;

    public KafkaBridgeTemplateFluentImpl() {
    }

    public KafkaBridgeTemplateFluentImpl(io.strimzi.api.kafka.model.template.KafkaBridgeTemplate instance) {
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withBridgeContainer(instance.getBridgeContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDeployment instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.DeploymentTemplate getDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public io.strimzi.api.kafka.model.template.DeploymentTemplate buildDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(io.strimzi.api.kafka.model.template.DeploymentTemplate deployment) {
        _visitables.get("deployment").remove(this.deployment);
        if (deployment!=null){ this.deployment= new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public java.lang.Boolean hasDeployment() {
        return this.deployment != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.DeploymentNested<A> withNewDeployment() {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.DeploymentNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.DeploymentNested<A> withNewDeploymentLike(io.strimzi.api.kafka.model.template.DeploymentTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.DeploymentNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.DeploymentNested<A> editDeployment() {
        return withNewDeploymentLike(getDeployment());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.DeploymentNested<A> editOrNewDeployment() {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(io.strimzi.api.kafka.model.template.DeploymentTemplate item) {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPod instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(io.strimzi.api.kafka.model.template.PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new io.strimzi.api.kafka.model.template.PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public java.lang.Boolean hasPod() {
        return this.pod != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodNested<A> withNewPod() {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.PodNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodNested<A> withNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.PodNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new io.strimzi.api.kafka.model.template.PodTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodNested<A> editOrNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildApiService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.InternalServiceTemplate getApiService() {
        return this.apiService!=null?this.apiService.build():null;
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplate buildApiService() {
        return this.apiService!=null?this.apiService.build():null;
    }

    public A withApiService(io.strimzi.api.kafka.model.template.InternalServiceTemplate apiService) {
        _visitables.get("apiService").remove(this.apiService);
        if (apiService!=null){ this.apiService= new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} return (A) this;
    }

    public java.lang.Boolean hasApiService() {
        return this.apiService != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ApiServiceNested<A> withNewApiService() {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.ApiServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ApiServiceNested<A> withNewApiServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.ApiServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ApiServiceNested<A> editApiService() {
        return withNewApiServiceLike(getApiService());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ApiServiceNested<A> editOrNewApiService() {
        return withNewApiServiceLike(getApiService() != null ? getApiService(): new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ApiServiceNested<A> editOrNewApiServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return withNewApiServiceLike(getApiService() != null ? getApiService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodDisruptionBudget instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate podDisruptionBudget) {
        _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
        if (podDisruptionBudget!=null){ this.podDisruptionBudget= new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public java.lang.Boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.PodDisruptionBudgetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.PodDisruptionBudgetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBridgeContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getBridgeContainer() {
        return this.bridgeContainer!=null?this.bridgeContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildBridgeContainer() {
        return this.bridgeContainer!=null?this.bridgeContainer.build():null;
    }

    public A withBridgeContainer(io.strimzi.api.kafka.model.template.ContainerTemplate bridgeContainer) {
        _visitables.get("bridgeContainer").remove(this.bridgeContainer);
        if (bridgeContainer!=null){ this.bridgeContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(bridgeContainer); _visitables.get("bridgeContainer").add(this.bridgeContainer);} return (A) this;
    }

    public java.lang.Boolean hasBridgeContainer() {
        return this.bridgeContainer != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.BridgeContainerNested<A> withNewBridgeContainer() {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.BridgeContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.BridgeContainerNested<A> withNewBridgeContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.BridgeContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.BridgeContainerNested<A> editBridgeContainer() {
        return withNewBridgeContainerLike(getBridgeContainer());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.BridgeContainerNested<A> editOrNewBridgeContainer() {
        return withNewBridgeContainerLike(getBridgeContainer() != null ? getBridgeContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.BridgeContainerNested<A> editOrNewBridgeContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewBridgeContainerLike(getBridgeContainer() != null ? getBridgeContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccount instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(io.strimzi.api.kafka.model.template.ResourceTemplate serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.ServiceAccountNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ServiceAccountNested<A> withNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluentImpl.ServiceAccountNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaBridgeTemplateFluentImpl that = (KafkaBridgeTemplateFluentImpl) o;
        if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (apiService != null ? !apiService.equals(that.apiService) :that.apiService != null) return false;
        if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
        if (bridgeContainer != null ? !bridgeContainer.equals(that.bridgeContainer) :that.bridgeContainer != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployment,  pod,  apiService,  podDisruptionBudget,  bridgeContainer,  serviceAccount,  super.hashCode());
    }

      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class DeploymentNestedImpl<N> extends io.strimzi.api.kafka.model.template.DeploymentTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.DeploymentNested<N>> implements io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder builder;

            DeploymentNestedImpl(io.strimzi.api.kafka.model.template.DeploymentTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder(this, item);
                        
            }

            DeploymentNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeTemplateFluentImpl.this.withDeployment(builder.build());
            }

            public N endDeployment() {
                return and();
            }
    }


      
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodNested<N>> implements io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodTemplateBuilder builder;

            PodNestedImpl(io.strimzi.api.kafka.model.template.PodTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi internal services.
   * It contains additional values applicable to internal services..
   */
  public class ApiServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ApiServiceNested<N>> implements io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ApiServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder builder;

            ApiServiceNestedImpl(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this, item);
                        
            }

            ApiServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeTemplateFluentImpl.this.withApiService(builder.build());
            }

            public N endApiService() {
                return and();
            }
    }


      
  /**
   * Representation of a Pod disruption Budget template template for Strimzi resources.
   */
  public class PodDisruptionBudgetNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<N>> implements io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder builder;

            PodDisruptionBudgetNestedImpl(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this, item);
                        
            }

            PodDisruptionBudgetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
            }

            public N endPodDisruptionBudget() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class BridgeContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.BridgeContainerNested<N>> implements io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.BridgeContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            BridgeContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            BridgeContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeTemplateFluentImpl.this.withBridgeContainer(builder.build());
            }

            public N endBridgeContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ServiceAccountNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ServiceAccountNested<N>> implements io.strimzi.api.kafka.model.template.KafkaBridgeTemplateFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ServiceAccountNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ServiceAccountNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaBridgeTemplateFluentImpl.this.withServiceAccount(builder.build());
            }

            public N endServiceAccount() {
                return and();
            }
    }


}
