package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Kafka cluster resources.
   */
  public class KafkaClusterTemplateBuilder extends io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.KafkaClusterTemplate,io.strimzi.api.kafka.model.template.KafkaClusterTemplateBuilder> {

    io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaClusterTemplateBuilder() {
        this(true);
    }

    public KafkaClusterTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaClusterTemplate(), validationEnabled);
    }

    public KafkaClusterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaClusterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaClusterTemplate(), validationEnabled);
    }

    public KafkaClusterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaClusterTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaClusterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaClusterTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStatefulset(instance.getStatefulset());
        
        fluent.withPodSet(instance.getPodSet());
        
        fluent.withPod(instance.getPod());
        
        fluent.withBootstrapService(instance.getBootstrapService());
        
        fluent.withBrokersService(instance.getBrokersService());
        
        fluent.withExternalBootstrapService(instance.getExternalBootstrapService());
        
        fluent.withPerPodService(instance.getPerPodService());
        
        fluent.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
        
        fluent.withPerPodRoute(instance.getPerPodRoute());
        
        fluent.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
        
        fluent.withPerPodIngress(instance.getPerPodIngress());
        
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        fluent.withClusterCaCert(instance.getClusterCaCert());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withKafkaContainer(instance.getKafkaContainer());
        
        fluent.withInitContainer(instance.getInitContainer());
        
        fluent.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        fluent.withJmxSecret(instance.getJmxSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaClusterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaClusterTemplate instance) {
        this(instance,true);
    }

    public KafkaClusterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaClusterTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withStatefulset(instance.getStatefulset());
        
        this.withPodSet(instance.getPodSet());
        
        this.withPod(instance.getPod());
        
        this.withBootstrapService(instance.getBootstrapService());
        
        this.withBrokersService(instance.getBrokersService());
        
        this.withExternalBootstrapService(instance.getExternalBootstrapService());
        
        this.withPerPodService(instance.getPerPodService());
        
        this.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
        
        this.withPerPodRoute(instance.getPerPodRoute());
        
        this.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
        
        this.withPerPodIngress(instance.getPerPodIngress());
        
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        this.withClusterCaCert(instance.getClusterCaCert());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withKafkaContainer(instance.getKafkaContainer());
        
        this.withInitContainer(instance.getInitContainer());
        
        this.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.withJmxSecret(instance.getJmxSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplate build() {
        KafkaClusterTemplate buildable = new KafkaClusterTemplate();
        buildable.setStatefulset(fluent.getStatefulset());
        buildable.setPodSet(fluent.getPodSet());
        buildable.setPod(fluent.getPod());
        buildable.setBootstrapService(fluent.getBootstrapService());
        buildable.setBrokersService(fluent.getBrokersService());
        buildable.setExternalBootstrapService(fluent.getExternalBootstrapService());
        buildable.setPerPodService(fluent.getPerPodService());
        buildable.setExternalBootstrapRoute(fluent.getExternalBootstrapRoute());
        buildable.setPerPodRoute(fluent.getPerPodRoute());
        buildable.setExternalBootstrapIngress(fluent.getExternalBootstrapIngress());
        buildable.setPerPodIngress(fluent.getPerPodIngress());
        buildable.setPersistentVolumeClaim(fluent.getPersistentVolumeClaim());
        buildable.setClusterCaCert(fluent.getClusterCaCert());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setKafkaContainer(fluent.getKafkaContainer());
        buildable.setInitContainer(fluent.getInitContainer());
        buildable.setClusterRoleBinding(fluent.getClusterRoleBinding());
        buildable.setServiceAccount(fluent.getServiceAccount());
        buildable.setJmxSecret(fluent.getJmxSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaClusterTemplateBuilder that = (KafkaClusterTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
