package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;

  
  /**
   * Representation of a template for Kafka cluster resources.
   */
  public class KafkaClusterTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder statefulset;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder podSet;
    private io.strimzi.api.kafka.model.template.PodTemplateBuilder pod;
    private io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder bootstrapService;
    private io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder brokersService;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder externalBootstrapService;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder perPodService;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder externalBootstrapRoute;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder perPodRoute;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder externalBootstrapIngress;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder perPodIngress;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder persistentVolumeClaim;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder clusterCaCert;
    private io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder kafkaContainer;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder initContainer;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder clusterRoleBinding;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder serviceAccount;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder jmxSecret;

    public KafkaClusterTemplateFluentImpl() {
    }

    public KafkaClusterTemplateFluentImpl(io.strimzi.api.kafka.model.template.KafkaClusterTemplate instance) {
        this.withStatefulset(instance.getStatefulset());
        
        this.withPodSet(instance.getPodSet());
        
        this.withPod(instance.getPod());
        
        this.withBootstrapService(instance.getBootstrapService());
        
        this.withBrokersService(instance.getBrokersService());
        
        this.withExternalBootstrapService(instance.getExternalBootstrapService());
        
        this.withPerPodService(instance.getPerPodService());
        
        this.withExternalBootstrapRoute(instance.getExternalBootstrapRoute());
        
        this.withPerPodRoute(instance.getPerPodRoute());
        
        this.withExternalBootstrapIngress(instance.getExternalBootstrapIngress());
        
        this.withPerPodIngress(instance.getPerPodIngress());
        
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        this.withClusterCaCert(instance.getClusterCaCert());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withKafkaContainer(instance.getKafkaContainer());
        
        this.withInitContainer(instance.getInitContainer());
        
        this.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.withJmxSecret(instance.getJmxSecret());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStatefulset instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.StatefulSetTemplate getStatefulset() {
        return this.statefulset!=null?this.statefulset.build():null;
    }

    public io.strimzi.api.kafka.model.template.StatefulSetTemplate buildStatefulset() {
        return this.statefulset!=null?this.statefulset.build():null;
    }

    public A withStatefulset(io.strimzi.api.kafka.model.template.StatefulSetTemplate statefulset) {
        _visitables.get("statefulset").remove(this.statefulset);
        if (statefulset!=null){ this.statefulset= new io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder(statefulset); _visitables.get("statefulset").add(this.statefulset);} return (A) this;
    }

    public java.lang.Boolean hasStatefulset() {
        return this.statefulset != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.StatefulsetNested<A> withNewStatefulset() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.StatefulsetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.StatefulsetNested<A> withNewStatefulsetLike(io.strimzi.api.kafka.model.template.StatefulSetTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.StatefulsetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.StatefulsetNested<A> editStatefulset() {
        return withNewStatefulsetLike(getStatefulset());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.StatefulsetNested<A> editOrNewStatefulset() {
        return withNewStatefulsetLike(getStatefulset() != null ? getStatefulset(): new io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.StatefulsetNested<A> editOrNewStatefulsetLike(io.strimzi.api.kafka.model.template.StatefulSetTemplate item) {
        return withNewStatefulsetLike(getStatefulset() != null ? getStatefulset(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodSet instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getPodSet() {
        return this.podSet!=null?this.podSet.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildPodSet() {
        return this.podSet!=null?this.podSet.build():null;
    }

    public A withPodSet(io.strimzi.api.kafka.model.template.ResourceTemplate podSet) {
        _visitables.get("podSet").remove(this.podSet);
        if (podSet!=null){ this.podSet= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(podSet); _visitables.get("podSet").add(this.podSet);} return (A) this;
    }

    public java.lang.Boolean hasPodSet() {
        return this.podSet != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodSetNested<A> withNewPodSet() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PodSetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodSetNested<A> withNewPodSetLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PodSetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodSetNested<A> editPodSet() {
        return withNewPodSetLike(getPodSet());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodSetNested<A> editOrNewPodSet() {
        return withNewPodSetLike(getPodSet() != null ? getPodSet(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodSetNested<A> editOrNewPodSetLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewPodSetLike(getPodSet() != null ? getPodSet(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPod instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(io.strimzi.api.kafka.model.template.PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new io.strimzi.api.kafka.model.template.PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public java.lang.Boolean hasPod() {
        return this.pod != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodNested<A> withNewPod() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PodNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodNested<A> withNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PodNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new io.strimzi.api.kafka.model.template.PodTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodNested<A> editOrNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBootstrapService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.InternalServiceTemplate getBootstrapService() {
        return this.bootstrapService!=null?this.bootstrapService.build():null;
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplate buildBootstrapService() {
        return this.bootstrapService!=null?this.bootstrapService.build():null;
    }

    public A withBootstrapService(io.strimzi.api.kafka.model.template.InternalServiceTemplate bootstrapService) {
        _visitables.get("bootstrapService").remove(this.bootstrapService);
        if (bootstrapService!=null){ this.bootstrapService= new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(bootstrapService); _visitables.get("bootstrapService").add(this.bootstrapService);} return (A) this;
    }

    public java.lang.Boolean hasBootstrapService() {
        return this.bootstrapService != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BootstrapServiceNested<A> withNewBootstrapService() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.BootstrapServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BootstrapServiceNested<A> withNewBootstrapServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.BootstrapServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BootstrapServiceNested<A> editBootstrapService() {
        return withNewBootstrapServiceLike(getBootstrapService());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BootstrapServiceNested<A> editOrNewBootstrapService() {
        return withNewBootstrapServiceLike(getBootstrapService() != null ? getBootstrapService(): new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BootstrapServiceNested<A> editOrNewBootstrapServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return withNewBootstrapServiceLike(getBootstrapService() != null ? getBootstrapService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBrokersService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.InternalServiceTemplate getBrokersService() {
        return this.brokersService!=null?this.brokersService.build():null;
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplate buildBrokersService() {
        return this.brokersService!=null?this.brokersService.build():null;
    }

    public A withBrokersService(io.strimzi.api.kafka.model.template.InternalServiceTemplate brokersService) {
        _visitables.get("brokersService").remove(this.brokersService);
        if (brokersService!=null){ this.brokersService= new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(brokersService); _visitables.get("brokersService").add(this.brokersService);} return (A) this;
    }

    public java.lang.Boolean hasBrokersService() {
        return this.brokersService != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BrokersServiceNested<A> withNewBrokersService() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.BrokersServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BrokersServiceNested<A> withNewBrokersServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.BrokersServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BrokersServiceNested<A> editBrokersService() {
        return withNewBrokersServiceLike(getBrokersService());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BrokersServiceNested<A> editOrNewBrokersService() {
        return withNewBrokersServiceLike(getBrokersService() != null ? getBrokersService(): new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BrokersServiceNested<A> editOrNewBrokersServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return withNewBrokersServiceLike(getBrokersService() != null ? getBrokersService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildExternalBootstrapService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getExternalBootstrapService() {
        return this.externalBootstrapService!=null?this.externalBootstrapService.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildExternalBootstrapService() {
        return this.externalBootstrapService!=null?this.externalBootstrapService.build():null;
    }

    public A withExternalBootstrapService(io.strimzi.api.kafka.model.template.ResourceTemplate externalBootstrapService) {
        _visitables.get("externalBootstrapService").remove(this.externalBootstrapService);
        if (externalBootstrapService!=null){ this.externalBootstrapService= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(externalBootstrapService); _visitables.get("externalBootstrapService").add(this.externalBootstrapService);} return (A) this;
    }

    public java.lang.Boolean hasExternalBootstrapService() {
        return this.externalBootstrapService != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> withNewExternalBootstrapService() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ExternalBootstrapServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> withNewExternalBootstrapServiceLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ExternalBootstrapServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> editExternalBootstrapService() {
        return withNewExternalBootstrapServiceLike(getExternalBootstrapService());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> editOrNewExternalBootstrapService() {
        return withNewExternalBootstrapServiceLike(getExternalBootstrapService() != null ? getExternalBootstrapService(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<A> editOrNewExternalBootstrapServiceLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewExternalBootstrapServiceLike(getExternalBootstrapService() != null ? getExternalBootstrapService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPerPodService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getPerPodService() {
        return this.perPodService!=null?this.perPodService.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildPerPodService() {
        return this.perPodService!=null?this.perPodService.build():null;
    }

    public A withPerPodService(io.strimzi.api.kafka.model.template.ResourceTemplate perPodService) {
        _visitables.get("perPodService").remove(this.perPodService);
        if (perPodService!=null){ this.perPodService= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(perPodService); _visitables.get("perPodService").add(this.perPodService);} return (A) this;
    }

    public java.lang.Boolean hasPerPodService() {
        return this.perPodService != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodServiceNested<A> withNewPerPodService() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PerPodServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodServiceNested<A> withNewPerPodServiceLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PerPodServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodServiceNested<A> editPerPodService() {
        return withNewPerPodServiceLike(getPerPodService());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodServiceNested<A> editOrNewPerPodService() {
        return withNewPerPodServiceLike(getPerPodService() != null ? getPerPodService(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodServiceNested<A> editOrNewPerPodServiceLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewPerPodServiceLike(getPerPodService() != null ? getPerPodService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildExternalBootstrapRoute instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getExternalBootstrapRoute() {
        return this.externalBootstrapRoute!=null?this.externalBootstrapRoute.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildExternalBootstrapRoute() {
        return this.externalBootstrapRoute!=null?this.externalBootstrapRoute.build():null;
    }

    public A withExternalBootstrapRoute(io.strimzi.api.kafka.model.template.ResourceTemplate externalBootstrapRoute) {
        _visitables.get("externalBootstrapRoute").remove(this.externalBootstrapRoute);
        if (externalBootstrapRoute!=null){ this.externalBootstrapRoute= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(externalBootstrapRoute); _visitables.get("externalBootstrapRoute").add(this.externalBootstrapRoute);} return (A) this;
    }

    public java.lang.Boolean hasExternalBootstrapRoute() {
        return this.externalBootstrapRoute != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> withNewExternalBootstrapRoute() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ExternalBootstrapRouteNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> withNewExternalBootstrapRouteLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ExternalBootstrapRouteNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> editExternalBootstrapRoute() {
        return withNewExternalBootstrapRouteLike(getExternalBootstrapRoute());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> editOrNewExternalBootstrapRoute() {
        return withNewExternalBootstrapRouteLike(getExternalBootstrapRoute() != null ? getExternalBootstrapRoute(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<A> editOrNewExternalBootstrapRouteLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewExternalBootstrapRouteLike(getExternalBootstrapRoute() != null ? getExternalBootstrapRoute(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPerPodRoute instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getPerPodRoute() {
        return this.perPodRoute!=null?this.perPodRoute.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildPerPodRoute() {
        return this.perPodRoute!=null?this.perPodRoute.build():null;
    }

    public A withPerPodRoute(io.strimzi.api.kafka.model.template.ResourceTemplate perPodRoute) {
        _visitables.get("perPodRoute").remove(this.perPodRoute);
        if (perPodRoute!=null){ this.perPodRoute= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(perPodRoute); _visitables.get("perPodRoute").add(this.perPodRoute);} return (A) this;
    }

    public java.lang.Boolean hasPerPodRoute() {
        return this.perPodRoute != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodRouteNested<A> withNewPerPodRoute() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PerPodRouteNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodRouteNested<A> withNewPerPodRouteLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PerPodRouteNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodRouteNested<A> editPerPodRoute() {
        return withNewPerPodRouteLike(getPerPodRoute());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodRouteNested<A> editOrNewPerPodRoute() {
        return withNewPerPodRouteLike(getPerPodRoute() != null ? getPerPodRoute(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodRouteNested<A> editOrNewPerPodRouteLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewPerPodRouteLike(getPerPodRoute() != null ? getPerPodRoute(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildExternalBootstrapIngress instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getExternalBootstrapIngress() {
        return this.externalBootstrapIngress!=null?this.externalBootstrapIngress.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildExternalBootstrapIngress() {
        return this.externalBootstrapIngress!=null?this.externalBootstrapIngress.build():null;
    }

    public A withExternalBootstrapIngress(io.strimzi.api.kafka.model.template.ResourceTemplate externalBootstrapIngress) {
        _visitables.get("externalBootstrapIngress").remove(this.externalBootstrapIngress);
        if (externalBootstrapIngress!=null){ this.externalBootstrapIngress= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(externalBootstrapIngress); _visitables.get("externalBootstrapIngress").add(this.externalBootstrapIngress);} return (A) this;
    }

    public java.lang.Boolean hasExternalBootstrapIngress() {
        return this.externalBootstrapIngress != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> withNewExternalBootstrapIngress() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ExternalBootstrapIngressNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> withNewExternalBootstrapIngressLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ExternalBootstrapIngressNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> editExternalBootstrapIngress() {
        return withNewExternalBootstrapIngressLike(getExternalBootstrapIngress());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> editOrNewExternalBootstrapIngress() {
        return withNewExternalBootstrapIngressLike(getExternalBootstrapIngress() != null ? getExternalBootstrapIngress(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<A> editOrNewExternalBootstrapIngressLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewExternalBootstrapIngressLike(getExternalBootstrapIngress() != null ? getExternalBootstrapIngress(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPerPodIngress instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getPerPodIngress() {
        return this.perPodIngress!=null?this.perPodIngress.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildPerPodIngress() {
        return this.perPodIngress!=null?this.perPodIngress.build():null;
    }

    public A withPerPodIngress(io.strimzi.api.kafka.model.template.ResourceTemplate perPodIngress) {
        _visitables.get("perPodIngress").remove(this.perPodIngress);
        if (perPodIngress!=null){ this.perPodIngress= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(perPodIngress); _visitables.get("perPodIngress").add(this.perPodIngress);} return (A) this;
    }

    public java.lang.Boolean hasPerPodIngress() {
        return this.perPodIngress != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodIngressNested<A> withNewPerPodIngress() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PerPodIngressNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodIngressNested<A> withNewPerPodIngressLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PerPodIngressNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodIngressNested<A> editPerPodIngress() {
        return withNewPerPodIngressLike(getPerPodIngress());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodIngressNested<A> editOrNewPerPodIngress() {
        return withNewPerPodIngressLike(getPerPodIngress() != null ? getPerPodIngress(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodIngressNested<A> editOrNewPerPodIngressLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewPerPodIngressLike(getPerPodIngress() != null ? getPerPodIngress(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPersistentVolumeClaim instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public A withPersistentVolumeClaim(io.strimzi.api.kafka.model.template.ResourceTemplate persistentVolumeClaim) {
        _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
        if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} return (A) this;
    }

    public java.lang.Boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PersistentVolumeClaimNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PersistentVolumeClaimNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClusterCaCert instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getClusterCaCert() {
        return this.clusterCaCert!=null?this.clusterCaCert.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildClusterCaCert() {
        return this.clusterCaCert!=null?this.clusterCaCert.build():null;
    }

    public A withClusterCaCert(io.strimzi.api.kafka.model.template.ResourceTemplate clusterCaCert) {
        _visitables.get("clusterCaCert").remove(this.clusterCaCert);
        if (clusterCaCert!=null){ this.clusterCaCert= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(clusterCaCert); _visitables.get("clusterCaCert").add(this.clusterCaCert);} return (A) this;
    }

    public java.lang.Boolean hasClusterCaCert() {
        return this.clusterCaCert != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterCaCertNested<A> withNewClusterCaCert() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ClusterCaCertNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterCaCertNested<A> withNewClusterCaCertLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ClusterCaCertNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterCaCertNested<A> editClusterCaCert() {
        return withNewClusterCaCertLike(getClusterCaCert());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterCaCertNested<A> editOrNewClusterCaCert() {
        return withNewClusterCaCertLike(getClusterCaCert() != null ? getClusterCaCert(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterCaCertNested<A> editOrNewClusterCaCertLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewClusterCaCertLike(getClusterCaCert() != null ? getClusterCaCert(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodDisruptionBudget instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate podDisruptionBudget) {
        _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
        if (podDisruptionBudget!=null){ this.podDisruptionBudget= new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public java.lang.Boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PodDisruptionBudgetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.PodDisruptionBudgetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildKafkaContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getKafkaContainer() {
        return this.kafkaContainer!=null?this.kafkaContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildKafkaContainer() {
        return this.kafkaContainer!=null?this.kafkaContainer.build():null;
    }

    public A withKafkaContainer(io.strimzi.api.kafka.model.template.ContainerTemplate kafkaContainer) {
        _visitables.get("kafkaContainer").remove(this.kafkaContainer);
        if (kafkaContainer!=null){ this.kafkaContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(kafkaContainer); _visitables.get("kafkaContainer").add(this.kafkaContainer);} return (A) this;
    }

    public java.lang.Boolean hasKafkaContainer() {
        return this.kafkaContainer != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.KafkaContainerNested<A> withNewKafkaContainer() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.KafkaContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.KafkaContainerNested<A> withNewKafkaContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.KafkaContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.KafkaContainerNested<A> editKafkaContainer() {
        return withNewKafkaContainerLike(getKafkaContainer());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.KafkaContainerNested<A> editOrNewKafkaContainer() {
        return withNewKafkaContainerLike(getKafkaContainer() != null ? getKafkaContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.KafkaContainerNested<A> editOrNewKafkaContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewKafkaContainerLike(getKafkaContainer() != null ? getKafkaContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildInitContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getInitContainer() {
        return this.initContainer!=null?this.initContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildInitContainer() {
        return this.initContainer!=null?this.initContainer.build():null;
    }

    public A withInitContainer(io.strimzi.api.kafka.model.template.ContainerTemplate initContainer) {
        _visitables.get("initContainer").remove(this.initContainer);
        if (initContainer!=null){ this.initContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(initContainer); _visitables.get("initContainer").add(this.initContainer);} return (A) this;
    }

    public java.lang.Boolean hasInitContainer() {
        return this.initContainer != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.InitContainerNested<A> withNewInitContainer() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.InitContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.InitContainerNested<A> withNewInitContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.InitContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.InitContainerNested<A> editInitContainer() {
        return withNewInitContainerLike(getInitContainer());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.InitContainerNested<A> editOrNewInitContainer() {
        return withNewInitContainerLike(getInitContainer() != null ? getInitContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.InitContainerNested<A> editOrNewInitContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewInitContainerLike(getInitContainer() != null ? getInitContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClusterRoleBinding instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getClusterRoleBinding() {
        return this.clusterRoleBinding!=null?this.clusterRoleBinding.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildClusterRoleBinding() {
        return this.clusterRoleBinding!=null?this.clusterRoleBinding.build():null;
    }

    public A withClusterRoleBinding(io.strimzi.api.kafka.model.template.ResourceTemplate clusterRoleBinding) {
        _visitables.get("clusterRoleBinding").remove(this.clusterRoleBinding);
        if (clusterRoleBinding!=null){ this.clusterRoleBinding= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(clusterRoleBinding); _visitables.get("clusterRoleBinding").add(this.clusterRoleBinding);} return (A) this;
    }

    public java.lang.Boolean hasClusterRoleBinding() {
        return this.clusterRoleBinding != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> withNewClusterRoleBinding() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ClusterRoleBindingNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> withNewClusterRoleBindingLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ClusterRoleBindingNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> editClusterRoleBinding() {
        return withNewClusterRoleBindingLike(getClusterRoleBinding());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> editOrNewClusterRoleBinding() {
        return withNewClusterRoleBindingLike(getClusterRoleBinding() != null ? getClusterRoleBinding(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterRoleBindingNested<A> editOrNewClusterRoleBindingLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewClusterRoleBindingLike(getClusterRoleBinding() != null ? getClusterRoleBinding(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccount instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(io.strimzi.api.kafka.model.template.ResourceTemplate serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ServiceAccountNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ServiceAccountNested<A> withNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.ServiceAccountNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxSecret instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getJmxSecret() {
        return this.jmxSecret!=null?this.jmxSecret.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildJmxSecret() {
        return this.jmxSecret!=null?this.jmxSecret.build():null;
    }

    public A withJmxSecret(io.strimzi.api.kafka.model.template.ResourceTemplate jmxSecret) {
        _visitables.get("jmxSecret").remove(this.jmxSecret);
        if (jmxSecret!=null){ this.jmxSecret= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(jmxSecret); _visitables.get("jmxSecret").add(this.jmxSecret);} return (A) this;
    }

    public java.lang.Boolean hasJmxSecret() {
        return this.jmxSecret != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.JmxSecretNested<A> withNewJmxSecret() {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.JmxSecretNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.JmxSecretNested<A> withNewJmxSecretLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluentImpl.JmxSecretNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.JmxSecretNested<A> editJmxSecret() {
        return withNewJmxSecretLike(getJmxSecret());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.JmxSecretNested<A> editOrNewJmxSecret() {
        return withNewJmxSecretLike(getJmxSecret() != null ? getJmxSecret(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.JmxSecretNested<A> editOrNewJmxSecretLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewJmxSecretLike(getJmxSecret() != null ? getJmxSecret(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaClusterTemplateFluentImpl that = (KafkaClusterTemplateFluentImpl) o;
        if (statefulset != null ? !statefulset.equals(that.statefulset) :that.statefulset != null) return false;
        if (podSet != null ? !podSet.equals(that.podSet) :that.podSet != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (bootstrapService != null ? !bootstrapService.equals(that.bootstrapService) :that.bootstrapService != null) return false;
        if (brokersService != null ? !brokersService.equals(that.brokersService) :that.brokersService != null) return false;
        if (externalBootstrapService != null ? !externalBootstrapService.equals(that.externalBootstrapService) :that.externalBootstrapService != null) return false;
        if (perPodService != null ? !perPodService.equals(that.perPodService) :that.perPodService != null) return false;
        if (externalBootstrapRoute != null ? !externalBootstrapRoute.equals(that.externalBootstrapRoute) :that.externalBootstrapRoute != null) return false;
        if (perPodRoute != null ? !perPodRoute.equals(that.perPodRoute) :that.perPodRoute != null) return false;
        if (externalBootstrapIngress != null ? !externalBootstrapIngress.equals(that.externalBootstrapIngress) :that.externalBootstrapIngress != null) return false;
        if (perPodIngress != null ? !perPodIngress.equals(that.perPodIngress) :that.perPodIngress != null) return false;
        if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
        if (clusterCaCert != null ? !clusterCaCert.equals(that.clusterCaCert) :that.clusterCaCert != null) return false;
        if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
        if (kafkaContainer != null ? !kafkaContainer.equals(that.kafkaContainer) :that.kafkaContainer != null) return false;
        if (initContainer != null ? !initContainer.equals(that.initContainer) :that.initContainer != null) return false;
        if (clusterRoleBinding != null ? !clusterRoleBinding.equals(that.clusterRoleBinding) :that.clusterRoleBinding != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        if (jmxSecret != null ? !jmxSecret.equals(that.jmxSecret) :that.jmxSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(statefulset,  podSet,  pod,  bootstrapService,  brokersService,  externalBootstrapService,  perPodService,  externalBootstrapRoute,  perPodRoute,  externalBootstrapIngress,  perPodIngress,  persistentVolumeClaim,  clusterCaCert,  podDisruptionBudget,  kafkaContainer,  initContainer,  clusterRoleBinding,  serviceAccount,  jmxSecret,  super.hashCode());
    }

      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class StatefulsetNestedImpl<N> extends io.strimzi.api.kafka.model.template.StatefulSetTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.StatefulsetNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.StatefulsetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder builder;

            StatefulsetNestedImpl(io.strimzi.api.kafka.model.template.StatefulSetTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder(this, item);
                        
            }

            StatefulsetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withStatefulset(builder.build());
            }

            public N endStatefulset() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class PodSetNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodSetNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodSetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            PodSetNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            PodSetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPodSet(builder.build());
            }

            public N endPodSet() {
                return and();
            }
    }


      
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodTemplateBuilder builder;

            PodNestedImpl(io.strimzi.api.kafka.model.template.PodTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi internal services.
   * It contains additional values applicable to internal services..
   */
  public class BootstrapServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BootstrapServiceNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BootstrapServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder builder;

            BootstrapServiceNestedImpl(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this, item);
                        
            }

            BootstrapServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withBootstrapService(builder.build());
            }

            public N endBootstrapService() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi internal services.
   * It contains additional values applicable to internal services..
   */
  public class BrokersServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BrokersServiceNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.BrokersServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder builder;

            BrokersServiceNestedImpl(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this, item);
                        
            }

            BrokersServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withBrokersService(builder.build());
            }

            public N endBrokersService() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ExternalBootstrapServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ExternalBootstrapServiceNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ExternalBootstrapServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withExternalBootstrapService(builder.build());
            }

            public N endExternalBootstrapService() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class PerPodServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodServiceNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            PerPodServiceNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            PerPodServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPerPodService(builder.build());
            }

            public N endPerPodService() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ExternalBootstrapRouteNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapRouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ExternalBootstrapRouteNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ExternalBootstrapRouteNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withExternalBootstrapRoute(builder.build());
            }

            public N endExternalBootstrapRoute() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class PerPodRouteNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodRouteNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodRouteNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            PerPodRouteNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            PerPodRouteNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPerPodRoute(builder.build());
            }

            public N endPerPodRoute() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ExternalBootstrapIngressNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ExternalBootstrapIngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ExternalBootstrapIngressNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ExternalBootstrapIngressNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withExternalBootstrapIngress(builder.build());
            }

            public N endExternalBootstrapIngress() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class PerPodIngressNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodIngressNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PerPodIngressNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            PerPodIngressNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            PerPodIngressNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPerPodIngress(builder.build());
            }

            public N endPerPodIngress() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class PersistentVolumeClaimNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PersistentVolumeClaimNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PersistentVolumeClaimNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            PersistentVolumeClaimNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            PersistentVolumeClaimNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPersistentVolumeClaim(builder.build());
            }

            public N endPersistentVolumeClaim() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ClusterCaCertNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterCaCertNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterCaCertNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ClusterCaCertNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ClusterCaCertNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withClusterCaCert(builder.build());
            }

            public N endClusterCaCert() {
                return and();
            }
    }


      
  /**
   * Representation of a Pod disruption Budget template template for Strimzi resources.
   */
  public class PodDisruptionBudgetNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodDisruptionBudgetNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder builder;

            PodDisruptionBudgetNestedImpl(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this, item);
                        
            }

            PodDisruptionBudgetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
            }

            public N endPodDisruptionBudget() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class KafkaContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.KafkaContainerNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.KafkaContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            KafkaContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            KafkaContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withKafkaContainer(builder.build());
            }

            public N endKafkaContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class InitContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.InitContainerNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.InitContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            InitContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            InitContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withInitContainer(builder.build());
            }

            public N endInitContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ClusterRoleBindingNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterRoleBindingNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ClusterRoleBindingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ClusterRoleBindingNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ClusterRoleBindingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withClusterRoleBinding(builder.build());
            }

            public N endClusterRoleBinding() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ServiceAccountNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ServiceAccountNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ServiceAccountNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ServiceAccountNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withServiceAccount(builder.build());
            }

            public N endServiceAccount() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class JmxSecretNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.JmxSecretNested<N>> implements io.strimzi.api.kafka.model.template.KafkaClusterTemplateFluent.JmxSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            JmxSecretNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            JmxSecretNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaClusterTemplateFluentImpl.this.withJmxSecret(builder.build());
            }

            public N endJmxSecret() {
                return and();
            }
    }


}
