package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Kafka Connect resources.
   */
  public class KafkaConnectTemplateBuilder extends io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.KafkaConnectTemplate,io.strimzi.api.kafka.model.template.KafkaConnectTemplateBuilder> {

    io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaConnectTemplateBuilder() {
        this(true);
    }

    public KafkaConnectTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaConnectTemplate(), validationEnabled);
    }

    public KafkaConnectTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaConnectTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaConnectTemplate(), validationEnabled);
    }

    public KafkaConnectTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaConnectTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaConnectTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaConnectTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withBuildPod(instance.getBuildPod());
        
        fluent.withApiService(instance.getApiService());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withConnectContainer(instance.getConnectContainer());
        
        fluent.withInitContainer(instance.getInitContainer());
        
        fluent.withBuildContainer(instance.getBuildContainer());
        
        fluent.withBuildConfig(instance.getBuildConfig());
        
        fluent.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        fluent.withBuildServiceAccount(instance.getBuildServiceAccount());
        
        fluent.withJmxSecret(instance.getJmxSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaConnectTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaConnectTemplate instance) {
        this(instance,true);
    }

    public KafkaConnectTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaConnectTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withBuildPod(instance.getBuildPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withConnectContainer(instance.getConnectContainer());
        
        this.withInitContainer(instance.getInitContainer());
        
        this.withBuildContainer(instance.getBuildContainer());
        
        this.withBuildConfig(instance.getBuildConfig());
        
        this.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.withBuildServiceAccount(instance.getBuildServiceAccount());
        
        this.withJmxSecret(instance.getJmxSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplate build() {
        KafkaConnectTemplate buildable = new KafkaConnectTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setBuildPod(fluent.getBuildPod());
        buildable.setApiService(fluent.getApiService());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setConnectContainer(fluent.getConnectContainer());
        buildable.setInitContainer(fluent.getInitContainer());
        buildable.setBuildContainer(fluent.getBuildContainer());
        buildable.setBuildConfig(fluent.getBuildConfig());
        buildable.setClusterRoleBinding(fluent.getClusterRoleBinding());
        buildable.setServiceAccount(fluent.getServiceAccount());
        buildable.setBuildServiceAccount(fluent.getBuildServiceAccount());
        buildable.setJmxSecret(fluent.getJmxSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaConnectTemplateBuilder that = (KafkaConnectTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
