package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;

  
  /**
   * Representation of a template for Kafka Connect resources.
   */
  public class KafkaConnectTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder deployment;
    private io.strimzi.api.kafka.model.template.PodTemplateBuilder pod;
    private io.strimzi.api.kafka.model.template.PodTemplateBuilder buildPod;
    private io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder apiService;
    private io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder connectContainer;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder initContainer;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder buildContainer;
    private io.strimzi.api.kafka.model.template.BuildConfigTemplateBuilder buildConfig;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder clusterRoleBinding;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder serviceAccount;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder buildServiceAccount;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder jmxSecret;

    public KafkaConnectTemplateFluentImpl() {
    }

    public KafkaConnectTemplateFluentImpl(io.strimzi.api.kafka.model.template.KafkaConnectTemplate instance) {
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withBuildPod(instance.getBuildPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withConnectContainer(instance.getConnectContainer());
        
        this.withInitContainer(instance.getInitContainer());
        
        this.withBuildContainer(instance.getBuildContainer());
        
        this.withBuildConfig(instance.getBuildConfig());
        
        this.withClusterRoleBinding(instance.getClusterRoleBinding());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.withBuildServiceAccount(instance.getBuildServiceAccount());
        
        this.withJmxSecret(instance.getJmxSecret());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDeployment instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.DeploymentTemplate getDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public io.strimzi.api.kafka.model.template.DeploymentTemplate buildDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(io.strimzi.api.kafka.model.template.DeploymentTemplate deployment) {
        _visitables.get("deployment").remove(this.deployment);
        if (deployment!=null){ this.deployment= new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public java.lang.Boolean hasDeployment() {
        return this.deployment != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.DeploymentNested<A> withNewDeployment() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.DeploymentNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.DeploymentNested<A> withNewDeploymentLike(io.strimzi.api.kafka.model.template.DeploymentTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.DeploymentNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.DeploymentNested<A> editDeployment() {
        return withNewDeploymentLike(getDeployment());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.DeploymentNested<A> editOrNewDeployment() {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(io.strimzi.api.kafka.model.template.DeploymentTemplate item) {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPod instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(io.strimzi.api.kafka.model.template.PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new io.strimzi.api.kafka.model.template.PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public java.lang.Boolean hasPod() {
        return this.pod != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodNested<A> withNewPod() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.PodNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodNested<A> withNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.PodNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new io.strimzi.api.kafka.model.template.PodTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodNested<A> editOrNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBuildPod instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodTemplate getBuildPod() {
        return this.buildPod!=null?this.buildPod.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplate buildBuildPod() {
        return this.buildPod!=null?this.buildPod.build():null;
    }

    public A withBuildPod(io.strimzi.api.kafka.model.template.PodTemplate buildPod) {
        _visitables.get("buildPod").remove(this.buildPod);
        if (buildPod!=null){ this.buildPod= new io.strimzi.api.kafka.model.template.PodTemplateBuilder(buildPod); _visitables.get("buildPod").add(this.buildPod);} return (A) this;
    }

    public java.lang.Boolean hasBuildPod() {
        return this.buildPod != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildPodNested<A> withNewBuildPod() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.BuildPodNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildPodNested<A> withNewBuildPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.BuildPodNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildPodNested<A> editBuildPod() {
        return withNewBuildPodLike(getBuildPod());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildPodNested<A> editOrNewBuildPod() {
        return withNewBuildPodLike(getBuildPod() != null ? getBuildPod(): new io.strimzi.api.kafka.model.template.PodTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildPodNested<A> editOrNewBuildPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return withNewBuildPodLike(getBuildPod() != null ? getBuildPod(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildApiService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.InternalServiceTemplate getApiService() {
        return this.apiService!=null?this.apiService.build():null;
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplate buildApiService() {
        return this.apiService!=null?this.apiService.build():null;
    }

    public A withApiService(io.strimzi.api.kafka.model.template.InternalServiceTemplate apiService) {
        _visitables.get("apiService").remove(this.apiService);
        if (apiService!=null){ this.apiService= new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} return (A) this;
    }

    public java.lang.Boolean hasApiService() {
        return this.apiService != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ApiServiceNested<A> withNewApiService() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.ApiServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ApiServiceNested<A> withNewApiServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.ApiServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ApiServiceNested<A> editApiService() {
        return withNewApiServiceLike(getApiService());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ApiServiceNested<A> editOrNewApiService() {
        return withNewApiServiceLike(getApiService() != null ? getApiService(): new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ApiServiceNested<A> editOrNewApiServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return withNewApiServiceLike(getApiService() != null ? getApiService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodDisruptionBudget instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate podDisruptionBudget) {
        _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
        if (podDisruptionBudget!=null){ this.podDisruptionBudget= new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public java.lang.Boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.PodDisruptionBudgetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.PodDisruptionBudgetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildConnectContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getConnectContainer() {
        return this.connectContainer!=null?this.connectContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildConnectContainer() {
        return this.connectContainer!=null?this.connectContainer.build():null;
    }

    public A withConnectContainer(io.strimzi.api.kafka.model.template.ContainerTemplate connectContainer) {
        _visitables.get("connectContainer").remove(this.connectContainer);
        if (connectContainer!=null){ this.connectContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(connectContainer); _visitables.get("connectContainer").add(this.connectContainer);} return (A) this;
    }

    public java.lang.Boolean hasConnectContainer() {
        return this.connectContainer != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ConnectContainerNested<A> withNewConnectContainer() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.ConnectContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ConnectContainerNested<A> withNewConnectContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.ConnectContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ConnectContainerNested<A> editConnectContainer() {
        return withNewConnectContainerLike(getConnectContainer());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ConnectContainerNested<A> editOrNewConnectContainer() {
        return withNewConnectContainerLike(getConnectContainer() != null ? getConnectContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ConnectContainerNested<A> editOrNewConnectContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewConnectContainerLike(getConnectContainer() != null ? getConnectContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildInitContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getInitContainer() {
        return this.initContainer!=null?this.initContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildInitContainer() {
        return this.initContainer!=null?this.initContainer.build():null;
    }

    public A withInitContainer(io.strimzi.api.kafka.model.template.ContainerTemplate initContainer) {
        _visitables.get("initContainer").remove(this.initContainer);
        if (initContainer!=null){ this.initContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(initContainer); _visitables.get("initContainer").add(this.initContainer);} return (A) this;
    }

    public java.lang.Boolean hasInitContainer() {
        return this.initContainer != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.InitContainerNested<A> withNewInitContainer() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.InitContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.InitContainerNested<A> withNewInitContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.InitContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.InitContainerNested<A> editInitContainer() {
        return withNewInitContainerLike(getInitContainer());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.InitContainerNested<A> editOrNewInitContainer() {
        return withNewInitContainerLike(getInitContainer() != null ? getInitContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.InitContainerNested<A> editOrNewInitContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewInitContainerLike(getInitContainer() != null ? getInitContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBuildContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getBuildContainer() {
        return this.buildContainer!=null?this.buildContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildBuildContainer() {
        return this.buildContainer!=null?this.buildContainer.build():null;
    }

    public A withBuildContainer(io.strimzi.api.kafka.model.template.ContainerTemplate buildContainer) {
        _visitables.get("buildContainer").remove(this.buildContainer);
        if (buildContainer!=null){ this.buildContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(buildContainer); _visitables.get("buildContainer").add(this.buildContainer);} return (A) this;
    }

    public java.lang.Boolean hasBuildContainer() {
        return this.buildContainer != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildContainerNested<A> withNewBuildContainer() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.BuildContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildContainerNested<A> withNewBuildContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.BuildContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildContainerNested<A> editBuildContainer() {
        return withNewBuildContainerLike(getBuildContainer());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildContainerNested<A> editOrNewBuildContainer() {
        return withNewBuildContainerLike(getBuildContainer() != null ? getBuildContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildContainerNested<A> editOrNewBuildContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewBuildContainerLike(getBuildContainer() != null ? getBuildContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBuildConfig instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.BuildConfigTemplate getBuildConfig() {
        return this.buildConfig!=null?this.buildConfig.build():null;
    }

    public io.strimzi.api.kafka.model.template.BuildConfigTemplate buildBuildConfig() {
        return this.buildConfig!=null?this.buildConfig.build():null;
    }

    public A withBuildConfig(io.strimzi.api.kafka.model.template.BuildConfigTemplate buildConfig) {
        _visitables.get("buildConfig").remove(this.buildConfig);
        if (buildConfig!=null){ this.buildConfig= new io.strimzi.api.kafka.model.template.BuildConfigTemplateBuilder(buildConfig); _visitables.get("buildConfig").add(this.buildConfig);} return (A) this;
    }

    public java.lang.Boolean hasBuildConfig() {
        return this.buildConfig != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildConfigNested<A> withNewBuildConfig() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.BuildConfigNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildConfigNested<A> withNewBuildConfigLike(io.strimzi.api.kafka.model.template.BuildConfigTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.BuildConfigNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildConfigNested<A> editBuildConfig() {
        return withNewBuildConfigLike(getBuildConfig());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildConfigNested<A> editOrNewBuildConfig() {
        return withNewBuildConfigLike(getBuildConfig() != null ? getBuildConfig(): new io.strimzi.api.kafka.model.template.BuildConfigTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildConfigNested<A> editOrNewBuildConfigLike(io.strimzi.api.kafka.model.template.BuildConfigTemplate item) {
        return withNewBuildConfigLike(getBuildConfig() != null ? getBuildConfig(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClusterRoleBinding instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getClusterRoleBinding() {
        return this.clusterRoleBinding!=null?this.clusterRoleBinding.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildClusterRoleBinding() {
        return this.clusterRoleBinding!=null?this.clusterRoleBinding.build():null;
    }

    public A withClusterRoleBinding(io.strimzi.api.kafka.model.template.ResourceTemplate clusterRoleBinding) {
        _visitables.get("clusterRoleBinding").remove(this.clusterRoleBinding);
        if (clusterRoleBinding!=null){ this.clusterRoleBinding= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(clusterRoleBinding); _visitables.get("clusterRoleBinding").add(this.clusterRoleBinding);} return (A) this;
    }

    public java.lang.Boolean hasClusterRoleBinding() {
        return this.clusterRoleBinding != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ClusterRoleBindingNested<A> withNewClusterRoleBinding() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.ClusterRoleBindingNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ClusterRoleBindingNested<A> withNewClusterRoleBindingLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.ClusterRoleBindingNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ClusterRoleBindingNested<A> editClusterRoleBinding() {
        return withNewClusterRoleBindingLike(getClusterRoleBinding());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ClusterRoleBindingNested<A> editOrNewClusterRoleBinding() {
        return withNewClusterRoleBindingLike(getClusterRoleBinding() != null ? getClusterRoleBinding(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ClusterRoleBindingNested<A> editOrNewClusterRoleBindingLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewClusterRoleBindingLike(getClusterRoleBinding() != null ? getClusterRoleBinding(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccount instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(io.strimzi.api.kafka.model.template.ResourceTemplate serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.ServiceAccountNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ServiceAccountNested<A> withNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.ServiceAccountNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildBuildServiceAccount instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getBuildServiceAccount() {
        return this.buildServiceAccount!=null?this.buildServiceAccount.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildBuildServiceAccount() {
        return this.buildServiceAccount!=null?this.buildServiceAccount.build():null;
    }

    public A withBuildServiceAccount(io.strimzi.api.kafka.model.template.ResourceTemplate buildServiceAccount) {
        _visitables.get("buildServiceAccount").remove(this.buildServiceAccount);
        if (buildServiceAccount!=null){ this.buildServiceAccount= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(buildServiceAccount); _visitables.get("buildServiceAccount").add(this.buildServiceAccount);} return (A) this;
    }

    public java.lang.Boolean hasBuildServiceAccount() {
        return this.buildServiceAccount != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildServiceAccountNested<A> withNewBuildServiceAccount() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.BuildServiceAccountNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildServiceAccountNested<A> withNewBuildServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.BuildServiceAccountNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildServiceAccountNested<A> editBuildServiceAccount() {
        return withNewBuildServiceAccountLike(getBuildServiceAccount());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildServiceAccountNested<A> editOrNewBuildServiceAccount() {
        return withNewBuildServiceAccountLike(getBuildServiceAccount() != null ? getBuildServiceAccount(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildServiceAccountNested<A> editOrNewBuildServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewBuildServiceAccountLike(getBuildServiceAccount() != null ? getBuildServiceAccount(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxSecret instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getJmxSecret() {
        return this.jmxSecret!=null?this.jmxSecret.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildJmxSecret() {
        return this.jmxSecret!=null?this.jmxSecret.build():null;
    }

    public A withJmxSecret(io.strimzi.api.kafka.model.template.ResourceTemplate jmxSecret) {
        _visitables.get("jmxSecret").remove(this.jmxSecret);
        if (jmxSecret!=null){ this.jmxSecret= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(jmxSecret); _visitables.get("jmxSecret").add(this.jmxSecret);} return (A) this;
    }

    public java.lang.Boolean hasJmxSecret() {
        return this.jmxSecret != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.JmxSecretNested<A> withNewJmxSecret() {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.JmxSecretNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.JmxSecretNested<A> withNewJmxSecretLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluentImpl.JmxSecretNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.JmxSecretNested<A> editJmxSecret() {
        return withNewJmxSecretLike(getJmxSecret());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.JmxSecretNested<A> editOrNewJmxSecret() {
        return withNewJmxSecretLike(getJmxSecret() != null ? getJmxSecret(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.JmxSecretNested<A> editOrNewJmxSecretLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewJmxSecretLike(getJmxSecret() != null ? getJmxSecret(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaConnectTemplateFluentImpl that = (KafkaConnectTemplateFluentImpl) o;
        if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (buildPod != null ? !buildPod.equals(that.buildPod) :that.buildPod != null) return false;
        if (apiService != null ? !apiService.equals(that.apiService) :that.apiService != null) return false;
        if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
        if (connectContainer != null ? !connectContainer.equals(that.connectContainer) :that.connectContainer != null) return false;
        if (initContainer != null ? !initContainer.equals(that.initContainer) :that.initContainer != null) return false;
        if (buildContainer != null ? !buildContainer.equals(that.buildContainer) :that.buildContainer != null) return false;
        if (buildConfig != null ? !buildConfig.equals(that.buildConfig) :that.buildConfig != null) return false;
        if (clusterRoleBinding != null ? !clusterRoleBinding.equals(that.clusterRoleBinding) :that.clusterRoleBinding != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        if (buildServiceAccount != null ? !buildServiceAccount.equals(that.buildServiceAccount) :that.buildServiceAccount != null) return false;
        if (jmxSecret != null ? !jmxSecret.equals(that.jmxSecret) :that.jmxSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployment,  pod,  buildPod,  apiService,  podDisruptionBudget,  connectContainer,  initContainer,  buildContainer,  buildConfig,  clusterRoleBinding,  serviceAccount,  buildServiceAccount,  jmxSecret,  super.hashCode());
    }

      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class DeploymentNestedImpl<N> extends io.strimzi.api.kafka.model.template.DeploymentTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.DeploymentNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder builder;

            DeploymentNestedImpl(io.strimzi.api.kafka.model.template.DeploymentTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder(this, item);
                        
            }

            DeploymentNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withDeployment(builder.build());
            }

            public N endDeployment() {
                return and();
            }
    }


      
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodTemplateBuilder builder;

            PodNestedImpl(io.strimzi.api.kafka.model.template.PodTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


      
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class BuildPodNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildPodNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildPodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodTemplateBuilder builder;

            BuildPodNestedImpl(io.strimzi.api.kafka.model.template.PodTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this, item);
                        
            }

            BuildPodNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withBuildPod(builder.build());
            }

            public N endBuildPod() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi internal services.
   * It contains additional values applicable to internal services..
   */
  public class ApiServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ApiServiceNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ApiServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder builder;

            ApiServiceNestedImpl(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this, item);
                        
            }

            ApiServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withApiService(builder.build());
            }

            public N endApiService() {
                return and();
            }
    }


      
  /**
   * Representation of a Pod disruption Budget template template for Strimzi resources.
   */
  public class PodDisruptionBudgetNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodDisruptionBudgetNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder builder;

            PodDisruptionBudgetNestedImpl(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this, item);
                        
            }

            PodDisruptionBudgetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
            }

            public N endPodDisruptionBudget() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class ConnectContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ConnectContainerNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ConnectContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            ConnectContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            ConnectContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withConnectContainer(builder.build());
            }

            public N endConnectContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class InitContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.InitContainerNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.InitContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            InitContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            InitContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withInitContainer(builder.build());
            }

            public N endInitContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class BuildContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildContainerNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            BuildContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            BuildContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withBuildContainer(builder.build());
            }

            public N endBuildContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a BuildConfig template for Strimzi resources.
   */
  public class BuildConfigNestedImpl<N> extends io.strimzi.api.kafka.model.template.BuildConfigTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildConfigNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.BuildConfigTemplateBuilder builder;

            BuildConfigNestedImpl(io.strimzi.api.kafka.model.template.BuildConfigTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.BuildConfigTemplateBuilder(this, item);
                        
            }

            BuildConfigNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.BuildConfigTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withBuildConfig(builder.build());
            }

            public N endBuildConfig() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ClusterRoleBindingNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ClusterRoleBindingNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ClusterRoleBindingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ClusterRoleBindingNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ClusterRoleBindingNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withClusterRoleBinding(builder.build());
            }

            public N endClusterRoleBinding() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ServiceAccountNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ServiceAccountNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ServiceAccountNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ServiceAccountNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withServiceAccount(builder.build());
            }

            public N endServiceAccount() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class BuildServiceAccountNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildServiceAccountNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.BuildServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            BuildServiceAccountNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            BuildServiceAccountNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withBuildServiceAccount(builder.build());
            }

            public N endBuildServiceAccount() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class JmxSecretNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.JmxSecretNested<N>> implements io.strimzi.api.kafka.model.template.KafkaConnectTemplateFluent.JmxSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            JmxSecretNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            JmxSecretNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaConnectTemplateFluentImpl.this.withJmxSecret(builder.build());
            }

            public N endJmxSecret() {
                return and();
            }
    }


}
