package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Kafka Exporter resources.
   */
  public class KafkaExporterTemplateBuilder extends io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.KafkaExporterTemplate,io.strimzi.api.kafka.model.template.KafkaExporterTemplateBuilder> {

    io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaExporterTemplateBuilder() {
        this(true);
    }

    public KafkaExporterTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaExporterTemplate(), validationEnabled);
    }

    public KafkaExporterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaExporterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaExporterTemplate(), validationEnabled);
    }

    public KafkaExporterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaExporterTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaExporterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaExporterTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withService(instance.getService());
        
        fluent.withContainer(instance.getContainer());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaExporterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaExporterTemplate instance) {
        this(instance,true);
    }

    public KafkaExporterTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaExporterTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withService(instance.getService());
        
        this.withContainer(instance.getContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplate build() {
        KafkaExporterTemplate buildable = new KafkaExporterTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setService(fluent.getService());
        buildable.setContainer(fluent.getContainer());
        buildable.setServiceAccount(fluent.getServiceAccount());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaExporterTemplateBuilder that = (KafkaExporterTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
