package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

  
  /**
   * Representation of a template for Kafka Exporter resources.
   */
  public class KafkaExporterTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder deployment;
    private io.strimzi.api.kafka.model.template.PodTemplateBuilder pod;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder service;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder container;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder serviceAccount;

    public KafkaExporterTemplateFluentImpl() {
    }

    public KafkaExporterTemplateFluentImpl(io.strimzi.api.kafka.model.template.KafkaExporterTemplate instance) {
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withService(instance.getService());
        
        this.withContainer(instance.getContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDeployment instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(io.strimzi.api.kafka.model.template.ResourceTemplate deployment) {
        _visitables.get("deployment").remove(this.deployment);
        if (deployment!=null){ this.deployment= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public java.lang.Boolean hasDeployment() {
        return this.deployment != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.DeploymentNested<A> withNewDeployment() {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.DeploymentNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.DeploymentNested<A> withNewDeploymentLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.DeploymentNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.DeploymentNested<A> editDeployment() {
        return withNewDeploymentLike(getDeployment());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.DeploymentNested<A> editOrNewDeployment() {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPod instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(io.strimzi.api.kafka.model.template.PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new io.strimzi.api.kafka.model.template.PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public java.lang.Boolean hasPod() {
        return this.pod != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.PodNested<A> withNewPod() {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.PodNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.PodNested<A> withNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.PodNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new io.strimzi.api.kafka.model.template.PodTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.PodNested<A> editOrNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getService() {
        return this.service!=null?this.service.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildService() {
        return this.service!=null?this.service.build():null;
    }

    public A withService(io.strimzi.api.kafka.model.template.ResourceTemplate service) {
        _visitables.get("service").remove(this.service);
        if (service!=null){ this.service= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(service); _visitables.get("service").add(this.service);} return (A) this;
    }

    public java.lang.Boolean hasService() {
        return this.service != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceNested<A> withNewService() {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.ServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceNested<A> withNewServiceLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.ServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceNested<A> editService() {
        return withNewServiceLike(getService());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceNested<A> editOrNewService() {
        return withNewServiceLike(getService() != null ? getService(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceNested<A> editOrNewServiceLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewServiceLike(getService() != null ? getService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getContainer() {
        return this.container!=null?this.container.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildContainer() {
        return this.container!=null?this.container.build():null;
    }

    public A withContainer(io.strimzi.api.kafka.model.template.ContainerTemplate container) {
        _visitables.get("container").remove(this.container);
        if (container!=null){ this.container= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(container); _visitables.get("container").add(this.container);} return (A) this;
    }

    public java.lang.Boolean hasContainer() {
        return this.container != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ContainerNested<A> withNewContainer() {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.ContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ContainerNested<A> withNewContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.ContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ContainerNested<A> editContainer() {
        return withNewContainerLike(getContainer());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ContainerNested<A> editOrNewContainer() {
        return withNewContainerLike(getContainer() != null ? getContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ContainerNested<A> editOrNewContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewContainerLike(getContainer() != null ? getContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccount instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(io.strimzi.api.kafka.model.template.ResourceTemplate serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.ServiceAccountNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceAccountNested<A> withNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluentImpl.ServiceAccountNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaExporterTemplateFluentImpl that = (KafkaExporterTemplateFluentImpl) o;
        if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (service != null ? !service.equals(that.service) :that.service != null) return false;
        if (container != null ? !container.equals(that.container) :that.container != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployment,  pod,  service,  container,  serviceAccount,  super.hashCode());
    }

      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class DeploymentNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.DeploymentNested<N>> implements io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            DeploymentNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            DeploymentNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterTemplateFluentImpl.this.withDeployment(builder.build());
            }

            public N endDeployment() {
                return and();
            }
    }


      
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.PodNested<N>> implements io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodTemplateBuilder builder;

            PodNestedImpl(io.strimzi.api.kafka.model.template.PodTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceNested<N>> implements io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ServiceNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterTemplateFluentImpl.this.withService(builder.build());
            }

            public N endService() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class ContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ContainerNested<N>> implements io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            ContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            ContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterTemplateFluentImpl.this.withContainer(builder.build());
            }

            public N endContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ServiceAccountNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceAccountNested<N>> implements io.strimzi.api.kafka.model.template.KafkaExporterTemplateFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ServiceAccountNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ServiceAccountNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaExporterTemplateFluentImpl.this.withServiceAccount(builder.build());
            }

            public N endServiceAccount() {
                return and();
            }
    }


}
