package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Kafka MirrorMaker 2.0 resources.
   */
  public class KafkaMirrorMaker2TemplateBuilder extends io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.KafkaMirrorMaker2Template,io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateBuilder> {

    io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaMirrorMaker2TemplateBuilder() {
        this(true);
    }

    public KafkaMirrorMaker2TemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaMirrorMaker2Template(), validationEnabled);
    }

    public KafkaMirrorMaker2TemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMaker2TemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMaker2Template(), validationEnabled);
    }

    public KafkaMirrorMaker2TemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaMirrorMaker2Template instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMaker2TemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaMirrorMaker2Template instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withApiService(instance.getApiService());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withMirrorMaker2Container(instance.getMirrorMaker2Container());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        fluent.withJmxSecret(instance.getJmxSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMaker2TemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMaker2Template instance) {
        this(instance,true);
    }

    public KafkaMirrorMaker2TemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMaker2Template instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withMirrorMaker2Container(instance.getMirrorMaker2Container());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.withJmxSecret(instance.getJmxSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2Template build() {
        KafkaMirrorMaker2Template buildable = new KafkaMirrorMaker2Template();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setApiService(fluent.getApiService());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setMirrorMaker2Container(fluent.getMirrorMaker2Container());
        buildable.setServiceAccount(fluent.getServiceAccount());
        buildable.setJmxSecret(fluent.getJmxSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMaker2TemplateBuilder that = (KafkaMirrorMaker2TemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
