package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

  
  /**
   * Representation of a template for Kafka MirrorMaker 2.0 resources.
   */
  public class KafkaMirrorMaker2TemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder deployment;
    private io.strimzi.api.kafka.model.template.PodTemplateBuilder pod;
    private io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder apiService;
    private io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder mirrorMaker2Container;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder serviceAccount;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder jmxSecret;

    public KafkaMirrorMaker2TemplateFluentImpl() {
    }

    public KafkaMirrorMaker2TemplateFluentImpl(io.strimzi.api.kafka.model.template.KafkaMirrorMaker2Template instance) {
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withApiService(instance.getApiService());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withMirrorMaker2Container(instance.getMirrorMaker2Container());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.withJmxSecret(instance.getJmxSecret());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildDeployment instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.DeploymentTemplate getDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public io.strimzi.api.kafka.model.template.DeploymentTemplate buildDeployment() {
        return this.deployment!=null?this.deployment.build():null;
    }

    public A withDeployment(io.strimzi.api.kafka.model.template.DeploymentTemplate deployment) {
        _visitables.get("deployment").remove(this.deployment);
        if (deployment!=null){ this.deployment= new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder(deployment); _visitables.get("deployment").add(this.deployment);} return (A) this;
    }

    public java.lang.Boolean hasDeployment() {
        return this.deployment != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> withNewDeployment() {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.DeploymentNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> withNewDeploymentLike(io.strimzi.api.kafka.model.template.DeploymentTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.DeploymentNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> editDeployment() {
        return withNewDeploymentLike(getDeployment());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> editOrNewDeployment() {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.DeploymentNested<A> editOrNewDeploymentLike(io.strimzi.api.kafka.model.template.DeploymentTemplate item) {
        return withNewDeploymentLike(getDeployment() != null ? getDeployment(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPod instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(io.strimzi.api.kafka.model.template.PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new io.strimzi.api.kafka.model.template.PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public java.lang.Boolean hasPod() {
        return this.pod != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodNested<A> withNewPod() {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.PodNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodNested<A> withNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.PodNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new io.strimzi.api.kafka.model.template.PodTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodNested<A> editOrNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildApiService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.InternalServiceTemplate getApiService() {
        return this.apiService!=null?this.apiService.build():null;
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplate buildApiService() {
        return this.apiService!=null?this.apiService.build():null;
    }

    public A withApiService(io.strimzi.api.kafka.model.template.InternalServiceTemplate apiService) {
        _visitables.get("apiService").remove(this.apiService);
        if (apiService!=null){ this.apiService= new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(apiService); _visitables.get("apiService").add(this.apiService);} return (A) this;
    }

    public java.lang.Boolean hasApiService() {
        return this.apiService != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> withNewApiService() {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.ApiServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> withNewApiServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.ApiServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> editApiService() {
        return withNewApiServiceLike(getApiService());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> editOrNewApiService() {
        return withNewApiServiceLike(getApiService() != null ? getApiService(): new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ApiServiceNested<A> editOrNewApiServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return withNewApiServiceLike(getApiService() != null ? getApiService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodDisruptionBudget instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate podDisruptionBudget) {
        _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
        if (podDisruptionBudget!=null){ this.podDisruptionBudget= new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public java.lang.Boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.PodDisruptionBudgetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.PodDisruptionBudgetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMirrorMaker2Container instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getMirrorMaker2Container() {
        return this.mirrorMaker2Container!=null?this.mirrorMaker2Container.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildMirrorMaker2Container() {
        return this.mirrorMaker2Container!=null?this.mirrorMaker2Container.build():null;
    }

    public A withMirrorMaker2Container(io.strimzi.api.kafka.model.template.ContainerTemplate mirrorMaker2Container) {
        _visitables.get("mirrorMaker2Container").remove(this.mirrorMaker2Container);
        if (mirrorMaker2Container!=null){ this.mirrorMaker2Container= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(mirrorMaker2Container); _visitables.get("mirrorMaker2Container").add(this.mirrorMaker2Container);} return (A) this;
    }

    public java.lang.Boolean hasMirrorMaker2Container() {
        return this.mirrorMaker2Container != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> withNewMirrorMaker2Container() {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.MirrorMaker2ContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> withNewMirrorMaker2ContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.MirrorMaker2ContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> editMirrorMaker2Container() {
        return withNewMirrorMaker2ContainerLike(getMirrorMaker2Container());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> editOrNewMirrorMaker2Container() {
        return withNewMirrorMaker2ContainerLike(getMirrorMaker2Container() != null ? getMirrorMaker2Container(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<A> editOrNewMirrorMaker2ContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewMirrorMaker2ContainerLike(getMirrorMaker2Container() != null ? getMirrorMaker2Container(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccount instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(io.strimzi.api.kafka.model.template.ResourceTemplate serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.ServiceAccountNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ServiceAccountNested<A> withNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.ServiceAccountNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxSecret instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getJmxSecret() {
        return this.jmxSecret!=null?this.jmxSecret.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildJmxSecret() {
        return this.jmxSecret!=null?this.jmxSecret.build():null;
    }

    public A withJmxSecret(io.strimzi.api.kafka.model.template.ResourceTemplate jmxSecret) {
        _visitables.get("jmxSecret").remove(this.jmxSecret);
        if (jmxSecret!=null){ this.jmxSecret= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(jmxSecret); _visitables.get("jmxSecret").add(this.jmxSecret);} return (A) this;
    }

    public java.lang.Boolean hasJmxSecret() {
        return this.jmxSecret != null;
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.JmxSecretNested<A> withNewJmxSecret() {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.JmxSecretNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.JmxSecretNested<A> withNewJmxSecretLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluentImpl.JmxSecretNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.JmxSecretNested<A> editJmxSecret() {
        return withNewJmxSecretLike(getJmxSecret());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.JmxSecretNested<A> editOrNewJmxSecret() {
        return withNewJmxSecretLike(getJmxSecret() != null ? getJmxSecret(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.JmxSecretNested<A> editOrNewJmxSecretLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewJmxSecretLike(getJmxSecret() != null ? getJmxSecret(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        KafkaMirrorMaker2TemplateFluentImpl that = (KafkaMirrorMaker2TemplateFluentImpl) o;
        if (deployment != null ? !deployment.equals(that.deployment) :that.deployment != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (apiService != null ? !apiService.equals(that.apiService) :that.apiService != null) return false;
        if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
        if (mirrorMaker2Container != null ? !mirrorMaker2Container.equals(that.mirrorMaker2Container) :that.mirrorMaker2Container != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        if (jmxSecret != null ? !jmxSecret.equals(that.jmxSecret) :that.jmxSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(deployment,  pod,  apiService,  podDisruptionBudget,  mirrorMaker2Container,  serviceAccount,  jmxSecret,  super.hashCode());
    }

      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class DeploymentNestedImpl<N> extends io.strimzi.api.kafka.model.template.DeploymentTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.DeploymentNested<N>> implements io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.DeploymentNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder builder;

            DeploymentNestedImpl(io.strimzi.api.kafka.model.template.DeploymentTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder(this, item);
                        
            }

            DeploymentNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.DeploymentTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withDeployment(builder.build());
            }

            public N endDeployment() {
                return and();
            }
    }


      
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodNested<N>> implements io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodTemplateBuilder builder;

            PodNestedImpl(io.strimzi.api.kafka.model.template.PodTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi internal services.
   * It contains additional values applicable to internal services..
   */
  public class ApiServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ApiServiceNested<N>> implements io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ApiServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder builder;

            ApiServiceNestedImpl(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this, item);
                        
            }

            ApiServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withApiService(builder.build());
            }

            public N endApiService() {
                return and();
            }
    }


      
  /**
   * Representation of a Pod disruption Budget template template for Strimzi resources.
   */
  public class PodDisruptionBudgetNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<N>> implements io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder builder;

            PodDisruptionBudgetNestedImpl(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this, item);
                        
            }

            PodDisruptionBudgetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
            }

            public N endPodDisruptionBudget() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class MirrorMaker2ContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<N>> implements io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.MirrorMaker2ContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            MirrorMaker2ContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            MirrorMaker2ContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withMirrorMaker2Container(builder.build());
            }

            public N endMirrorMaker2Container() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ServiceAccountNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ServiceAccountNested<N>> implements io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ServiceAccountNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ServiceAccountNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withServiceAccount(builder.build());
            }

            public N endServiceAccount() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class JmxSecretNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.JmxSecretNested<N>> implements io.strimzi.api.kafka.model.template.KafkaMirrorMaker2TemplateFluent.JmxSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            JmxSecretNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            JmxSecretNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) KafkaMirrorMaker2TemplateFluentImpl.this.withJmxSecret(builder.build());
            }

            public N endJmxSecret() {
                return and();
            }
    }


}
