package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Kafka MirrorMaker resources.
   */
  public class KafkaMirrorMakerTemplateBuilder extends io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate,io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateBuilder> {

    io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaMirrorMakerTemplateBuilder() {
        this(true);
    }

    public KafkaMirrorMakerTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaMirrorMakerTemplate(), validationEnabled);
    }

    public KafkaMirrorMakerTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaMirrorMakerTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaMirrorMakerTemplate(), validationEnabled);
    }

    public KafkaMirrorMakerTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaMirrorMakerTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDeployment(instance.getDeployment());
        
        fluent.withPod(instance.getPod());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withMirrorMakerContainer(instance.getMirrorMakerContainer());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaMirrorMakerTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate instance) {
        this(instance,true);
    }

    public KafkaMirrorMakerTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDeployment(instance.getDeployment());
        
        this.withPod(instance.getPod());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withMirrorMakerContainer(instance.getMirrorMakerContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.KafkaMirrorMakerTemplate build() {
        KafkaMirrorMakerTemplate buildable = new KafkaMirrorMakerTemplate();
        buildable.setDeployment(fluent.getDeployment());
        buildable.setPod(fluent.getPod());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setMirrorMakerContainer(fluent.getMirrorMakerContainer());
        buildable.setServiceAccount(fluent.getServiceAccount());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaMirrorMakerTemplateBuilder that = (KafkaMirrorMakerTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
