package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for a KafkaUser resource.
   */
  public class KafkaUserTemplateBuilder extends io.strimzi.api.kafka.model.template.KafkaUserTemplateFluentImpl<io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.KafkaUserTemplate,io.strimzi.api.kafka.model.template.KafkaUserTemplateBuilder> {

    io.strimzi.api.kafka.model.template.KafkaUserTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public KafkaUserTemplateBuilder() {
        this(true);
    }

    public KafkaUserTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new KafkaUserTemplate(), validationEnabled);
    }

    public KafkaUserTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaUserTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public KafkaUserTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaUserTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new KafkaUserTemplate(), validationEnabled);
    }

    public KafkaUserTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaUserTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaUserTemplate instance) {
        this(fluent, instance, true);
    }

    public KafkaUserTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaUserTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.KafkaUserTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withSecret(instance.getSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public KafkaUserTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaUserTemplate instance) {
        this(instance,true);
    }

    public KafkaUserTemplateBuilder(io.strimzi.api.kafka.model.template.KafkaUserTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withSecret(instance.getSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.KafkaUserTemplate build() {
        KafkaUserTemplate buildable = new KafkaUserTemplate();
        buildable.setSecret(fluent.getSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        KafkaUserTemplateBuilder that = (KafkaUserTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
