package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a Metadata template for Strimzi pods, statefulsets, deployments and services.
   */
  public class MetadataTemplateBuilder extends io.strimzi.api.kafka.model.template.MetadataTemplateFluentImpl<io.strimzi.api.kafka.model.template.MetadataTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.MetadataTemplate,io.strimzi.api.kafka.model.template.MetadataTemplateBuilder> {

    io.strimzi.api.kafka.model.template.MetadataTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public MetadataTemplateBuilder() {
        this(true);
    }

    public MetadataTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new MetadataTemplate(), validationEnabled);
    }

    public MetadataTemplateBuilder(io.strimzi.api.kafka.model.template.MetadataTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public MetadataTemplateBuilder(io.strimzi.api.kafka.model.template.MetadataTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new MetadataTemplate(), validationEnabled);
    }

    public MetadataTemplateBuilder(io.strimzi.api.kafka.model.template.MetadataTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.MetadataTemplate instance) {
        this(fluent, instance, true);
    }

    public MetadataTemplateBuilder(io.strimzi.api.kafka.model.template.MetadataTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.MetadataTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLabels(instance.getLabels());
        
        fluent.withAnnotations(instance.getAnnotations());
        
        this.validationEnabled = validationEnabled; 
    }

    public MetadataTemplateBuilder(io.strimzi.api.kafka.model.template.MetadataTemplate instance) {
        this(instance,true);
    }

    public MetadataTemplateBuilder(io.strimzi.api.kafka.model.template.MetadataTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withLabels(instance.getLabels());
        
        this.withAnnotations(instance.getAnnotations());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.MetadataTemplate build() {
        MetadataTemplate buildable = new MetadataTemplate();
        buildable.setLabels(fluent.getLabels());
        buildable.setAnnotations(fluent.getAnnotations());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MetadataTemplateBuilder that = (MetadataTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
