package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodTemplateBuilder extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.PodTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.PodTemplate,io.strimzi.api.kafka.model.template.PodTemplateBuilder> {

    io.strimzi.api.kafka.model.template.PodTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public PodTemplateBuilder() {
        this(true);
    }

    public PodTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new PodTemplate(), validationEnabled);
    }

    public PodTemplateBuilder(io.strimzi.api.kafka.model.template.PodTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public PodTemplateBuilder(io.strimzi.api.kafka.model.template.PodTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new PodTemplate(), validationEnabled);
    }

    public PodTemplateBuilder(io.strimzi.api.kafka.model.template.PodTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.PodTemplate instance) {
        this(fluent, instance, true);
    }

    public PodTemplateBuilder(io.strimzi.api.kafka.model.template.PodTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.PodTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withImagePullSecrets(instance.getImagePullSecrets());
        
        fluent.withSecurityContext(instance.getSecurityContext());
        
        fluent.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        
        fluent.withAffinity(instance.getAffinity());
        
        fluent.withTolerations(instance.getTolerations());
        
        fluent.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        
        fluent.withPriorityClassName(instance.getPriorityClassName());
        
        fluent.withSchedulerName(instance.getSchedulerName());
        
        fluent.withHostAliases(instance.getHostAliases());
        
        fluent.withEnableServiceLinks(instance.getEnableServiceLinks());
        
        fluent.withTmpDirSizeLimit(instance.getTmpDirSizeLimit());
        
        this.validationEnabled = validationEnabled; 
    }

    public PodTemplateBuilder(io.strimzi.api.kafka.model.template.PodTemplate instance) {
        this(instance,true);
    }

    public PodTemplateBuilder(io.strimzi.api.kafka.model.template.PodTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMetadata(instance.getMetadata());
        
        this.withImagePullSecrets(instance.getImagePullSecrets());
        
        this.withSecurityContext(instance.getSecurityContext());
        
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        
        this.withAffinity(instance.getAffinity());
        
        this.withTolerations(instance.getTolerations());
        
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        
        this.withPriorityClassName(instance.getPriorityClassName());
        
        this.withSchedulerName(instance.getSchedulerName());
        
        this.withHostAliases(instance.getHostAliases());
        
        this.withEnableServiceLinks(instance.getEnableServiceLinks());
        
        this.withTmpDirSizeLimit(instance.getTmpDirSizeLimit());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.PodTemplate build() {
        PodTemplate buildable = new PodTemplate();
        buildable.setMetadata(fluent.getMetadata());
        buildable.setImagePullSecrets(fluent.getImagePullSecrets());
        buildable.setSecurityContext(fluent.getSecurityContext());
        buildable.setTerminationGracePeriodSeconds(fluent.getTerminationGracePeriodSeconds());
        buildable.setAffinity(fluent.getAffinity());
        buildable.setTolerations(fluent.getTolerations());
        buildable.setTopologySpreadConstraints(fluent.getTopologySpreadConstraints());
        buildable.setPriorityClassName(fluent.getPriorityClassName());
        buildable.setSchedulerName(fluent.getSchedulerName());
        buildable.setHostAliases(fluent.getHostAliases());
        buildable.setEnableServiceLinks(fluent.getEnableServiceLinks());
        buildable.setTmpDirSizeLimit(fluent.getTmpDirSizeLimit());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        PodTemplateBuilder that = (PodTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
