package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.HostAlias;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

  
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public interface PodTemplateFluent<A extends io.strimzi.api.kafka.model.template.PodTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.MetadataTemplate getMetadata();
    public io.strimzi.api.kafka.model.template.MetadataTemplate buildMetadata();
    public A withMetadata(io.strimzi.api.kafka.model.template.MetadataTemplate metadata);
    public java.lang.Boolean hasMetadata();
    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> withNewMetadata();
    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> withNewMetadataLike(io.strimzi.api.kafka.model.template.MetadataTemplate item);
    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> editMetadata();
    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> editOrNewMetadata();
    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> editOrNewMetadataLike(io.strimzi.api.kafka.model.template.MetadataTemplate item);
    public A addToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item);
    public A setToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item);
    public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
    public A addAllToImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items);
    public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items);
    public A removeAllFromImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items);
    public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> getImagePullSecrets();
    public io.fabric8.kubernetes.api.model.LocalObjectReference getImagePullSecret(int index);
    public io.fabric8.kubernetes.api.model.LocalObjectReference getFirstImagePullSecret();
    public io.fabric8.kubernetes.api.model.LocalObjectReference getLastImagePullSecret();
    public io.fabric8.kubernetes.api.model.LocalObjectReference getMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReference> predicate);
    public java.lang.Boolean hasMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReference> predicate);
    public A withImagePullSecrets(java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets);
    public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets);
    public java.lang.Boolean hasImagePullSecrets();
    public A addNewImagePullSecret(java.lang.String name);
    public io.fabric8.kubernetes.api.model.PodSecurityContext getSecurityContext();
    public A withSecurityContext(io.fabric8.kubernetes.api.model.PodSecurityContext securityContext);
    public java.lang.Boolean hasSecurityContext();
    public int getTerminationGracePeriodSeconds();
    public A withTerminationGracePeriodSeconds(int terminationGracePeriodSeconds);
    public java.lang.Boolean hasTerminationGracePeriodSeconds();
    public io.fabric8.kubernetes.api.model.Affinity getAffinity();
    public A withAffinity(io.fabric8.kubernetes.api.model.Affinity affinity);
    public java.lang.Boolean hasAffinity();
    public A addToTolerations(int index,io.fabric8.kubernetes.api.model.Toleration item);
    public A setToTolerations(int index,io.fabric8.kubernetes.api.model.Toleration item);
    public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
    public A addAllToTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items);
    public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items);
    public A removeAllFromTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items);
    public java.util.List<io.fabric8.kubernetes.api.model.Toleration> getTolerations();
    public io.fabric8.kubernetes.api.model.Toleration getToleration(int index);
    public io.fabric8.kubernetes.api.model.Toleration getFirstToleration();
    public io.fabric8.kubernetes.api.model.Toleration getLastToleration();
    public io.fabric8.kubernetes.api.model.Toleration getMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate);
    public java.lang.Boolean hasMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate);
    public A withTolerations(java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations);
    public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations);
    public java.lang.Boolean hasTolerations();
    public A addNewToleration(java.lang.String effect,java.lang.String key,java.lang.String operator,java.lang.Long tolerationSeconds,java.lang.String value);
    public A addToTopologySpreadConstraints(int index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item);
    public A setToTopologySpreadConstraints(int index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item);
    public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
    public A addAllToTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items);
    public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items);
    public A removeAllFromTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items);
    public java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> getTopologySpreadConstraints();
    public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getTopologySpreadConstraint(int index);
    public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getFirstTopologySpreadConstraint();
    public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getLastTopologySpreadConstraint();
    public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> predicate);
    public java.lang.Boolean hasMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> predicate);
    public A withTopologySpreadConstraints(java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> topologySpreadConstraints);
    public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints);
    public java.lang.Boolean hasTopologySpreadConstraints();
    public java.lang.String getPriorityClassName();
    public A withPriorityClassName(java.lang.String priorityClassName);
    public java.lang.Boolean hasPriorityClassName();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPriorityClassName instead.
     */
        public A withNewPriorityClassName(java.lang.String original);
    public java.lang.String getSchedulerName();
    public A withSchedulerName(java.lang.String schedulerName);
    public java.lang.Boolean hasSchedulerName();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSchedulerName instead.
     */
        public A withNewSchedulerName(java.lang.String original);
    public A addToHostAliases(int index,io.fabric8.kubernetes.api.model.HostAlias item);
    public A setToHostAliases(int index,io.fabric8.kubernetes.api.model.HostAlias item);
    public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
    public A addAllToHostAliases(java.util.Collection<io.fabric8.kubernetes.api.model.HostAlias> items);
    public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items);
    public A removeAllFromHostAliases(java.util.Collection<io.fabric8.kubernetes.api.model.HostAlias> items);
    public java.util.List<io.fabric8.kubernetes.api.model.HostAlias> getHostAliases();
    public io.fabric8.kubernetes.api.model.HostAlias getHostAlias(int index);
    public io.fabric8.kubernetes.api.model.HostAlias getFirstHostAlias();
    public io.fabric8.kubernetes.api.model.HostAlias getLastHostAlias();
    public io.fabric8.kubernetes.api.model.HostAlias getMatchingHostAlias(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HostAlias> predicate);
    public java.lang.Boolean hasMatchingHostAlias(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HostAlias> predicate);
    public A withHostAliases(java.util.List<io.fabric8.kubernetes.api.model.HostAlias> hostAliases);
    public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases);
    public java.lang.Boolean hasHostAliases();
    public java.lang.Boolean getEnableServiceLinks();
    public A withEnableServiceLinks(java.lang.Boolean enableServiceLinks);
    public java.lang.Boolean hasEnableServiceLinks();
    public java.lang.String getTmpDirSizeLimit();
    public A withTmpDirSizeLimit(java.lang.String tmpDirSizeLimit);
    public java.lang.Boolean hasTmpDirSizeLimit();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTmpDirSizeLimit instead.
     */
        public A withNewTmpDirSizeLimit(java.lang.String original);
      
  /**
   * Representation of a Metadata template for Strimzi pods, statefulsets, deployments and services.
   */
  public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,io.strimzi.api.kafka.model.template.MetadataTemplateFluent<io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
