package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.Affinity;
import java.util.Collection;
import java.lang.Object;

  
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.PodTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.PodTemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.MetadataTemplateBuilder metadata;
    private java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets;
    private io.fabric8.kubernetes.api.model.PodSecurityContext securityContext;
    private int terminationGracePeriodSeconds;
    private io.fabric8.kubernetes.api.model.Affinity affinity;
    private java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations;
    private java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> topologySpreadConstraints;
    private java.lang.String priorityClassName;
    private java.lang.String schedulerName;
    private java.util.List<io.fabric8.kubernetes.api.model.HostAlias> hostAliases;
    private java.lang.Boolean enableServiceLinks;
    private java.lang.String tmpDirSizeLimit;

    public PodTemplateFluentImpl() {
    }

    public PodTemplateFluentImpl(io.strimzi.api.kafka.model.template.PodTemplate instance) {
        this.withMetadata(instance.getMetadata());
        
        this.withImagePullSecrets(instance.getImagePullSecrets());
        
        this.withSecurityContext(instance.getSecurityContext());
        
        this.withTerminationGracePeriodSeconds(instance.getTerminationGracePeriodSeconds());
        
        this.withAffinity(instance.getAffinity());
        
        this.withTolerations(instance.getTolerations());
        
        this.withTopologySpreadConstraints(instance.getTopologySpreadConstraints());
        
        this.withPriorityClassName(instance.getPriorityClassName());
        
        this.withSchedulerName(instance.getSchedulerName());
        
        this.withHostAliases(instance.getHostAliases());
        
        this.withEnableServiceLinks(instance.getEnableServiceLinks());
        
        this.withTmpDirSizeLimit(instance.getTmpDirSizeLimit());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.MetadataTemplate getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.strimzi.api.kafka.model.template.MetadataTemplate buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.strimzi.api.kafka.model.template.MetadataTemplate metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.strimzi.api.kafka.model.template.MetadataTemplateBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> withNewMetadata() {
        return new io.strimzi.api.kafka.model.template.PodTemplateFluentImpl.MetadataNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> withNewMetadataLike(io.strimzi.api.kafka.model.template.MetadataTemplate item) {
        return new io.strimzi.api.kafka.model.template.PodTemplateFluentImpl.MetadataNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.strimzi.api.kafka.model.template.MetadataTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<A> editOrNewMetadataLike(io.strimzi.api.kafka.model.template.MetadataTemplate item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
        this.imagePullSecrets.add(index, item);
        return (A)this;
    }

    public A setToImagePullSecrets(int index,io.fabric8.kubernetes.api.model.LocalObjectReference item) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
        this.imagePullSecrets.set(index, item); return (A)this;
    }

    public A addToImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
    }

    public A addAllToImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items) {
        if (this.imagePullSecrets == null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>();}
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {this.imagePullSecrets.add(item);} return (A)this;
    }

    public A removeFromImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... items) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {if (this.imagePullSecrets!= null){ this.imagePullSecrets.remove(item);}} return (A)this;
    }

    public A removeAllFromImagePullSecrets(java.util.Collection<io.fabric8.kubernetes.api.model.LocalObjectReference> items) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item : items) {if (this.imagePullSecrets!= null){ this.imagePullSecrets.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference getImagePullSecret(int index) {
        return this.imagePullSecrets.get(index);
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference getFirstImagePullSecret() {
        return this.imagePullSecrets.get(0);
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference getLastImagePullSecret() {
        return this.imagePullSecrets.get(imagePullSecrets.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.LocalObjectReference getMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReference> predicate) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item: imagePullSecrets) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingImagePullSecret(java.util.function.Predicate<io.fabric8.kubernetes.api.model.LocalObjectReference> predicate) {
        for (io.fabric8.kubernetes.api.model.LocalObjectReference item: imagePullSecrets) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withImagePullSecrets(java.util.List<io.fabric8.kubernetes.api.model.LocalObjectReference> imagePullSecrets) {
        if (this.imagePullSecrets != null) { _visitables.get("imagePullSecrets").removeAll(this.imagePullSecrets);}
        if (imagePullSecrets != null) {this.imagePullSecrets = new java.util.ArrayList<io.fabric8.kubernetes.api.model.LocalObjectReference>(); for (io.fabric8.kubernetes.api.model.LocalObjectReference item : imagePullSecrets){this.addToImagePullSecrets(item);}} else { this.imagePullSecrets = null;} return (A) this;
    }

    public A withImagePullSecrets(io.fabric8.kubernetes.api.model.LocalObjectReference... imagePullSecrets) {
        if (this.imagePullSecrets != null) {this.imagePullSecrets.clear();}
        if (imagePullSecrets != null) {for (io.fabric8.kubernetes.api.model.LocalObjectReference item :imagePullSecrets){ this.addToImagePullSecrets(item);}} return (A) this;
    }

    public java.lang.Boolean hasImagePullSecrets() {
        return imagePullSecrets != null && !imagePullSecrets.isEmpty();
    }

    public A addNewImagePullSecret(java.lang.String name) {
        return (A)addToImagePullSecrets(new LocalObjectReference(name));
    }

    public io.fabric8.kubernetes.api.model.PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public A withSecurityContext(io.fabric8.kubernetes.api.model.PodSecurityContext securityContext) {
        this.securityContext=securityContext; return (A) this;
    }

    public java.lang.Boolean hasSecurityContext() {
        return this.securityContext != null;
    }

    public int getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public A withTerminationGracePeriodSeconds(int terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds=terminationGracePeriodSeconds; return (A) this;
    }

    public java.lang.Boolean hasTerminationGracePeriodSeconds() {
        return true;
    }

    public io.fabric8.kubernetes.api.model.Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(io.fabric8.kubernetes.api.model.Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public java.lang.Boolean hasAffinity() {
        return this.affinity != null;
    }

    public A addToTolerations(int index,io.fabric8.kubernetes.api.model.Toleration item) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,io.fabric8.kubernetes.api.model.Toleration item) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>();}
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(io.fabric8.kubernetes.api.model.Toleration... items) {
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(java.util.Collection<io.fabric8.kubernetes.api.model.Toleration> items) {
        for (io.fabric8.kubernetes.api.model.Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.Toleration> getTolerations() {
        return this.tolerations;
    }

    public io.fabric8.kubernetes.api.model.Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public io.fabric8.kubernetes.api.model.Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public io.fabric8.kubernetes.api.model.Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.Toleration getMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
        for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingToleration(java.util.function.Predicate<io.fabric8.kubernetes.api.model.Toleration> predicate) {
        for (io.fabric8.kubernetes.api.model.Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTolerations(java.util.List<io.fabric8.kubernetes.api.model.Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new java.util.ArrayList<io.fabric8.kubernetes.api.model.Toleration>(); for (io.fabric8.kubernetes.api.model.Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(io.fabric8.kubernetes.api.model.Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (io.fabric8.kubernetes.api.model.Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public java.lang.Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(java.lang.String effect,java.lang.String key,java.lang.String operator,java.lang.Long tolerationSeconds,java.lang.String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public A addToTopologySpreadConstraints(int index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
        this.topologySpreadConstraints.add(index, item);
        return (A)this;
    }

    public A setToTopologySpreadConstraints(int index,io.fabric8.kubernetes.api.model.TopologySpreadConstraint item) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
        this.topologySpreadConstraints.set(index, item); return (A)this;
    }

    public A addToTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
        for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
    }

    public A addAllToTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items) {
        if (this.topologySpreadConstraints == null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>();}
        for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {this.topologySpreadConstraints.add(item);} return (A)this;
    }

    public A removeFromTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... items) {
        for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
    }

    public A removeAllFromTopologySpreadConstraints(java.util.Collection<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> items) {
        for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : items) {if (this.topologySpreadConstraints!= null){ this.topologySpreadConstraints.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getTopologySpreadConstraint(int index) {
        return this.topologySpreadConstraints.get(index);
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getFirstTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(0);
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getLastTopologySpreadConstraint() {
        return this.topologySpreadConstraints.get(topologySpreadConstraints.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.TopologySpreadConstraint getMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> predicate) {
        for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingTopologySpreadConstraint(java.util.function.Predicate<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> predicate) {
        for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item: topologySpreadConstraints) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTopologySpreadConstraints(java.util.List<io.fabric8.kubernetes.api.model.TopologySpreadConstraint> topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) { _visitables.get("topologySpreadConstraints").removeAll(this.topologySpreadConstraints);}
        if (topologySpreadConstraints != null) {this.topologySpreadConstraints = new java.util.ArrayList<io.fabric8.kubernetes.api.model.TopologySpreadConstraint>(); for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item : topologySpreadConstraints){this.addToTopologySpreadConstraints(item);}} else { this.topologySpreadConstraints = null;} return (A) this;
    }

    public A withTopologySpreadConstraints(io.fabric8.kubernetes.api.model.TopologySpreadConstraint... topologySpreadConstraints) {
        if (this.topologySpreadConstraints != null) {this.topologySpreadConstraints.clear();}
        if (topologySpreadConstraints != null) {for (io.fabric8.kubernetes.api.model.TopologySpreadConstraint item :topologySpreadConstraints){ this.addToTopologySpreadConstraints(item);}} return (A) this;
    }

    public java.lang.Boolean hasTopologySpreadConstraints() {
        return topologySpreadConstraints != null && !topologySpreadConstraints.isEmpty();
    }

    public java.lang.String getPriorityClassName() {
        return this.priorityClassName;
    }

    public A withPriorityClassName(java.lang.String priorityClassName) {
        this.priorityClassName=priorityClassName; return (A) this;
    }

    public java.lang.Boolean hasPriorityClassName() {
        return this.priorityClassName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withPriorityClassName instead.
     */
        public A withNewPriorityClassName(java.lang.String original) {
        return (A)withPriorityClassName(new String(original));
    }

    public java.lang.String getSchedulerName() {
        return this.schedulerName;
    }

    public A withSchedulerName(java.lang.String schedulerName) {
        this.schedulerName=schedulerName; return (A) this;
    }

    public java.lang.Boolean hasSchedulerName() {
        return this.schedulerName != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withSchedulerName instead.
     */
        public A withNewSchedulerName(java.lang.String original) {
        return (A)withSchedulerName(new String(original));
    }

    public A addToHostAliases(int index,io.fabric8.kubernetes.api.model.HostAlias item) {
        if (this.hostAliases == null) {this.hostAliases = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HostAlias>();}
        this.hostAliases.add(index, item);
        return (A)this;
    }

    public A setToHostAliases(int index,io.fabric8.kubernetes.api.model.HostAlias item) {
        if (this.hostAliases == null) {this.hostAliases = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HostAlias>();}
        this.hostAliases.set(index, item); return (A)this;
    }

    public A addToHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
        if (this.hostAliases == null) {this.hostAliases = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HostAlias>();}
        for (io.fabric8.kubernetes.api.model.HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
    }

    public A addAllToHostAliases(java.util.Collection<io.fabric8.kubernetes.api.model.HostAlias> items) {
        if (this.hostAliases == null) {this.hostAliases = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HostAlias>();}
        for (io.fabric8.kubernetes.api.model.HostAlias item : items) {this.hostAliases.add(item);} return (A)this;
    }

    public A removeFromHostAliases(io.fabric8.kubernetes.api.model.HostAlias... items) {
        for (io.fabric8.kubernetes.api.model.HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
    }

    public A removeAllFromHostAliases(java.util.Collection<io.fabric8.kubernetes.api.model.HostAlias> items) {
        for (io.fabric8.kubernetes.api.model.HostAlias item : items) {if (this.hostAliases!= null){ this.hostAliases.remove(item);}} return (A)this;
    }

    public java.util.List<io.fabric8.kubernetes.api.model.HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    public io.fabric8.kubernetes.api.model.HostAlias getHostAlias(int index) {
        return this.hostAliases.get(index);
    }

    public io.fabric8.kubernetes.api.model.HostAlias getFirstHostAlias() {
        return this.hostAliases.get(0);
    }

    public io.fabric8.kubernetes.api.model.HostAlias getLastHostAlias() {
        return this.hostAliases.get(hostAliases.size() - 1);
    }

    public io.fabric8.kubernetes.api.model.HostAlias getMatchingHostAlias(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HostAlias> predicate) {
        for (io.fabric8.kubernetes.api.model.HostAlias item: hostAliases) { if(predicate.test(item)){ return item;} } return null;
    }

    public java.lang.Boolean hasMatchingHostAlias(java.util.function.Predicate<io.fabric8.kubernetes.api.model.HostAlias> predicate) {
        for (io.fabric8.kubernetes.api.model.HostAlias item: hostAliases) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withHostAliases(java.util.List<io.fabric8.kubernetes.api.model.HostAlias> hostAliases) {
        if (this.hostAliases != null) { _visitables.get("hostAliases").removeAll(this.hostAliases);}
        if (hostAliases != null) {this.hostAliases = new java.util.ArrayList<io.fabric8.kubernetes.api.model.HostAlias>(); for (io.fabric8.kubernetes.api.model.HostAlias item : hostAliases){this.addToHostAliases(item);}} else { this.hostAliases = null;} return (A) this;
    }

    public A withHostAliases(io.fabric8.kubernetes.api.model.HostAlias... hostAliases) {
        if (this.hostAliases != null) {this.hostAliases.clear();}
        if (hostAliases != null) {for (io.fabric8.kubernetes.api.model.HostAlias item :hostAliases){ this.addToHostAliases(item);}} return (A) this;
    }

    public java.lang.Boolean hasHostAliases() {
        return hostAliases != null && !hostAliases.isEmpty();
    }

    public java.lang.Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    public A withEnableServiceLinks(java.lang.Boolean enableServiceLinks) {
        this.enableServiceLinks=enableServiceLinks; return (A) this;
    }

    public java.lang.Boolean hasEnableServiceLinks() {
        return this.enableServiceLinks != null;
    }

    public java.lang.String getTmpDirSizeLimit() {
        return this.tmpDirSizeLimit;
    }

    public A withTmpDirSizeLimit(java.lang.String tmpDirSizeLimit) {
        this.tmpDirSizeLimit=tmpDirSizeLimit; return (A) this;
    }

    public java.lang.Boolean hasTmpDirSizeLimit() {
        return this.tmpDirSizeLimit != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withTmpDirSizeLimit instead.
     */
        public A withNewTmpDirSizeLimit(java.lang.String original) {
        return (A)withTmpDirSizeLimit(new String(original));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        PodTemplateFluentImpl that = (PodTemplateFluentImpl) o;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (imagePullSecrets != null ? !imagePullSecrets.equals(that.imagePullSecrets) :that.imagePullSecrets != null) return false;
        if (securityContext != null ? !securityContext.equals(that.securityContext) :that.securityContext != null) return false;
        if (terminationGracePeriodSeconds != that.terminationGracePeriodSeconds) return false;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        if (topologySpreadConstraints != null ? !topologySpreadConstraints.equals(that.topologySpreadConstraints) :that.topologySpreadConstraints != null) return false;
        if (priorityClassName != null ? !priorityClassName.equals(that.priorityClassName) :that.priorityClassName != null) return false;
        if (schedulerName != null ? !schedulerName.equals(that.schedulerName) :that.schedulerName != null) return false;
        if (hostAliases != null ? !hostAliases.equals(that.hostAliases) :that.hostAliases != null) return false;
        if (enableServiceLinks != null ? !enableServiceLinks.equals(that.enableServiceLinks) :that.enableServiceLinks != null) return false;
        if (tmpDirSizeLimit != null ? !tmpDirSizeLimit.equals(that.tmpDirSizeLimit) :that.tmpDirSizeLimit != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(metadata,  imagePullSecrets,  securityContext,  terminationGracePeriodSeconds,  affinity,  tolerations,  topologySpreadConstraints,  priorityClassName,  schedulerName,  hostAliases,  enableServiceLinks,  tmpDirSizeLimit,  super.hashCode());
    }

      
  /**
   * Representation of a Metadata template for Strimzi pods, statefulsets, deployments and services.
   */
  public class MetadataNestedImpl<N> extends io.strimzi.api.kafka.model.template.MetadataTemplateFluentImpl<io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<N>> implements io.strimzi.api.kafka.model.template.PodTemplateFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.MetadataTemplateBuilder builder;

            MetadataNestedImpl(io.strimzi.api.kafka.model.template.MetadataTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.MetadataTemplateBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.MetadataTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) PodTemplateFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


}
