package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ResourceTemplateBuilder extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.ResourceTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.ResourceTemplate,io.strimzi.api.kafka.model.template.ResourceTemplateBuilder> {

    io.strimzi.api.kafka.model.template.ResourceTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ResourceTemplateBuilder() {
        this(true);
    }

    public ResourceTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new ResourceTemplate(), validationEnabled);
    }

    public ResourceTemplateBuilder(io.strimzi.api.kafka.model.template.ResourceTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceTemplateBuilder(io.strimzi.api.kafka.model.template.ResourceTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ResourceTemplate(), validationEnabled);
    }

    public ResourceTemplateBuilder(io.strimzi.api.kafka.model.template.ResourceTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.ResourceTemplate instance) {
        this(fluent, instance, true);
    }

    public ResourceTemplateBuilder(io.strimzi.api.kafka.model.template.ResourceTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.ResourceTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMetadata(instance.getMetadata());
        
        this.validationEnabled = validationEnabled; 
    }

    public ResourceTemplateBuilder(io.strimzi.api.kafka.model.template.ResourceTemplate instance) {
        this(instance,true);
    }

    public ResourceTemplateBuilder(io.strimzi.api.kafka.model.template.ResourceTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMetadata(instance.getMetadata());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate build() {
        ResourceTemplate buildable = new ResourceTemplate();
        buildable.setMetadata(fluent.getMetadata());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceTemplateBuilder that = (ResourceTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
