package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for Strimzi resources.
   */
  public class StatefulSetTemplateBuilder extends io.strimzi.api.kafka.model.template.StatefulSetTemplateFluentImpl<io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.StatefulSetTemplate,io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder> {

    io.strimzi.api.kafka.model.template.StatefulSetTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public StatefulSetTemplateBuilder() {
        this(true);
    }

    public StatefulSetTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new StatefulSetTemplate(), validationEnabled);
    }

    public StatefulSetTemplateBuilder(io.strimzi.api.kafka.model.template.StatefulSetTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public StatefulSetTemplateBuilder(io.strimzi.api.kafka.model.template.StatefulSetTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new StatefulSetTemplate(), validationEnabled);
    }

    public StatefulSetTemplateBuilder(io.strimzi.api.kafka.model.template.StatefulSetTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.StatefulSetTemplate instance) {
        this(fluent, instance, true);
    }

    public StatefulSetTemplateBuilder(io.strimzi.api.kafka.model.template.StatefulSetTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.StatefulSetTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withMetadata(instance.getMetadata());
        
        fluent.withPodManagementPolicy(instance.getPodManagementPolicy());
        
        this.validationEnabled = validationEnabled; 
    }

    public StatefulSetTemplateBuilder(io.strimzi.api.kafka.model.template.StatefulSetTemplate instance) {
        this(instance,true);
    }

    public StatefulSetTemplateBuilder(io.strimzi.api.kafka.model.template.StatefulSetTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withMetadata(instance.getMetadata());
        
        this.withPodManagementPolicy(instance.getPodManagementPolicy());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.StatefulSetTemplate build() {
        StatefulSetTemplate buildable = new StatefulSetTemplate();
        buildable.setMetadata(fluent.getMetadata());
        buildable.setPodManagementPolicy(fluent.getPodManagementPolicy());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        StatefulSetTemplateBuilder that = (StatefulSetTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
