package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

  
  /**
   * Representation of a template for ZooKeeper cluster resources.
   */
  public class ZookeeperClusterTemplateBuilder extends io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate,io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateBuilder> {

    io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ZookeeperClusterTemplateBuilder() {
        this(true);
    }

    public ZookeeperClusterTemplateBuilder(java.lang.Boolean validationEnabled) {
        this(new ZookeeperClusterTemplate(), validationEnabled);
    }

    public ZookeeperClusterTemplateBuilder(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent<?> fluent) {
        this(fluent, true);
    }

    public ZookeeperClusterTemplateBuilder(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ZookeeperClusterTemplate(), validationEnabled);
    }

    public ZookeeperClusterTemplateBuilder(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate instance) {
        this(fluent, instance, true);
    }

    public ZookeeperClusterTemplateBuilder(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent<?> fluent,io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withStatefulset(instance.getStatefulset());
        
        fluent.withPodSet(instance.getPodSet());
        
        fluent.withPod(instance.getPod());
        
        fluent.withClientService(instance.getClientService());
        
        fluent.withNodesService(instance.getNodesService());
        
        fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        fluent.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        fluent.withZookeeperContainer(instance.getZookeeperContainer());
        
        fluent.withServiceAccount(instance.getServiceAccount());
        
        fluent.withJmxSecret(instance.getJmxSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public ZookeeperClusterTemplateBuilder(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate instance) {
        this(instance,true);
    }

    public ZookeeperClusterTemplateBuilder(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withStatefulset(instance.getStatefulset());
        
        this.withPodSet(instance.getPodSet());
        
        this.withPod(instance.getPod());
        
        this.withClientService(instance.getClientService());
        
        this.withNodesService(instance.getNodesService());
        
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withZookeeperContainer(instance.getZookeeperContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.withJmxSecret(instance.getJmxSecret());
        
        this.validationEnabled = validationEnabled; 
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate build() {
        ZookeeperClusterTemplate buildable = new ZookeeperClusterTemplate();
        buildable.setStatefulset(fluent.getStatefulset());
        buildable.setPodSet(fluent.getPodSet());
        buildable.setPod(fluent.getPod());
        buildable.setClientService(fluent.getClientService());
        buildable.setNodesService(fluent.getNodesService());
        buildable.setPersistentVolumeClaim(fluent.getPersistentVolumeClaim());
        buildable.setPodDisruptionBudget(fluent.getPodDisruptionBudget());
        buildable.setZookeeperContainer(fluent.getZookeeperContainer());
        buildable.setServiceAccount(fluent.getServiceAccount());
        buildable.setJmxSecret(fluent.getJmxSecret());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ZookeeperClusterTemplateBuilder that = (ZookeeperClusterTemplateBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
