package io.strimzi.api.kafka.model.template;

import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;

  
  /**
   * Representation of a template for ZooKeeper cluster resources.
   */
  public class ZookeeperClusterTemplateFluentImpl<A extends io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent<A> {

    private io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder statefulset;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder podSet;
    private io.strimzi.api.kafka.model.template.PodTemplateBuilder pod;
    private io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder clientService;
    private io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder nodesService;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder persistentVolumeClaim;
    private io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder podDisruptionBudget;
    private io.strimzi.api.kafka.model.template.ContainerTemplateBuilder zookeeperContainer;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder serviceAccount;
    private io.strimzi.api.kafka.model.template.ResourceTemplateBuilder jmxSecret;

    public ZookeeperClusterTemplateFluentImpl() {
    }

    public ZookeeperClusterTemplateFluentImpl(io.strimzi.api.kafka.model.template.ZookeeperClusterTemplate instance) {
        this.withStatefulset(instance.getStatefulset());
        
        this.withPodSet(instance.getPodSet());
        
        this.withPod(instance.getPod());
        
        this.withClientService(instance.getClientService());
        
        this.withNodesService(instance.getNodesService());
        
        this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim());
        
        this.withPodDisruptionBudget(instance.getPodDisruptionBudget());
        
        this.withZookeeperContainer(instance.getZookeeperContainer());
        
        this.withServiceAccount(instance.getServiceAccount());
        
        this.withJmxSecret(instance.getJmxSecret());
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildStatefulset instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.StatefulSetTemplate getStatefulset() {
        return this.statefulset!=null?this.statefulset.build():null;
    }

    public io.strimzi.api.kafka.model.template.StatefulSetTemplate buildStatefulset() {
        return this.statefulset!=null?this.statefulset.build():null;
    }

    public A withStatefulset(io.strimzi.api.kafka.model.template.StatefulSetTemplate statefulset) {
        _visitables.get("statefulset").remove(this.statefulset);
        if (statefulset!=null){ this.statefulset= new io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder(statefulset); _visitables.get("statefulset").add(this.statefulset);} return (A) this;
    }

    public java.lang.Boolean hasStatefulset() {
        return this.statefulset != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.StatefulsetNested<A> withNewStatefulset() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.StatefulsetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.StatefulsetNested<A> withNewStatefulsetLike(io.strimzi.api.kafka.model.template.StatefulSetTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.StatefulsetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.StatefulsetNested<A> editStatefulset() {
        return withNewStatefulsetLike(getStatefulset());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.StatefulsetNested<A> editOrNewStatefulset() {
        return withNewStatefulsetLike(getStatefulset() != null ? getStatefulset(): new io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.StatefulsetNested<A> editOrNewStatefulsetLike(io.strimzi.api.kafka.model.template.StatefulSetTemplate item) {
        return withNewStatefulsetLike(getStatefulset() != null ? getStatefulset(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodSet instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getPodSet() {
        return this.podSet!=null?this.podSet.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildPodSet() {
        return this.podSet!=null?this.podSet.build():null;
    }

    public A withPodSet(io.strimzi.api.kafka.model.template.ResourceTemplate podSet) {
        _visitables.get("podSet").remove(this.podSet);
        if (podSet!=null){ this.podSet= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(podSet); _visitables.get("podSet").add(this.podSet);} return (A) this;
    }

    public java.lang.Boolean hasPodSet() {
        return this.podSet != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodSetNested<A> withNewPodSet() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.PodSetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodSetNested<A> withNewPodSetLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.PodSetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodSetNested<A> editPodSet() {
        return withNewPodSetLike(getPodSet());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodSetNested<A> editOrNewPodSet() {
        return withNewPodSetLike(getPodSet() != null ? getPodSet(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodSetNested<A> editOrNewPodSetLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewPodSetLike(getPodSet() != null ? getPodSet(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPod instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodTemplate getPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodTemplate buildPod() {
        return this.pod!=null?this.pod.build():null;
    }

    public A withPod(io.strimzi.api.kafka.model.template.PodTemplate pod) {
        _visitables.get("pod").remove(this.pod);
        if (pod!=null){ this.pod= new io.strimzi.api.kafka.model.template.PodTemplateBuilder(pod); _visitables.get("pod").add(this.pod);} return (A) this;
    }

    public java.lang.Boolean hasPod() {
        return this.pod != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodNested<A> withNewPod() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.PodNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodNested<A> withNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.PodNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodNested<A> editPod() {
        return withNewPodLike(getPod());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodNested<A> editOrNewPod() {
        return withNewPodLike(getPod() != null ? getPod(): new io.strimzi.api.kafka.model.template.PodTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodNested<A> editOrNewPodLike(io.strimzi.api.kafka.model.template.PodTemplate item) {
        return withNewPodLike(getPod() != null ? getPod(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildClientService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.InternalServiceTemplate getClientService() {
        return this.clientService!=null?this.clientService.build():null;
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplate buildClientService() {
        return this.clientService!=null?this.clientService.build():null;
    }

    public A withClientService(io.strimzi.api.kafka.model.template.InternalServiceTemplate clientService) {
        _visitables.get("clientService").remove(this.clientService);
        if (clientService!=null){ this.clientService= new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(clientService); _visitables.get("clientService").add(this.clientService);} return (A) this;
    }

    public java.lang.Boolean hasClientService() {
        return this.clientService != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ClientServiceNested<A> withNewClientService() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.ClientServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ClientServiceNested<A> withNewClientServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.ClientServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ClientServiceNested<A> editClientService() {
        return withNewClientServiceLike(getClientService());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ClientServiceNested<A> editOrNewClientService() {
        return withNewClientServiceLike(getClientService() != null ? getClientService(): new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ClientServiceNested<A> editOrNewClientServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return withNewClientServiceLike(getClientService() != null ? getClientService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildNodesService instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.InternalServiceTemplate getNodesService() {
        return this.nodesService!=null?this.nodesService.build():null;
    }

    public io.strimzi.api.kafka.model.template.InternalServiceTemplate buildNodesService() {
        return this.nodesService!=null?this.nodesService.build():null;
    }

    public A withNodesService(io.strimzi.api.kafka.model.template.InternalServiceTemplate nodesService) {
        _visitables.get("nodesService").remove(this.nodesService);
        if (nodesService!=null){ this.nodesService= new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(nodesService); _visitables.get("nodesService").add(this.nodesService);} return (A) this;
    }

    public java.lang.Boolean hasNodesService() {
        return this.nodesService != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.NodesServiceNested<A> withNewNodesService() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.NodesServiceNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.NodesServiceNested<A> withNewNodesServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.NodesServiceNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.NodesServiceNested<A> editNodesService() {
        return withNewNodesServiceLike(getNodesService());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.NodesServiceNested<A> editOrNewNodesService() {
        return withNewNodesServiceLike(getNodesService() != null ? getNodesService(): new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.NodesServiceNested<A> editOrNewNodesServiceLike(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
        return withNewNodesServiceLike(getNodesService() != null ? getNodesService(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPersistentVolumeClaim instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildPersistentVolumeClaim() {
        return this.persistentVolumeClaim!=null?this.persistentVolumeClaim.build():null;
    }

    public A withPersistentVolumeClaim(io.strimzi.api.kafka.model.template.ResourceTemplate persistentVolumeClaim) {
        _visitables.get("persistentVolumeClaim").remove(this.persistentVolumeClaim);
        if (persistentVolumeClaim!=null){ this.persistentVolumeClaim= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(persistentVolumeClaim); _visitables.get("persistentVolumeClaim").add(this.persistentVolumeClaim);} return (A) this;
    }

    public java.lang.Boolean hasPersistentVolumeClaim() {
        return this.persistentVolumeClaim != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.PersistentVolumeClaimNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.PersistentVolumeClaimNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim() {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewPersistentVolumeClaimLike(getPersistentVolumeClaim() != null ? getPersistentVolumeClaim(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildPodDisruptionBudget instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate getPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate buildPodDisruptionBudget() {
        return this.podDisruptionBudget!=null?this.podDisruptionBudget.build():null;
    }

    public A withPodDisruptionBudget(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate podDisruptionBudget) {
        _visitables.get("podDisruptionBudget").remove(this.podDisruptionBudget);
        if (podDisruptionBudget!=null){ this.podDisruptionBudget= new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(podDisruptionBudget); _visitables.get("podDisruptionBudget").add(this.podDisruptionBudget);} return (A) this;
    }

    public java.lang.Boolean hasPodDisruptionBudget() {
        return this.podDisruptionBudget != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudget() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.PodDisruptionBudgetNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> withNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.PodDisruptionBudgetNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> editPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudget() {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<A> editOrNewPodDisruptionBudgetLike(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
        return withNewPodDisruptionBudgetLike(getPodDisruptionBudget() != null ? getPodDisruptionBudget(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildZookeeperContainer instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ContainerTemplate getZookeeperContainer() {
        return this.zookeeperContainer!=null?this.zookeeperContainer.build():null;
    }

    public io.strimzi.api.kafka.model.template.ContainerTemplate buildZookeeperContainer() {
        return this.zookeeperContainer!=null?this.zookeeperContainer.build():null;
    }

    public A withZookeeperContainer(io.strimzi.api.kafka.model.template.ContainerTemplate zookeeperContainer) {
        _visitables.get("zookeeperContainer").remove(this.zookeeperContainer);
        if (zookeeperContainer!=null){ this.zookeeperContainer= new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(zookeeperContainer); _visitables.get("zookeeperContainer").add(this.zookeeperContainer);} return (A) this;
    }

    public java.lang.Boolean hasZookeeperContainer() {
        return this.zookeeperContainer != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> withNewZookeeperContainer() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.ZookeeperContainerNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> withNewZookeeperContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.ZookeeperContainerNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> editZookeeperContainer() {
        return withNewZookeeperContainerLike(getZookeeperContainer());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> editOrNewZookeeperContainer() {
        return withNewZookeeperContainerLike(getZookeeperContainer() != null ? getZookeeperContainer(): new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ZookeeperContainerNested<A> editOrNewZookeeperContainerLike(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
        return withNewZookeeperContainerLike(getZookeeperContainer() != null ? getZookeeperContainer(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildServiceAccount instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildServiceAccount() {
        return this.serviceAccount!=null?this.serviceAccount.build():null;
    }

    public A withServiceAccount(io.strimzi.api.kafka.model.template.ResourceTemplate serviceAccount) {
        _visitables.get("serviceAccount").remove(this.serviceAccount);
        if (serviceAccount!=null){ this.serviceAccount= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(serviceAccount); _visitables.get("serviceAccount").add(this.serviceAccount);} return (A) this;
    }

    public java.lang.Boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ServiceAccountNested<A> withNewServiceAccount() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.ServiceAccountNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ServiceAccountNested<A> withNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.ServiceAccountNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ServiceAccountNested<A> editServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccount() {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ServiceAccountNested<A> editOrNewServiceAccountLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewServiceAccountLike(getServiceAccount() != null ? getServiceAccount(): item);
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildJmxSecret instead.
     * @return The buildable object.
     */
        public io.strimzi.api.kafka.model.template.ResourceTemplate getJmxSecret() {
        return this.jmxSecret!=null?this.jmxSecret.build():null;
    }

    public io.strimzi.api.kafka.model.template.ResourceTemplate buildJmxSecret() {
        return this.jmxSecret!=null?this.jmxSecret.build():null;
    }

    public A withJmxSecret(io.strimzi.api.kafka.model.template.ResourceTemplate jmxSecret) {
        _visitables.get("jmxSecret").remove(this.jmxSecret);
        if (jmxSecret!=null){ this.jmxSecret= new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(jmxSecret); _visitables.get("jmxSecret").add(this.jmxSecret);} return (A) this;
    }

    public java.lang.Boolean hasJmxSecret() {
        return this.jmxSecret != null;
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.JmxSecretNested<A> withNewJmxSecret() {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.JmxSecretNestedImpl();
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.JmxSecretNested<A> withNewJmxSecretLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return new io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluentImpl.JmxSecretNestedImpl(item);
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.JmxSecretNested<A> editJmxSecret() {
        return withNewJmxSecretLike(getJmxSecret());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.JmxSecretNested<A> editOrNewJmxSecret() {
        return withNewJmxSecretLike(getJmxSecret() != null ? getJmxSecret(): new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder().build());
    }

    public io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.JmxSecretNested<A> editOrNewJmxSecretLike(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
        return withNewJmxSecretLike(getJmxSecret() != null ? getJmxSecret(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ZookeeperClusterTemplateFluentImpl that = (ZookeeperClusterTemplateFluentImpl) o;
        if (statefulset != null ? !statefulset.equals(that.statefulset) :that.statefulset != null) return false;
        if (podSet != null ? !podSet.equals(that.podSet) :that.podSet != null) return false;
        if (pod != null ? !pod.equals(that.pod) :that.pod != null) return false;
        if (clientService != null ? !clientService.equals(that.clientService) :that.clientService != null) return false;
        if (nodesService != null ? !nodesService.equals(that.nodesService) :that.nodesService != null) return false;
        if (persistentVolumeClaim != null ? !persistentVolumeClaim.equals(that.persistentVolumeClaim) :that.persistentVolumeClaim != null) return false;
        if (podDisruptionBudget != null ? !podDisruptionBudget.equals(that.podDisruptionBudget) :that.podDisruptionBudget != null) return false;
        if (zookeeperContainer != null ? !zookeeperContainer.equals(that.zookeeperContainer) :that.zookeeperContainer != null) return false;
        if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
        if (jmxSecret != null ? !jmxSecret.equals(that.jmxSecret) :that.jmxSecret != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(statefulset,  podSet,  pod,  clientService,  nodesService,  persistentVolumeClaim,  podDisruptionBudget,  zookeeperContainer,  serviceAccount,  jmxSecret,  super.hashCode());
    }

      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class StatefulsetNestedImpl<N> extends io.strimzi.api.kafka.model.template.StatefulSetTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.StatefulsetNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.StatefulsetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder builder;

            StatefulsetNestedImpl(io.strimzi.api.kafka.model.template.StatefulSetTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder(this, item);
                        
            }

            StatefulsetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.StatefulSetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withStatefulset(builder.build());
            }

            public N endStatefulset() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class PodSetNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodSetNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodSetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            PodSetNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            PodSetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withPodSet(builder.build());
            }

            public N endPodSet() {
                return and();
            }
    }


      
  /**
   * Representation of a pod template for Strimzi resources.
   */
  public class PodNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodTemplateBuilder builder;

            PodNestedImpl(io.strimzi.api.kafka.model.template.PodTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this, item);
                        
            }

            PodNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withPod(builder.build());
            }

            public N endPod() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi internal services.
   * It contains additional values applicable to internal services..
   */
  public class ClientServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ClientServiceNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ClientServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder builder;

            ClientServiceNestedImpl(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this, item);
                        
            }

            ClientServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withClientService(builder.build());
            }

            public N endClientService() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi internal services.
   * It contains additional values applicable to internal services..
   */
  public class NodesServiceNestedImpl<N> extends io.strimzi.api.kafka.model.template.InternalServiceTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.NodesServiceNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.NodesServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder builder;

            NodesServiceNestedImpl(io.strimzi.api.kafka.model.template.InternalServiceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this, item);
                        
            }

            NodesServiceNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.InternalServiceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withNodesService(builder.build());
            }

            public N endNodesService() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class PersistentVolumeClaimNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PersistentVolumeClaimNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            PersistentVolumeClaimNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            PersistentVolumeClaimNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withPersistentVolumeClaim(builder.build());
            }

            public N endPersistentVolumeClaim() {
                return and();
            }
    }


      
  /**
   * Representation of a Pod disruption Budget template template for Strimzi resources.
   */
  public class PodDisruptionBudgetNestedImpl<N> extends io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.PodDisruptionBudgetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder builder;

            PodDisruptionBudgetNestedImpl(io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this, item);
                        
            }

            PodDisruptionBudgetNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.PodDisruptionBudgetTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withPodDisruptionBudget(builder.build());
            }

            public N endPodDisruptionBudget() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi containers.
   */
  public class ZookeeperContainerNestedImpl<N> extends io.strimzi.api.kafka.model.template.ContainerTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ZookeeperContainerNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ZookeeperContainerNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ContainerTemplateBuilder builder;

            ZookeeperContainerNestedImpl(io.strimzi.api.kafka.model.template.ContainerTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this, item);
                        
            }

            ZookeeperContainerNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ContainerTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withZookeeperContainer(builder.build());
            }

            public N endZookeeperContainer() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class ServiceAccountNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ServiceAccountNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.ServiceAccountNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            ServiceAccountNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            ServiceAccountNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withServiceAccount(builder.build());
            }

            public N endServiceAccount() {
                return and();
            }
    }


      
  /**
   * Representation of a template for Strimzi resources.
   */
  public class JmxSecretNestedImpl<N> extends io.strimzi.api.kafka.model.template.ResourceTemplateFluentImpl<io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.JmxSecretNested<N>> implements io.strimzi.api.kafka.model.template.ZookeeperClusterTemplateFluent.JmxSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.strimzi.api.kafka.model.template.ResourceTemplateBuilder builder;

            JmxSecretNestedImpl(io.strimzi.api.kafka.model.template.ResourceTemplate item) {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this, item);
                        
            }

            JmxSecretNestedImpl() {
                this.builder = new io.strimzi.api.kafka.model.template.ResourceTemplateBuilder(this);
                        
            }

            public N and() {
                return (N) ZookeeperClusterTemplateFluentImpl.this.withJmxSecret(builder.build());
            }

            public N endJmxSecret() {
                return and();
            }
    }


}
