/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.ClientTls;
import io.strimzi.api.kafka.model.ClientTlsFluent;
import io.strimzi.api.kafka.model.ClientTlsFluentImpl;
import java.util.Objects;

public class ClientTlsBuilder
extends ClientTlsFluentImpl<ClientTlsBuilder>
implements VisitableBuilder<ClientTls, ClientTlsBuilder> {
    ClientTlsFluent<?> fluent;
    Boolean validationEnabled;

    public ClientTlsBuilder() {
        this(true);
    }

    public ClientTlsBuilder(Boolean validationEnabled) {
        this(new ClientTls(), validationEnabled);
    }

    public ClientTlsBuilder(ClientTlsFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClientTlsBuilder(ClientTlsFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClientTls(), validationEnabled);
    }

    public ClientTlsBuilder(ClientTlsFluent<?> fluent, ClientTls instance) {
        this(fluent, instance, true);
    }

    public ClientTlsBuilder(ClientTlsFluent<?> fluent, ClientTls instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withTrustedCertificates(instance.getTrustedCertificates());
        this.validationEnabled = validationEnabled;
    }

    public ClientTlsBuilder(ClientTls instance) {
        this(instance, (Boolean)true);
    }

    public ClientTlsBuilder(ClientTls instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withTrustedCertificates(instance.getTrustedCertificates());
        this.validationEnabled = validationEnabled;
    }

    public ClientTls build() {
        ClientTls buildable = new ClientTls();
        buildable.setTrustedCertificates(this.fluent.getTrustedCertificates());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClientTlsBuilder that = (ClientTlsBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

