/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.AbstractKafkaConnectSpecFluentImpl;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpec;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecBuilder;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2ClusterSpecFluentImpl;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpec;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecBuilder;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2MirrorSpecFluentImpl;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2Spec;
import io.strimzi.api.kafka.model.KafkaMirrorMaker2SpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaMirrorMaker2SpecFluentImpl<A extends KafkaMirrorMaker2SpecFluent<A>>
extends AbstractKafkaConnectSpecFluentImpl<A>
implements KafkaMirrorMaker2SpecFluent<A> {
    private List<KafkaMirrorMaker2ClusterSpecBuilder> clusters;
    private String connectCluster;
    private List<KafkaMirrorMaker2MirrorSpecBuilder> mirrors;

    public KafkaMirrorMaker2SpecFluentImpl() {
    }

    public KafkaMirrorMaker2SpecFluentImpl(KafkaMirrorMaker2Spec instance) {
        this.withClusters(instance.getClusters());
        this.withConnectCluster(instance.getConnectCluster());
        this.withMirrors(instance.getMirrors());
        this.withLogging(instance.getLogging());
        this.withReplicas(instance.getReplicas());
        this.withVersion(instance.getVersion());
        this.withImage(instance.getImage());
        this.withResources(instance.getResources());
        this.withLivenessProbe(instance.getLivenessProbe());
        this.withReadinessProbe(instance.getReadinessProbe());
        this.withJmxOptions(instance.getJmxOptions());
        this.withJvmOptions(instance.getJvmOptions());
        this.withMetricsConfig(instance.getMetricsConfig());
        this.withTracing(instance.getTracing());
        this.withTemplate(instance.getTemplate());
        this.withExternalConfiguration(instance.getExternalConfiguration());
    }

    @Override
    public A addToClusters(int index, KafkaMirrorMaker2ClusterSpec item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();
        }
        KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
        this._visitables.get((Object)"clusters").add(index >= 0 ? index : this._visitables.get((Object)"clusters").size(), builder);
        this.clusters.add(index >= 0 ? index : this.clusters.size(), builder);
        return (A)this;
    }

    @Override
    public A setToClusters(int index, KafkaMirrorMaker2ClusterSpec item) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();
        }
        KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"clusters").size()) {
            this._visitables.get((Object)"clusters").add(builder);
        } else {
            this._visitables.get((Object)"clusters").set(index, builder);
        }
        if (index < 0 || index >= this.clusters.size()) {
            this.clusters.add(builder);
        } else {
            this.clusters.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusters(KafkaMirrorMaker2ClusterSpec ... items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();
        }
        for (KafkaMirrorMaker2ClusterSpec item : items) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusters(Collection<KafkaMirrorMaker2ClusterSpec> items) {
        if (this.clusters == null) {
            this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();
        }
        for (KafkaMirrorMaker2ClusterSpec item : items) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
            this._visitables.get((Object)"clusters").add(builder);
            this.clusters.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusters(KafkaMirrorMaker2ClusterSpec ... items) {
        for (KafkaMirrorMaker2ClusterSpec item : items) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
            this._visitables.get((Object)"clusters").remove(builder);
            if (this.clusters == null) continue;
            this.clusters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusters(Collection<KafkaMirrorMaker2ClusterSpec> items) {
        for (KafkaMirrorMaker2ClusterSpec item : items) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = new KafkaMirrorMaker2ClusterSpecBuilder(item);
            this._visitables.get((Object)"clusters").remove(builder);
            if (this.clusters == null) continue;
            this.clusters.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClusters(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        if (this.clusters == null) {
            return (A)this;
        }
        Iterator<KafkaMirrorMaker2ClusterSpecBuilder> each = this.clusters.iterator();
        List visitables = this._visitables.get((Object)"clusters");
        while (each.hasNext()) {
            KafkaMirrorMaker2ClusterSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KafkaMirrorMaker2ClusterSpec> getClusters() {
        return KafkaMirrorMaker2SpecFluentImpl.build(this.clusters);
    }

    @Override
    public List<KafkaMirrorMaker2ClusterSpec> buildClusters() {
        return KafkaMirrorMaker2SpecFluentImpl.build(this.clusters);
    }

    @Override
    public KafkaMirrorMaker2ClusterSpec buildCluster(int index) {
        return this.clusters.get(index).build();
    }

    @Override
    public KafkaMirrorMaker2ClusterSpec buildFirstCluster() {
        return this.clusters.get(0).build();
    }

    @Override
    public KafkaMirrorMaker2ClusterSpec buildLastCluster() {
        return this.clusters.get(this.clusters.size() - 1).build();
    }

    @Override
    public KafkaMirrorMaker2ClusterSpec buildMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        for (KafkaMirrorMaker2ClusterSpecBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        for (KafkaMirrorMaker2ClusterSpecBuilder item : this.clusters) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusters(List<KafkaMirrorMaker2ClusterSpec> clusters) {
        if (this.clusters != null) {
            this._visitables.get((Object)"clusters").removeAll(this.clusters);
        }
        if (clusters != null) {
            this.clusters = new ArrayList<KafkaMirrorMaker2ClusterSpecBuilder>();
            for (KafkaMirrorMaker2ClusterSpec item : clusters) {
                this.addToClusters(item);
            }
        } else {
            this.clusters = null;
        }
        return (A)this;
    }

    @Override
    public A withClusters(KafkaMirrorMaker2ClusterSpec ... clusters) {
        if (this.clusters != null) {
            this.clusters.clear();
        }
        if (clusters != null) {
            for (KafkaMirrorMaker2ClusterSpec item : clusters) {
                this.addToClusters(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusters() {
        return this.clusters != null && !this.clusters.isEmpty();
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> addNewCluster() {
        return new ClustersNestedImpl();
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> addNewClusterLike(KafkaMirrorMaker2ClusterSpec item) {
        return new ClustersNestedImpl(-1, item);
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> setNewClusterLike(int index, KafkaMirrorMaker2ClusterSpec item) {
        return new ClustersNestedImpl(index, item);
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editCluster(int index) {
        if (this.clusters.size() <= index) {
            throw new RuntimeException("Can't edit clusters. Index exceeds size.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editFirstCluster() {
        if (this.clusters.size() == 0) {
            throw new RuntimeException("Can't edit first clusters. The list is empty.");
        }
        return this.setNewClusterLike(0, this.buildCluster(0));
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editLastCluster() {
        int index = this.clusters.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusters. The list is empty.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.ClustersNested<A> editMatchingCluster(Predicate<KafkaMirrorMaker2ClusterSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusters.size(); ++i) {
            if (!predicate.test(this.clusters.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusters. No match found.");
        }
        return this.setNewClusterLike(index, this.buildCluster(index));
    }

    @Override
    public String getConnectCluster() {
        return this.connectCluster;
    }

    @Override
    public A withConnectCluster(String connectCluster) {
        this.connectCluster = connectCluster;
        return (A)this;
    }

    @Override
    public Boolean hasConnectCluster() {
        return this.connectCluster != null;
    }

    @Override
    @Deprecated
    public A withNewConnectCluster(String original) {
        return this.withConnectCluster(new String(original));
    }

    @Override
    public A addToMirrors(int index, KafkaMirrorMaker2MirrorSpec item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();
        }
        KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
        this._visitables.get((Object)"mirrors").add(index >= 0 ? index : this._visitables.get((Object)"mirrors").size(), builder);
        this.mirrors.add(index >= 0 ? index : this.mirrors.size(), builder);
        return (A)this;
    }

    @Override
    public A setToMirrors(int index, KafkaMirrorMaker2MirrorSpec item) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();
        }
        KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"mirrors").size()) {
            this._visitables.get((Object)"mirrors").add(builder);
        } else {
            this._visitables.get((Object)"mirrors").set(index, builder);
        }
        if (index < 0 || index >= this.mirrors.size()) {
            this.mirrors.add(builder);
        } else {
            this.mirrors.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMirrors(KafkaMirrorMaker2MirrorSpec ... items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();
        }
        for (KafkaMirrorMaker2MirrorSpec item : items) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items) {
        if (this.mirrors == null) {
            this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();
        }
        for (KafkaMirrorMaker2MirrorSpec item : items) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
            this._visitables.get((Object)"mirrors").add(builder);
            this.mirrors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMirrors(KafkaMirrorMaker2MirrorSpec ... items) {
        for (KafkaMirrorMaker2MirrorSpec item : items) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
            this._visitables.get((Object)"mirrors").remove(builder);
            if (this.mirrors == null) continue;
            this.mirrors.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMirrors(Collection<KafkaMirrorMaker2MirrorSpec> items) {
        for (KafkaMirrorMaker2MirrorSpec item : items) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = new KafkaMirrorMaker2MirrorSpecBuilder(item);
            this._visitables.get((Object)"mirrors").remove(builder);
            if (this.mirrors == null) continue;
            this.mirrors.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMirrors(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        if (this.mirrors == null) {
            return (A)this;
        }
        Iterator<KafkaMirrorMaker2MirrorSpecBuilder> each = this.mirrors.iterator();
        List visitables = this._visitables.get((Object)"mirrors");
        while (each.hasNext()) {
            KafkaMirrorMaker2MirrorSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<KafkaMirrorMaker2MirrorSpec> getMirrors() {
        return KafkaMirrorMaker2SpecFluentImpl.build(this.mirrors);
    }

    @Override
    public List<KafkaMirrorMaker2MirrorSpec> buildMirrors() {
        return KafkaMirrorMaker2SpecFluentImpl.build(this.mirrors);
    }

    @Override
    public KafkaMirrorMaker2MirrorSpec buildMirror(int index) {
        return this.mirrors.get(index).build();
    }

    @Override
    public KafkaMirrorMaker2MirrorSpec buildFirstMirror() {
        return this.mirrors.get(0).build();
    }

    @Override
    public KafkaMirrorMaker2MirrorSpec buildLastMirror() {
        return this.mirrors.get(this.mirrors.size() - 1).build();
    }

    @Override
    public KafkaMirrorMaker2MirrorSpec buildMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        for (KafkaMirrorMaker2MirrorSpecBuilder item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        for (KafkaMirrorMaker2MirrorSpecBuilder item : this.mirrors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMirrors(List<KafkaMirrorMaker2MirrorSpec> mirrors) {
        if (this.mirrors != null) {
            this._visitables.get((Object)"mirrors").removeAll(this.mirrors);
        }
        if (mirrors != null) {
            this.mirrors = new ArrayList<KafkaMirrorMaker2MirrorSpecBuilder>();
            for (KafkaMirrorMaker2MirrorSpec item : mirrors) {
                this.addToMirrors(item);
            }
        } else {
            this.mirrors = null;
        }
        return (A)this;
    }

    @Override
    public A withMirrors(KafkaMirrorMaker2MirrorSpec ... mirrors) {
        if (this.mirrors != null) {
            this.mirrors.clear();
        }
        if (mirrors != null) {
            for (KafkaMirrorMaker2MirrorSpec item : mirrors) {
                this.addToMirrors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMirrors() {
        return this.mirrors != null && !this.mirrors.isEmpty();
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> addNewMirror() {
        return new MirrorsNestedImpl();
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> addNewMirrorLike(KafkaMirrorMaker2MirrorSpec item) {
        return new MirrorsNestedImpl(-1, item);
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> setNewMirrorLike(int index, KafkaMirrorMaker2MirrorSpec item) {
        return new MirrorsNestedImpl(index, item);
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editMirror(int index) {
        if (this.mirrors.size() <= index) {
            throw new RuntimeException("Can't edit mirrors. Index exceeds size.");
        }
        return this.setNewMirrorLike(index, this.buildMirror(index));
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editFirstMirror() {
        if (this.mirrors.size() == 0) {
            throw new RuntimeException("Can't edit first mirrors. The list is empty.");
        }
        return this.setNewMirrorLike(0, this.buildMirror(0));
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editLastMirror() {
        int index = this.mirrors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last mirrors. The list is empty.");
        }
        return this.setNewMirrorLike(index, this.buildMirror(index));
    }

    @Override
    public KafkaMirrorMaker2SpecFluent.MirrorsNested<A> editMatchingMirror(Predicate<KafkaMirrorMaker2MirrorSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mirrors.size(); ++i) {
            if (!predicate.test(this.mirrors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching mirrors. No match found.");
        }
        return this.setNewMirrorLike(index, this.buildMirror(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaMirrorMaker2SpecFluentImpl that = (KafkaMirrorMaker2SpecFluentImpl)o;
        if (this.clusters != null ? !this.clusters.equals(that.clusters) : that.clusters != null) {
            return false;
        }
        if (this.connectCluster != null ? !this.connectCluster.equals(that.connectCluster) : that.connectCluster != null) {
            return false;
        }
        return !(this.mirrors != null ? !this.mirrors.equals(that.mirrors) : that.mirrors != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusters, this.connectCluster, this.mirrors, super.hashCode());
    }

    public class MirrorsNestedImpl<N>
    extends KafkaMirrorMaker2MirrorSpecFluentImpl<KafkaMirrorMaker2SpecFluent.MirrorsNested<N>>
    implements KafkaMirrorMaker2SpecFluent.MirrorsNested<N>,
    Nested<N> {
        private final KafkaMirrorMaker2MirrorSpecBuilder builder;
        private final int index;

        MirrorsNestedImpl(int index, KafkaMirrorMaker2MirrorSpec item) {
            this.index = index;
            this.builder = new KafkaMirrorMaker2MirrorSpecBuilder(this, item);
        }

        MirrorsNestedImpl() {
            this.index = -1;
            this.builder = new KafkaMirrorMaker2MirrorSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaMirrorMaker2SpecFluentImpl.this.setToMirrors(this.index, this.builder.build());
        }

        @Override
        public N endMirror() {
            return this.and();
        }
    }

    public class ClustersNestedImpl<N>
    extends KafkaMirrorMaker2ClusterSpecFluentImpl<KafkaMirrorMaker2SpecFluent.ClustersNested<N>>
    implements KafkaMirrorMaker2SpecFluent.ClustersNested<N>,
    Nested<N> {
        private final KafkaMirrorMaker2ClusterSpecBuilder builder;
        private final int index;

        ClustersNestedImpl(int index, KafkaMirrorMaker2ClusterSpec item) {
            this.index = index;
            this.builder = new KafkaMirrorMaker2ClusterSpecBuilder(this, item);
        }

        ClustersNestedImpl() {
            this.index = -1;
            this.builder = new KafkaMirrorMaker2ClusterSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaMirrorMaker2SpecFluentImpl.this.setToClusters(this.index, this.builder.build());
        }

        @Override
        public N endCluster() {
            return this.and();
        }
    }
}

