/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.kafka.model.Spec;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"goals", "skipHardGoalCheck", "rebalanceDisk", "excludedTopics", "concurrentPartitionMovementsPerBroker", "concurrentIntraBrokerPartitionMovements", "concurrentLeaderMovements", "replicationThrottle", "replicaMovementStrategies"})
public class KafkaRebalanceSpec
extends Spec {
    private static final long serialVersionUID = 1L;
    private List<String> goals;
    private boolean skipHardGoalCheck;
    private boolean rebalanceDisk;
    private String excludedTopics;
    private int concurrentPartitionMovementsPerBroker;
    private int concurrentIntraBrokerPartitionMovements;
    private int concurrentLeaderMovements;
    private long replicationThrottle;
    private List<String> replicaMovementStrategies;

    @Description(value="A list of goals, ordered by decreasing priority, to use for generating and executing the rebalance proposal. The supported goals are available at https://github.com/linkedin/cruise-control#goals. If an empty goals list is provided, the goals declared in the default.goals Cruise Control configuration parameter are used.")
    public List<String> getGoals() {
        return this.goals;
    }

    public void setGoals(List<String> goals) {
        this.goals = goals;
    }

    @Description(value="Whether to allow the hard goals specified in the Kafka CR to be skipped in optimization proposal generation. This can be useful when some of those hard goals are preventing a balance solution being found. Default is false.")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public boolean isSkipHardGoalCheck() {
        return this.skipHardGoalCheck;
    }

    public void setSkipHardGoalCheck(boolean skipHardGoalCheck) {
        this.skipHardGoalCheck = skipHardGoalCheck;
    }

    @Description(value="Enables intra-broker disk balancing, which balances disk space utilization between disks on the same broker. Only applies to Kafka deployments that use JBOD storage with multiple disks. When enabled, inter-broker balancing is disabled. Default is false.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public boolean isRebalanceDisk() {
        return this.rebalanceDisk;
    }

    public void setRebalanceDisk(boolean rebalanceDisk) {
        this.rebalanceDisk = rebalanceDisk;
    }

    @Description(value="A regular expression where any matching topics will be excluded from the calculation of optimization proposals. This expression will be parsed by the java.util.regex.Pattern class; for more information on the supported format consult the documentation for that class.")
    public String getExcludedTopics() {
        return this.excludedTopics;
    }

    public void setExcludedTopics(String excludedTopics) {
        this.excludedTopics = excludedTopics;
    }

    @Description(value="The upper bound of ongoing partition replica movements going into/out of each broker. Default is 5.")
    @Minimum(value=0)
    public int getConcurrentPartitionMovementsPerBroker() {
        return this.concurrentPartitionMovementsPerBroker;
    }

    public void setConcurrentPartitionMovementsPerBroker(int movements) {
        this.concurrentPartitionMovementsPerBroker = movements;
    }

    @Description(value="The upper bound of ongoing partition replica movements between disks within each broker. Default is 2.")
    @Minimum(value=0)
    public int getConcurrentIntraBrokerPartitionMovements() {
        return this.concurrentIntraBrokerPartitionMovements;
    }

    public void setConcurrentIntraBrokerPartitionMovements(int movements) {
        this.concurrentIntraBrokerPartitionMovements = movements;
    }

    @Description(value="The upper bound of ongoing partition leadership movements. Default is 1000.")
    @Minimum(value=0)
    public int getConcurrentLeaderMovements() {
        return this.concurrentLeaderMovements;
    }

    public void setConcurrentLeaderMovements(int movements) {
        this.concurrentLeaderMovements = movements;
    }

    @Description(value="The upper bound, in bytes per second, on the bandwidth used to move replicas. There is no limit by default.")
    @Minimum(value=0)
    public long getReplicationThrottle() {
        return this.replicationThrottle;
    }

    public void setReplicationThrottle(long bandwidth) {
        this.replicationThrottle = bandwidth;
    }

    @Description(value="A list of strategy class names used to determine the execution order for the replica movements in the generated optimization proposal. By default BaseReplicaMovementStrategy is used, which will execute the replica movements in the order that they were generated.")
    public List<String> getReplicaMovementStrategies() {
        return this.replicaMovementStrategies;
    }

    public void setReplicaMovementStrategies(List<String> replicaMovementStrategies) {
        this.replicaMovementStrategies = replicaMovementStrategies;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaRebalanceSpec)) {
            return false;
        }
        KafkaRebalanceSpec other = (KafkaRebalanceSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$goals = this.getGoals();
        List<String> other$goals = other.getGoals();
        if (this$goals == null ? other$goals != null : !((Object)this$goals).equals(other$goals)) {
            return false;
        }
        if (this.isSkipHardGoalCheck() != other.isSkipHardGoalCheck()) {
            return false;
        }
        if (this.isRebalanceDisk() != other.isRebalanceDisk()) {
            return false;
        }
        String this$excludedTopics = this.getExcludedTopics();
        String other$excludedTopics = other.getExcludedTopics();
        if (this$excludedTopics == null ? other$excludedTopics != null : !this$excludedTopics.equals(other$excludedTopics)) {
            return false;
        }
        if (this.getConcurrentPartitionMovementsPerBroker() != other.getConcurrentPartitionMovementsPerBroker()) {
            return false;
        }
        if (this.getConcurrentIntraBrokerPartitionMovements() != other.getConcurrentIntraBrokerPartitionMovements()) {
            return false;
        }
        if (this.getConcurrentLeaderMovements() != other.getConcurrentLeaderMovements()) {
            return false;
        }
        if (this.getReplicationThrottle() != other.getReplicationThrottle()) {
            return false;
        }
        List<String> this$replicaMovementStrategies = this.getReplicaMovementStrategies();
        List<String> other$replicaMovementStrategies = other.getReplicaMovementStrategies();
        return !(this$replicaMovementStrategies == null ? other$replicaMovementStrategies != null : !((Object)this$replicaMovementStrategies).equals(other$replicaMovementStrategies));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof KafkaRebalanceSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $goals = this.getGoals();
        result = result * 59 + ($goals == null ? 43 : ((Object)$goals).hashCode());
        result = result * 59 + (this.isSkipHardGoalCheck() ? 79 : 97);
        result = result * 59 + (this.isRebalanceDisk() ? 79 : 97);
        String $excludedTopics = this.getExcludedTopics();
        result = result * 59 + ($excludedTopics == null ? 43 : $excludedTopics.hashCode());
        result = result * 59 + this.getConcurrentPartitionMovementsPerBroker();
        result = result * 59 + this.getConcurrentIntraBrokerPartitionMovements();
        result = result * 59 + this.getConcurrentLeaderMovements();
        long $replicationThrottle = this.getReplicationThrottle();
        result = result * 59 + (int)($replicationThrottle >>> 32 ^ $replicationThrottle);
        List<String> $replicaMovementStrategies = this.getReplicaMovementStrategies();
        result = result * 59 + ($replicaMovementStrategies == null ? 43 : ((Object)$replicaMovementStrategies).hashCode());
        return result;
    }
}

