/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import io.strimzi.api.kafka.model.KafkaRebalanceSpec;
import io.strimzi.api.kafka.model.KafkaRebalanceSpecFluent;
import io.strimzi.api.kafka.model.SpecFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaRebalanceSpecFluentImpl<A extends KafkaRebalanceSpecFluent<A>>
extends SpecFluentImpl<A>
implements KafkaRebalanceSpecFluent<A> {
    private List<String> goals;
    private boolean skipHardGoalCheck;
    private boolean rebalanceDisk;
    private String excludedTopics;
    private int concurrentPartitionMovementsPerBroker;
    private int concurrentIntraBrokerPartitionMovements;
    private int concurrentLeaderMovements;
    private long replicationThrottle;
    private List<String> replicaMovementStrategies;

    public KafkaRebalanceSpecFluentImpl() {
    }

    public KafkaRebalanceSpecFluentImpl(KafkaRebalanceSpec instance) {
        this.withGoals(instance.getGoals());
        this.withSkipHardGoalCheck(instance.isSkipHardGoalCheck());
        this.withRebalanceDisk(instance.isRebalanceDisk());
        this.withExcludedTopics(instance.getExcludedTopics());
        this.withConcurrentPartitionMovementsPerBroker(instance.getConcurrentPartitionMovementsPerBroker());
        this.withConcurrentIntraBrokerPartitionMovements(instance.getConcurrentIntraBrokerPartitionMovements());
        this.withConcurrentLeaderMovements(instance.getConcurrentLeaderMovements());
        this.withReplicationThrottle(instance.getReplicationThrottle());
        this.withReplicaMovementStrategies(instance.getReplicaMovementStrategies());
    }

    @Override
    public A addToGoals(int index, String item) {
        if (this.goals == null) {
            this.goals = new ArrayList<String>();
        }
        this.goals.add(index, item);
        return (A)this;
    }

    @Override
    public A setToGoals(int index, String item) {
        if (this.goals == null) {
            this.goals = new ArrayList<String>();
        }
        this.goals.set(index, item);
        return (A)this;
    }

    @Override
    public A addToGoals(String ... items) {
        if (this.goals == null) {
            this.goals = new ArrayList<String>();
        }
        for (String item : items) {
            this.goals.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToGoals(Collection<String> items) {
        if (this.goals == null) {
            this.goals = new ArrayList<String>();
        }
        for (String item : items) {
            this.goals.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromGoals(String ... items) {
        for (String item : items) {
            if (this.goals == null) continue;
            this.goals.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromGoals(Collection<String> items) {
        for (String item : items) {
            if (this.goals == null) continue;
            this.goals.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getGoals() {
        return this.goals;
    }

    @Override
    public String getGoal(int index) {
        return this.goals.get(index);
    }

    @Override
    public String getFirstGoal() {
        return this.goals.get(0);
    }

    @Override
    public String getLastGoal() {
        return this.goals.get(this.goals.size() - 1);
    }

    @Override
    public String getMatchingGoal(Predicate<String> predicate) {
        for (String item : this.goals) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingGoal(Predicate<String> predicate) {
        for (String item : this.goals) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withGoals(List<String> goals) {
        if (this.goals != null) {
            this._visitables.get((Object)"goals").removeAll(this.goals);
        }
        if (goals != null) {
            this.goals = new ArrayList<String>();
            for (String item : goals) {
                this.addToGoals(item);
            }
        } else {
            this.goals = null;
        }
        return (A)this;
    }

    @Override
    public A withGoals(String ... goals) {
        if (this.goals != null) {
            this.goals.clear();
        }
        if (goals != null) {
            for (String item : goals) {
                this.addToGoals(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasGoals() {
        return this.goals != null && !this.goals.isEmpty();
    }

    @Override
    public A addNewGoal(String original) {
        return this.addToGoals(new String(original));
    }

    @Override
    public boolean isSkipHardGoalCheck() {
        return this.skipHardGoalCheck;
    }

    @Override
    public A withSkipHardGoalCheck(boolean skipHardGoalCheck) {
        this.skipHardGoalCheck = skipHardGoalCheck;
        return (A)this;
    }

    @Override
    public Boolean hasSkipHardGoalCheck() {
        return true;
    }

    @Override
    public boolean isRebalanceDisk() {
        return this.rebalanceDisk;
    }

    @Override
    public A withRebalanceDisk(boolean rebalanceDisk) {
        this.rebalanceDisk = rebalanceDisk;
        return (A)this;
    }

    @Override
    public Boolean hasRebalanceDisk() {
        return true;
    }

    @Override
    public String getExcludedTopics() {
        return this.excludedTopics;
    }

    @Override
    public A withExcludedTopics(String excludedTopics) {
        this.excludedTopics = excludedTopics;
        return (A)this;
    }

    @Override
    public Boolean hasExcludedTopics() {
        return this.excludedTopics != null;
    }

    @Override
    @Deprecated
    public A withNewExcludedTopics(String original) {
        return this.withExcludedTopics(new String(original));
    }

    @Override
    public int getConcurrentPartitionMovementsPerBroker() {
        return this.concurrentPartitionMovementsPerBroker;
    }

    @Override
    public A withConcurrentPartitionMovementsPerBroker(int concurrentPartitionMovementsPerBroker) {
        this.concurrentPartitionMovementsPerBroker = concurrentPartitionMovementsPerBroker;
        return (A)this;
    }

    @Override
    public Boolean hasConcurrentPartitionMovementsPerBroker() {
        return true;
    }

    @Override
    public int getConcurrentIntraBrokerPartitionMovements() {
        return this.concurrentIntraBrokerPartitionMovements;
    }

    @Override
    public A withConcurrentIntraBrokerPartitionMovements(int concurrentIntraBrokerPartitionMovements) {
        this.concurrentIntraBrokerPartitionMovements = concurrentIntraBrokerPartitionMovements;
        return (A)this;
    }

    @Override
    public Boolean hasConcurrentIntraBrokerPartitionMovements() {
        return true;
    }

    @Override
    public int getConcurrentLeaderMovements() {
        return this.concurrentLeaderMovements;
    }

    @Override
    public A withConcurrentLeaderMovements(int concurrentLeaderMovements) {
        this.concurrentLeaderMovements = concurrentLeaderMovements;
        return (A)this;
    }

    @Override
    public Boolean hasConcurrentLeaderMovements() {
        return true;
    }

    @Override
    public long getReplicationThrottle() {
        return this.replicationThrottle;
    }

    @Override
    public A withReplicationThrottle(long replicationThrottle) {
        this.replicationThrottle = replicationThrottle;
        return (A)this;
    }

    @Override
    public Boolean hasReplicationThrottle() {
        return true;
    }

    @Override
    public A addToReplicaMovementStrategies(int index, String item) {
        if (this.replicaMovementStrategies == null) {
            this.replicaMovementStrategies = new ArrayList<String>();
        }
        this.replicaMovementStrategies.add(index, item);
        return (A)this;
    }

    @Override
    public A setToReplicaMovementStrategies(int index, String item) {
        if (this.replicaMovementStrategies == null) {
            this.replicaMovementStrategies = new ArrayList<String>();
        }
        this.replicaMovementStrategies.set(index, item);
        return (A)this;
    }

    @Override
    public A addToReplicaMovementStrategies(String ... items) {
        if (this.replicaMovementStrategies == null) {
            this.replicaMovementStrategies = new ArrayList<String>();
        }
        for (String item : items) {
            this.replicaMovementStrategies.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToReplicaMovementStrategies(Collection<String> items) {
        if (this.replicaMovementStrategies == null) {
            this.replicaMovementStrategies = new ArrayList<String>();
        }
        for (String item : items) {
            this.replicaMovementStrategies.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromReplicaMovementStrategies(String ... items) {
        for (String item : items) {
            if (this.replicaMovementStrategies == null) continue;
            this.replicaMovementStrategies.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromReplicaMovementStrategies(Collection<String> items) {
        for (String item : items) {
            if (this.replicaMovementStrategies == null) continue;
            this.replicaMovementStrategies.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getReplicaMovementStrategies() {
        return this.replicaMovementStrategies;
    }

    @Override
    public String getReplicaMovementStrategy(int index) {
        return this.replicaMovementStrategies.get(index);
    }

    @Override
    public String getFirstReplicaMovementStrategy() {
        return this.replicaMovementStrategies.get(0);
    }

    @Override
    public String getLastReplicaMovementStrategy() {
        return this.replicaMovementStrategies.get(this.replicaMovementStrategies.size() - 1);
    }

    @Override
    public String getMatchingReplicaMovementStrategy(Predicate<String> predicate) {
        for (String item : this.replicaMovementStrategies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingReplicaMovementStrategy(Predicate<String> predicate) {
        for (String item : this.replicaMovementStrategies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withReplicaMovementStrategies(List<String> replicaMovementStrategies) {
        if (this.replicaMovementStrategies != null) {
            this._visitables.get((Object)"replicaMovementStrategies").removeAll(this.replicaMovementStrategies);
        }
        if (replicaMovementStrategies != null) {
            this.replicaMovementStrategies = new ArrayList<String>();
            for (String item : replicaMovementStrategies) {
                this.addToReplicaMovementStrategies(item);
            }
        } else {
            this.replicaMovementStrategies = null;
        }
        return (A)this;
    }

    @Override
    public A withReplicaMovementStrategies(String ... replicaMovementStrategies) {
        if (this.replicaMovementStrategies != null) {
            this.replicaMovementStrategies.clear();
        }
        if (replicaMovementStrategies != null) {
            for (String item : replicaMovementStrategies) {
                this.addToReplicaMovementStrategies(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasReplicaMovementStrategies() {
        return this.replicaMovementStrategies != null && !this.replicaMovementStrategies.isEmpty();
    }

    @Override
    public A addNewReplicaMovementStrategy(String original) {
        return this.addToReplicaMovementStrategies(new String(original));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaRebalanceSpecFluentImpl that = (KafkaRebalanceSpecFluentImpl)o;
        if (this.goals != null ? !this.goals.equals(that.goals) : that.goals != null) {
            return false;
        }
        if (this.skipHardGoalCheck != that.skipHardGoalCheck) {
            return false;
        }
        if (this.rebalanceDisk != that.rebalanceDisk) {
            return false;
        }
        if (this.excludedTopics != null ? !this.excludedTopics.equals(that.excludedTopics) : that.excludedTopics != null) {
            return false;
        }
        if (this.concurrentPartitionMovementsPerBroker != that.concurrentPartitionMovementsPerBroker) {
            return false;
        }
        if (this.concurrentIntraBrokerPartitionMovements != that.concurrentIntraBrokerPartitionMovements) {
            return false;
        }
        if (this.concurrentLeaderMovements != that.concurrentLeaderMovements) {
            return false;
        }
        if (this.replicationThrottle != that.replicationThrottle) {
            return false;
        }
        return !(this.replicaMovementStrategies != null ? !this.replicaMovementStrategies.equals(that.replicaMovementStrategies) : that.replicaMovementStrategies != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.goals, this.skipHardGoalCheck, this.rebalanceDisk, this.excludedTopics, this.concurrentPartitionMovementsPerBroker, this.concurrentIntraBrokerPartitionMovements, this.concurrentLeaderMovements, this.replicationThrottle, this.replicaMovementStrategies, super.hashCode());
    }
}

