/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.CertSecretSource;
import io.strimzi.api.kafka.model.CertSecretSourceBuilder;
import io.strimzi.api.kafka.model.CertSecretSourceFluentImpl;
import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuth;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationOAuthFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaClientAuthenticationOAuthFluentImpl<A extends KafkaClientAuthenticationOAuthFluent<A>>
extends BaseFluent<A>
implements KafkaClientAuthenticationOAuthFluent<A> {
    private String clientId;
    private String scope;
    private String audience;
    private String tokenEndpointUri;
    private Integer connectTimeoutSeconds;
    private Integer readTimeoutSeconds;
    private GenericSecretSourceBuilder clientSecret;
    private GenericSecretSourceBuilder accessToken;
    private GenericSecretSourceBuilder refreshToken;
    private List<CertSecretSourceBuilder> tlsTrustedCertificates;
    private boolean disableTlsHostnameVerification;
    private int maxTokenExpirySeconds;
    private boolean accessTokenIsJwt;

    public KafkaClientAuthenticationOAuthFluentImpl() {
    }

    public KafkaClientAuthenticationOAuthFluentImpl(KafkaClientAuthenticationOAuth instance) {
        this.withClientId(instance.getClientId());
        this.withScope(instance.getScope());
        this.withAudience(instance.getAudience());
        this.withTokenEndpointUri(instance.getTokenEndpointUri());
        this.withConnectTimeoutSeconds(instance.getConnectTimeoutSeconds());
        this.withReadTimeoutSeconds(instance.getReadTimeoutSeconds());
        this.withClientSecret(instance.getClientSecret());
        this.withAccessToken(instance.getAccessToken());
        this.withRefreshToken(instance.getRefreshToken());
        this.withTlsTrustedCertificates(instance.getTlsTrustedCertificates());
        this.withDisableTlsHostnameVerification(instance.isDisableTlsHostnameVerification());
        this.withMaxTokenExpirySeconds(instance.getMaxTokenExpirySeconds());
        this.withAccessTokenIsJwt(instance.isAccessTokenIsJwt());
    }

    @Override
    public String getClientId() {
        return this.clientId;
    }

    @Override
    public A withClientId(String clientId) {
        this.clientId = clientId;
        return (A)this;
    }

    @Override
    public Boolean hasClientId() {
        return this.clientId != null;
    }

    @Override
    @Deprecated
    public A withNewClientId(String original) {
        return this.withClientId(new String(original));
    }

    @Override
    public String getScope() {
        return this.scope;
    }

    @Override
    public A withScope(String scope) {
        this.scope = scope;
        return (A)this;
    }

    @Override
    public Boolean hasScope() {
        return this.scope != null;
    }

    @Override
    @Deprecated
    public A withNewScope(String original) {
        return this.withScope(new String(original));
    }

    @Override
    public String getAudience() {
        return this.audience;
    }

    @Override
    public A withAudience(String audience) {
        this.audience = audience;
        return (A)this;
    }

    @Override
    public Boolean hasAudience() {
        return this.audience != null;
    }

    @Override
    @Deprecated
    public A withNewAudience(String original) {
        return this.withAudience(new String(original));
    }

    @Override
    public String getTokenEndpointUri() {
        return this.tokenEndpointUri;
    }

    @Override
    public A withTokenEndpointUri(String tokenEndpointUri) {
        this.tokenEndpointUri = tokenEndpointUri;
        return (A)this;
    }

    @Override
    public Boolean hasTokenEndpointUri() {
        return this.tokenEndpointUri != null;
    }

    @Override
    @Deprecated
    public A withNewTokenEndpointUri(String original) {
        return this.withTokenEndpointUri(new String(original));
    }

    @Override
    public Integer getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    @Override
    public A withConnectTimeoutSeconds(Integer connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds != null;
    }

    @Override
    public Integer getReadTimeoutSeconds() {
        return this.readTimeoutSeconds;
    }

    @Override
    public A withReadTimeoutSeconds(Integer readTimeoutSeconds) {
        this.readTimeoutSeconds = readTimeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasReadTimeoutSeconds() {
        return this.readTimeoutSeconds != null;
    }

    @Override
    @Deprecated
    public GenericSecretSource getClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public GenericSecretSource buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public A withClientSecret(GenericSecretSource clientSecret) {
        this._visitables.get((Object)"clientSecret").remove(this.clientSecret);
        if (clientSecret != null) {
            this.clientSecret = new GenericSecretSourceBuilder(clientSecret);
            this._visitables.get((Object)"clientSecret").add(this.clientSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> withNewClientSecretLike(GenericSecretSource item) {
        return new ClientSecretNestedImpl(item);
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret());
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : new GenericSecretSourceBuilder().build());
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.ClientSecretNested<A> editOrNewClientSecretLike(GenericSecretSource item) {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : item);
    }

    @Override
    @Deprecated
    public GenericSecretSource getAccessToken() {
        return this.accessToken != null ? this.accessToken.build() : null;
    }

    @Override
    public GenericSecretSource buildAccessToken() {
        return this.accessToken != null ? this.accessToken.build() : null;
    }

    @Override
    public A withAccessToken(GenericSecretSource accessToken) {
        this._visitables.get((Object)"accessToken").remove(this.accessToken);
        if (accessToken != null) {
            this.accessToken = new GenericSecretSourceBuilder(accessToken);
            this._visitables.get((Object)"accessToken").add(this.accessToken);
        }
        return (A)this;
    }

    @Override
    public Boolean hasAccessToken() {
        return this.accessToken != null;
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessToken() {
        return new AccessTokenNestedImpl();
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> withNewAccessTokenLike(GenericSecretSource item) {
        return new AccessTokenNestedImpl(item);
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editAccessToken() {
        return this.withNewAccessTokenLike(this.getAccessToken());
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessToken() {
        return this.withNewAccessTokenLike(this.getAccessToken() != null ? this.getAccessToken() : new GenericSecretSourceBuilder().build());
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.AccessTokenNested<A> editOrNewAccessTokenLike(GenericSecretSource item) {
        return this.withNewAccessTokenLike(this.getAccessToken() != null ? this.getAccessToken() : item);
    }

    @Override
    @Deprecated
    public GenericSecretSource getRefreshToken() {
        return this.refreshToken != null ? this.refreshToken.build() : null;
    }

    @Override
    public GenericSecretSource buildRefreshToken() {
        return this.refreshToken != null ? this.refreshToken.build() : null;
    }

    @Override
    public A withRefreshToken(GenericSecretSource refreshToken) {
        this._visitables.get((Object)"refreshToken").remove(this.refreshToken);
        if (refreshToken != null) {
            this.refreshToken = new GenericSecretSourceBuilder(refreshToken);
            this._visitables.get((Object)"refreshToken").add(this.refreshToken);
        }
        return (A)this;
    }

    @Override
    public Boolean hasRefreshToken() {
        return this.refreshToken != null;
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshToken() {
        return new RefreshTokenNestedImpl();
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> withNewRefreshTokenLike(GenericSecretSource item) {
        return new RefreshTokenNestedImpl(item);
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editRefreshToken() {
        return this.withNewRefreshTokenLike(this.getRefreshToken());
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshToken() {
        return this.withNewRefreshTokenLike(this.getRefreshToken() != null ? this.getRefreshToken() : new GenericSecretSourceBuilder().build());
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<A> editOrNewRefreshTokenLike(GenericSecretSource item) {
        return this.withNewRefreshTokenLike(this.getRefreshToken() != null ? this.getRefreshToken() : item);
    }

    @Override
    public A addToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        this._visitables.get((Object)"tlsTrustedCertificates").add(index >= 0 ? index : this._visitables.get((Object)"tlsTrustedCertificates").size(), builder);
        this.tlsTrustedCertificates.add(index >= 0 ? index : this.tlsTrustedCertificates.size(), builder);
        return (A)this;
    }

    @Override
    public A setToTlsTrustedCertificates(int index, CertSecretSource item) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"tlsTrustedCertificates").size()) {
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
        } else {
            this._visitables.get((Object)"tlsTrustedCertificates").set(index, builder);
        }
        if (index < 0 || index >= this.tlsTrustedCertificates.size()) {
            this.tlsTrustedCertificates.add(builder);
        } else {
            this.tlsTrustedCertificates.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToTlsTrustedCertificates(CertSecretSource ... items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToTlsTrustedCertificates(Collection<CertSecretSource> items) {
        if (this.tlsTrustedCertificates == null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
        }
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").add(builder);
            this.tlsTrustedCertificates.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromTlsTrustedCertificates(CertSecretSource ... items) {
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove(builder);
            if (this.tlsTrustedCertificates == null) continue;
            this.tlsTrustedCertificates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromTlsTrustedCertificates(Collection<CertSecretSource> items) {
        for (CertSecretSource item : items) {
            CertSecretSourceBuilder builder = new CertSecretSourceBuilder(item);
            this._visitables.get((Object)"tlsTrustedCertificates").remove(builder);
            if (this.tlsTrustedCertificates == null) continue;
            this.tlsTrustedCertificates.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromTlsTrustedCertificates(Predicate<CertSecretSourceBuilder> predicate) {
        if (this.tlsTrustedCertificates == null) {
            return (A)this;
        }
        Iterator<CertSecretSourceBuilder> each = this.tlsTrustedCertificates.iterator();
        List visitables = this._visitables.get((Object)"tlsTrustedCertificates");
        while (each.hasNext()) {
            CertSecretSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<CertSecretSource> getTlsTrustedCertificates() {
        return KafkaClientAuthenticationOAuthFluentImpl.build(this.tlsTrustedCertificates);
    }

    @Override
    public List<CertSecretSource> buildTlsTrustedCertificates() {
        return KafkaClientAuthenticationOAuthFluentImpl.build(this.tlsTrustedCertificates);
    }

    @Override
    public CertSecretSource buildTlsTrustedCertificate(int index) {
        return this.tlsTrustedCertificates.get(index).build();
    }

    @Override
    public CertSecretSource buildFirstTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(0).build();
    }

    @Override
    public CertSecretSource buildLastTlsTrustedCertificate() {
        return this.tlsTrustedCertificates.get(this.tlsTrustedCertificates.size() - 1).build();
    }

    @Override
    public CertSecretSource buildMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        for (CertSecretSourceBuilder item : this.tlsTrustedCertificates) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withTlsTrustedCertificates(List<CertSecretSource> tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this._visitables.get((Object)"tlsTrustedCertificates").removeAll(this.tlsTrustedCertificates);
        }
        if (tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates = new ArrayList<CertSecretSourceBuilder>();
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        } else {
            this.tlsTrustedCertificates = null;
        }
        return (A)this;
    }

    @Override
    public A withTlsTrustedCertificates(CertSecretSource ... tlsTrustedCertificates) {
        if (this.tlsTrustedCertificates != null) {
            this.tlsTrustedCertificates.clear();
        }
        if (tlsTrustedCertificates != null) {
            for (CertSecretSource item : tlsTrustedCertificates) {
                this.addToTlsTrustedCertificates(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasTlsTrustedCertificates() {
        return this.tlsTrustedCertificates != null && !this.tlsTrustedCertificates.isEmpty();
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificate() {
        return new TlsTrustedCertificatesNestedImpl();
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> addNewTlsTrustedCertificateLike(CertSecretSource item) {
        return new TlsTrustedCertificatesNestedImpl(-1, item);
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> setNewTlsTrustedCertificateLike(int index, CertSecretSource item) {
        return new TlsTrustedCertificatesNestedImpl(index, item);
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editTlsTrustedCertificate(int index) {
        if (this.tlsTrustedCertificates.size() <= index) {
            throw new RuntimeException("Can't edit tlsTrustedCertificates. Index exceeds size.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editFirstTlsTrustedCertificate() {
        if (this.tlsTrustedCertificates.size() == 0) {
            throw new RuntimeException("Can't edit first tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(0, this.buildTlsTrustedCertificate(0));
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editLastTlsTrustedCertificate() {
        int index = this.tlsTrustedCertificates.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last tlsTrustedCertificates. The list is empty.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    @Override
    public KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<A> editMatchingTlsTrustedCertificate(Predicate<CertSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.tlsTrustedCertificates.size(); ++i) {
            if (!predicate.test(this.tlsTrustedCertificates.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching tlsTrustedCertificates. No match found.");
        }
        return this.setNewTlsTrustedCertificateLike(index, this.buildTlsTrustedCertificate(index));
    }

    @Override
    public boolean isDisableTlsHostnameVerification() {
        return this.disableTlsHostnameVerification;
    }

    @Override
    public A withDisableTlsHostnameVerification(boolean disableTlsHostnameVerification) {
        this.disableTlsHostnameVerification = disableTlsHostnameVerification;
        return (A)this;
    }

    @Override
    public Boolean hasDisableTlsHostnameVerification() {
        return true;
    }

    @Override
    public int getMaxTokenExpirySeconds() {
        return this.maxTokenExpirySeconds;
    }

    @Override
    public A withMaxTokenExpirySeconds(int maxTokenExpirySeconds) {
        this.maxTokenExpirySeconds = maxTokenExpirySeconds;
        return (A)this;
    }

    @Override
    public Boolean hasMaxTokenExpirySeconds() {
        return true;
    }

    @Override
    public boolean isAccessTokenIsJwt() {
        return this.accessTokenIsJwt;
    }

    @Override
    public A withAccessTokenIsJwt(boolean accessTokenIsJwt) {
        this.accessTokenIsJwt = accessTokenIsJwt;
        return (A)this;
    }

    @Override
    public Boolean hasAccessTokenIsJwt() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaClientAuthenticationOAuthFluentImpl that = (KafkaClientAuthenticationOAuthFluentImpl)o;
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        if (this.scope != null ? !this.scope.equals(that.scope) : that.scope != null) {
            return false;
        }
        if (this.audience != null ? !this.audience.equals(that.audience) : that.audience != null) {
            return false;
        }
        if (this.tokenEndpointUri != null ? !this.tokenEndpointUri.equals(that.tokenEndpointUri) : that.tokenEndpointUri != null) {
            return false;
        }
        if (this.connectTimeoutSeconds != null ? !this.connectTimeoutSeconds.equals(that.connectTimeoutSeconds) : that.connectTimeoutSeconds != null) {
            return false;
        }
        if (this.readTimeoutSeconds != null ? !this.readTimeoutSeconds.equals(that.readTimeoutSeconds) : that.readTimeoutSeconds != null) {
            return false;
        }
        if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) {
            return false;
        }
        if (this.accessToken != null ? !this.accessToken.equals(that.accessToken) : that.accessToken != null) {
            return false;
        }
        if (this.refreshToken != null ? !this.refreshToken.equals(that.refreshToken) : that.refreshToken != null) {
            return false;
        }
        if (this.tlsTrustedCertificates != null ? !this.tlsTrustedCertificates.equals(that.tlsTrustedCertificates) : that.tlsTrustedCertificates != null) {
            return false;
        }
        if (this.disableTlsHostnameVerification != that.disableTlsHostnameVerification) {
            return false;
        }
        if (this.maxTokenExpirySeconds != that.maxTokenExpirySeconds) {
            return false;
        }
        return this.accessTokenIsJwt == that.accessTokenIsJwt;
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.scope, this.audience, this.tokenEndpointUri, this.connectTimeoutSeconds, this.readTimeoutSeconds, this.clientSecret, this.accessToken, this.refreshToken, this.tlsTrustedCertificates, this.disableTlsHostnameVerification, this.maxTokenExpirySeconds, this.accessTokenIsJwt, super.hashCode());
    }

    public class TlsTrustedCertificatesNestedImpl<N>
    extends CertSecretSourceFluentImpl<KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>>
    implements KafkaClientAuthenticationOAuthFluent.TlsTrustedCertificatesNested<N>,
    Nested<N> {
        private final CertSecretSourceBuilder builder;
        private final int index;

        TlsTrustedCertificatesNestedImpl(int index, CertSecretSource item) {
            this.index = index;
            this.builder = new CertSecretSourceBuilder(this, item);
        }

        TlsTrustedCertificatesNestedImpl() {
            this.index = -1;
            this.builder = new CertSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluentImpl.this.setToTlsTrustedCertificates(this.index, this.builder.build());
        }

        @Override
        public N endTlsTrustedCertificate() {
            return this.and();
        }
    }

    public class RefreshTokenNestedImpl<N>
    extends GenericSecretSourceFluentImpl<KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<N>>
    implements KafkaClientAuthenticationOAuthFluent.RefreshTokenNested<N>,
    Nested<N> {
        private final GenericSecretSourceBuilder builder;

        RefreshTokenNestedImpl(GenericSecretSource item) {
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        RefreshTokenNestedImpl() {
            this.builder = new GenericSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluentImpl.this.withRefreshToken(this.builder.build());
        }

        @Override
        public N endRefreshToken() {
            return this.and();
        }
    }

    public class AccessTokenNestedImpl<N>
    extends GenericSecretSourceFluentImpl<KafkaClientAuthenticationOAuthFluent.AccessTokenNested<N>>
    implements KafkaClientAuthenticationOAuthFluent.AccessTokenNested<N>,
    Nested<N> {
        private final GenericSecretSourceBuilder builder;

        AccessTokenNestedImpl(GenericSecretSource item) {
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        AccessTokenNestedImpl() {
            this.builder = new GenericSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluentImpl.this.withAccessToken(this.builder.build());
        }

        @Override
        public N endAccessToken() {
            return this.and();
        }
    }

    public class ClientSecretNestedImpl<N>
    extends GenericSecretSourceFluentImpl<KafkaClientAuthenticationOAuthFluent.ClientSecretNested<N>>
    implements KafkaClientAuthenticationOAuthFluent.ClientSecretNested<N>,
    Nested<N> {
        private final GenericSecretSourceBuilder builder;

        ClientSecretNestedImpl(GenericSecretSource item) {
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        ClientSecretNestedImpl() {
            this.builder = new GenericSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClientAuthenticationOAuthFluentImpl.this.withClientSecret(this.builder.build());
        }

        @Override
        public N endClientSecret() {
            return this.and();
        }
    }
}

