/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.authentication;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.PasswordSecretSource;
import io.strimzi.api.kafka.model.PasswordSecretSourceBuilder;
import io.strimzi.api.kafka.model.PasswordSecretSourceFluentImpl;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256;
import io.strimzi.api.kafka.model.authentication.KafkaClientAuthenticationScramSha256Fluent;
import java.util.Objects;

public class KafkaClientAuthenticationScramSha256FluentImpl<A extends KafkaClientAuthenticationScramSha256Fluent<A>>
extends BaseFluent<A>
implements KafkaClientAuthenticationScramSha256Fluent<A> {
    private String username;
    private PasswordSecretSourceBuilder passwordSecret;

    public KafkaClientAuthenticationScramSha256FluentImpl() {
    }

    public KafkaClientAuthenticationScramSha256FluentImpl(KafkaClientAuthenticationScramSha256 instance) {
        this.withUsername(instance.getUsername());
        this.withPasswordSecret(instance.getPasswordSecret());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public A withUsername(String username) {
        this.username = username;
        return (A)this;
    }

    @Override
    public Boolean hasUsername() {
        return this.username != null;
    }

    @Override
    @Deprecated
    public A withNewUsername(String original) {
        return this.withUsername(new String(original));
    }

    @Override
    @Deprecated
    public PasswordSecretSource getPasswordSecret() {
        return this.passwordSecret != null ? this.passwordSecret.build() : null;
    }

    @Override
    public PasswordSecretSource buildPasswordSecret() {
        return this.passwordSecret != null ? this.passwordSecret.build() : null;
    }

    @Override
    public A withPasswordSecret(PasswordSecretSource passwordSecret) {
        this._visitables.get((Object)"passwordSecret").remove(this.passwordSecret);
        if (passwordSecret != null) {
            this.passwordSecret = new PasswordSecretSourceBuilder(passwordSecret);
            this._visitables.get((Object)"passwordSecret").add(this.passwordSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPasswordSecret() {
        return this.passwordSecret != null;
    }

    @Override
    public KafkaClientAuthenticationScramSha256Fluent.PasswordSecretNested<A> withNewPasswordSecret() {
        return new PasswordSecretNestedImpl();
    }

    @Override
    public KafkaClientAuthenticationScramSha256Fluent.PasswordSecretNested<A> withNewPasswordSecretLike(PasswordSecretSource item) {
        return new PasswordSecretNestedImpl(item);
    }

    @Override
    public KafkaClientAuthenticationScramSha256Fluent.PasswordSecretNested<A> editPasswordSecret() {
        return this.withNewPasswordSecretLike(this.getPasswordSecret());
    }

    @Override
    public KafkaClientAuthenticationScramSha256Fluent.PasswordSecretNested<A> editOrNewPasswordSecret() {
        return this.withNewPasswordSecretLike(this.getPasswordSecret() != null ? this.getPasswordSecret() : new PasswordSecretSourceBuilder().build());
    }

    @Override
    public KafkaClientAuthenticationScramSha256Fluent.PasswordSecretNested<A> editOrNewPasswordSecretLike(PasswordSecretSource item) {
        return this.withNewPasswordSecretLike(this.getPasswordSecret() != null ? this.getPasswordSecret() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaClientAuthenticationScramSha256FluentImpl that = (KafkaClientAuthenticationScramSha256FluentImpl)o;
        if (this.username != null ? !this.username.equals(that.username) : that.username != null) {
            return false;
        }
        return !(this.passwordSecret != null ? !this.passwordSecret.equals(that.passwordSecret) : that.passwordSecret != null);
    }

    public int hashCode() {
        return Objects.hash(this.username, this.passwordSecret, super.hashCode());
    }

    public class PasswordSecretNestedImpl<N>
    extends PasswordSecretSourceFluentImpl<KafkaClientAuthenticationScramSha256Fluent.PasswordSecretNested<N>>
    implements KafkaClientAuthenticationScramSha256Fluent.PasswordSecretNested<N>,
    Nested<N> {
        private final PasswordSecretSourceBuilder builder;

        PasswordSecretNestedImpl(PasswordSecretSource item) {
            this.builder = new PasswordSecretSourceBuilder(this, item);
        }

        PasswordSecretNestedImpl() {
            this.builder = new PasswordSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaClientAuthenticationScramSha256FluentImpl.this.withPasswordSecret(this.builder.build());
        }

        @Override
        public N endPasswordSecret() {
            return this.and();
        }
    }
}

