/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.listener;

import io.fabric8.kubernetes.api.builder.Nested;
import io.strimzi.api.kafka.model.GenericSecretSource;
import io.strimzi.api.kafka.model.GenericSecretSourceBuilder;
import io.strimzi.api.kafka.model.GenericSecretSourceFluentImpl;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustom;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationCustomFluent;
import io.strimzi.api.kafka.model.listener.KafkaListenerAuthenticationFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class KafkaListenerAuthenticationCustomFluentImpl<A extends KafkaListenerAuthenticationCustomFluent<A>>
extends KafkaListenerAuthenticationFluentImpl<A>
implements KafkaListenerAuthenticationCustomFluent<A> {
    private Map<String, Object> listenerConfig;
    private boolean sasl;
    private List<GenericSecretSourceBuilder> secrets;

    public KafkaListenerAuthenticationCustomFluentImpl() {
    }

    public KafkaListenerAuthenticationCustomFluentImpl(KafkaListenerAuthenticationCustom instance) {
        this.withListenerConfig(instance.getListenerConfig());
        this.withSasl(instance.isSasl());
        this.withSecrets(instance.getSecrets());
    }

    @Override
    public A addToListenerConfig(String key, Object value) {
        if (this.listenerConfig == null && key != null && value != null) {
            this.listenerConfig = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.listenerConfig.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToListenerConfig(Map<String, Object> map) {
        if (this.listenerConfig == null && map != null) {
            this.listenerConfig = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.listenerConfig.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromListenerConfig(String key) {
        if (this.listenerConfig == null) {
            return (A)this;
        }
        if (key != null && this.listenerConfig != null) {
            this.listenerConfig.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromListenerConfig(Map<String, Object> map) {
        if (this.listenerConfig == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.listenerConfig == null) continue;
                this.listenerConfig.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getListenerConfig() {
        return this.listenerConfig;
    }

    @Override
    public <K, V> A withListenerConfig(Map<String, Object> listenerConfig) {
        this.listenerConfig = listenerConfig == null ? null : new LinkedHashMap<String, Object>(listenerConfig);
        return (A)this;
    }

    @Override
    public Boolean hasListenerConfig() {
        return this.listenerConfig != null;
    }

    @Override
    public boolean isSasl() {
        return this.sasl;
    }

    @Override
    public A withSasl(boolean sasl) {
        this.sasl = sasl;
        return (A)this;
    }

    @Override
    public Boolean hasSasl() {
        return true;
    }

    @Override
    public A addToSecrets(int index, GenericSecretSource item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<GenericSecretSourceBuilder>();
        }
        GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
        this._visitables.get((Object)"secrets").add(index >= 0 ? index : this._visitables.get((Object)"secrets").size(), builder);
        this.secrets.add(index >= 0 ? index : this.secrets.size(), builder);
        return (A)this;
    }

    @Override
    public A setToSecrets(int index, GenericSecretSource item) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<GenericSecretSourceBuilder>();
        }
        GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"secrets").size()) {
            this._visitables.get((Object)"secrets").add(builder);
        } else {
            this._visitables.get((Object)"secrets").set(index, builder);
        }
        if (index < 0 || index >= this.secrets.size()) {
            this.secrets.add(builder);
        } else {
            this.secrets.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToSecrets(GenericSecretSource ... items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<GenericSecretSourceBuilder>();
        }
        for (GenericSecretSource item : items) {
            GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToSecrets(Collection<GenericSecretSource> items) {
        if (this.secrets == null) {
            this.secrets = new ArrayList<GenericSecretSourceBuilder>();
        }
        for (GenericSecretSource item : items) {
            GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
            this._visitables.get((Object)"secrets").add(builder);
            this.secrets.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromSecrets(GenericSecretSource ... items) {
        for (GenericSecretSource item : items) {
            GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
            this._visitables.get((Object)"secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSecrets(Collection<GenericSecretSource> items) {
        for (GenericSecretSource item : items) {
            GenericSecretSourceBuilder builder = new GenericSecretSourceBuilder(item);
            this._visitables.get((Object)"secrets").remove(builder);
            if (this.secrets == null) continue;
            this.secrets.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromSecrets(Predicate<GenericSecretSourceBuilder> predicate) {
        if (this.secrets == null) {
            return (A)this;
        }
        Iterator<GenericSecretSourceBuilder> each = this.secrets.iterator();
        List visitables = this._visitables.get((Object)"secrets");
        while (each.hasNext()) {
            GenericSecretSourceBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<GenericSecretSource> getSecrets() {
        return KafkaListenerAuthenticationCustomFluentImpl.build(this.secrets);
    }

    @Override
    public List<GenericSecretSource> buildSecrets() {
        return KafkaListenerAuthenticationCustomFluentImpl.build(this.secrets);
    }

    @Override
    public GenericSecretSource buildSecret(int index) {
        return this.secrets.get(index).build();
    }

    @Override
    public GenericSecretSource buildFirstSecret() {
        return this.secrets.get(0).build();
    }

    @Override
    public GenericSecretSource buildLastSecret() {
        return this.secrets.get(this.secrets.size() - 1).build();
    }

    @Override
    public GenericSecretSource buildMatchingSecret(Predicate<GenericSecretSourceBuilder> predicate) {
        for (GenericSecretSourceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingSecret(Predicate<GenericSecretSourceBuilder> predicate) {
        for (GenericSecretSourceBuilder item : this.secrets) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSecrets(List<GenericSecretSource> secrets) {
        if (this.secrets != null) {
            this._visitables.get((Object)"secrets").removeAll(this.secrets);
        }
        if (secrets != null) {
            this.secrets = new ArrayList<GenericSecretSourceBuilder>();
            for (GenericSecretSource item : secrets) {
                this.addToSecrets(item);
            }
        } else {
            this.secrets = null;
        }
        return (A)this;
    }

    @Override
    public A withSecrets(GenericSecretSource ... secrets) {
        if (this.secrets != null) {
            this.secrets.clear();
        }
        if (secrets != null) {
            for (GenericSecretSource item : secrets) {
                this.addToSecrets(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSecrets() {
        return this.secrets != null && !this.secrets.isEmpty();
    }

    @Override
    public KafkaListenerAuthenticationCustomFluent.SecretsNested<A> addNewSecret() {
        return new SecretsNestedImpl();
    }

    @Override
    public KafkaListenerAuthenticationCustomFluent.SecretsNested<A> addNewSecretLike(GenericSecretSource item) {
        return new SecretsNestedImpl(-1, item);
    }

    @Override
    public KafkaListenerAuthenticationCustomFluent.SecretsNested<A> setNewSecretLike(int index, GenericSecretSource item) {
        return new SecretsNestedImpl(index, item);
    }

    @Override
    public KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editSecret(int index) {
        if (this.secrets.size() <= index) {
            throw new RuntimeException("Can't edit secrets. Index exceeds size.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editFirstSecret() {
        if (this.secrets.size() == 0) {
            throw new RuntimeException("Can't edit first secrets. The list is empty.");
        }
        return this.setNewSecretLike(0, this.buildSecret(0));
    }

    @Override
    public KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editLastSecret() {
        int index = this.secrets.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last secrets. The list is empty.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public KafkaListenerAuthenticationCustomFluent.SecretsNested<A> editMatchingSecret(Predicate<GenericSecretSourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.secrets.size(); ++i) {
            if (!predicate.test(this.secrets.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching secrets. No match found.");
        }
        return this.setNewSecretLike(index, this.buildSecret(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaListenerAuthenticationCustomFluentImpl that = (KafkaListenerAuthenticationCustomFluentImpl)o;
        if (this.listenerConfig != null ? !this.listenerConfig.equals(that.listenerConfig) : that.listenerConfig != null) {
            return false;
        }
        if (this.sasl != that.sasl) {
            return false;
        }
        return !(this.secrets != null ? !this.secrets.equals(that.secrets) : that.secrets != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.listenerConfig, this.sasl, this.secrets, super.hashCode());
    }

    public class SecretsNestedImpl<N>
    extends GenericSecretSourceFluentImpl<KafkaListenerAuthenticationCustomFluent.SecretsNested<N>>
    implements KafkaListenerAuthenticationCustomFluent.SecretsNested<N>,
    Nested<N> {
        private final GenericSecretSourceBuilder builder;
        private final int index;

        SecretsNestedImpl(int index, GenericSecretSource item) {
            this.index = index;
            this.builder = new GenericSecretSourceBuilder(this, item);
        }

        SecretsNestedImpl() {
            this.index = -1;
            this.builder = new GenericSecretSourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)KafkaListenerAuthenticationCustomFluentImpl.this.setToSecrets(this.index, this.builder.build());
        }

        @Override
        public N endSecret() {
            return this.and();
        }
    }
}

