/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.storage;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorage;
import io.strimzi.api.kafka.model.storage.EphemeralStorageBuilder;
import io.strimzi.api.kafka.model.storage.EphemeralStorageFluentImpl;
import io.strimzi.api.kafka.model.storage.JbodStorage;
import io.strimzi.api.kafka.model.storage.JbodStorageFluent;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorage;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageBuilder;
import io.strimzi.api.kafka.model.storage.PersistentClaimStorageFluentImpl;
import io.strimzi.api.kafka.model.storage.SingleVolumeStorage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class JbodStorageFluentImpl<A extends JbodStorageFluent<A>>
extends BaseFluent<A>
implements JbodStorageFluent<A> {
    private List<VisitableBuilder<? extends SingleVolumeStorage, ?>> volumes;

    public JbodStorageFluentImpl() {
    }

    public JbodStorageFluentImpl(JbodStorage instance) {
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public A addToVolumes(VisitableBuilder<? extends SingleVolumeStorage, ?> builder) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        this._visitables.get((Object)"volumes").add(builder);
        this.volumes.add(builder);
        return (A)this;
    }

    @Override
    public A addToVolumes(int index, VisitableBuilder<? extends SingleVolumeStorage, ?> builder) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        this._visitables.get((Object)"volumes").add(index, builder);
        this.volumes.add(index, builder);
        return (A)this;
    }

    @Override
    public A addToVolumes(int index, SingleVolumeStorage item) {
        if (item instanceof PersistentClaimStorage) {
            this.addToPersistentClaimStorageVolumes(index, (PersistentClaimStorage)item);
        } else if (item instanceof EphemeralStorage) {
            this.addToEphemeralStorageVolumes(index, (EphemeralStorage)item);
        }
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, SingleVolumeStorage item) {
        if (item instanceof PersistentClaimStorage) {
            this.setToPersistentClaimStorageVolumes(index, (PersistentClaimStorage)item);
        } else if (item instanceof EphemeralStorage) {
            this.setToEphemeralStorageVolumes(index, (EphemeralStorage)item);
        }
        return (A)this;
    }

    @Override
    public A addToVolumes(SingleVolumeStorage ... items) {
        if (items != null && items.length > 0 && this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (SingleVolumeStorage item : items) {
            if (item instanceof PersistentClaimStorage) {
                this.addToPersistentClaimStorageVolumes((PersistentClaimStorage)item);
                continue;
            }
            if (item instanceof EphemeralStorage) {
                this.addToEphemeralStorageVolumes((EphemeralStorage)item);
                continue;
            }
            VisitableBuilder builder = JbodStorageFluentImpl.builderOf((Object)item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<SingleVolumeStorage> items) {
        if (items != null && items.size() > 0 && this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (SingleVolumeStorage item : items) {
            if (item instanceof PersistentClaimStorage) {
                this.addToPersistentClaimStorageVolumes((PersistentClaimStorage)item);
                continue;
            }
            if (item instanceof EphemeralStorage) {
                this.addToEphemeralStorageVolumes((EphemeralStorage)item);
                continue;
            }
            VisitableBuilder builder = JbodStorageFluentImpl.builderOf((Object)item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(VisitableBuilder<? extends SingleVolumeStorage, ?> builder) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        this._visitables.get((Object)"volumes").remove(builder);
        this.volumes.remove(builder);
        return (A)this;
    }

    @Override
    public A removeFromVolumes(SingleVolumeStorage ... items) {
        for (SingleVolumeStorage item : items) {
            if (item instanceof PersistentClaimStorage) {
                this.removeFromPersistentClaimStorageVolumes((PersistentClaimStorage)item);
                continue;
            }
            if (item instanceof EphemeralStorage) {
                this.removeFromEphemeralStorageVolumes((EphemeralStorage)item);
                continue;
            }
            VisitableBuilder builder = JbodStorageFluentImpl.builderOf((Object)item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<SingleVolumeStorage> items) {
        for (SingleVolumeStorage item : items) {
            if (item instanceof PersistentClaimStorage) {
                this.removeFromPersistentClaimStorageVolumes((PersistentClaimStorage)item);
                continue;
            }
            if (item instanceof EphemeralStorage) {
                this.removeFromEphemeralStorageVolumes((EphemeralStorage)item);
                continue;
            }
            VisitableBuilder builder = JbodStorageFluentImpl.builderOf((Object)item);
            this._visitables.get((Object)"volumes").remove(builder);
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<SingleVolumeStorage> getVolumes() {
        return JbodStorageFluentImpl.build(this.volumes);
    }

    @Override
    public List<SingleVolumeStorage> buildVolumes() {
        return JbodStorageFluentImpl.build(this.volumes);
    }

    @Override
    public SingleVolumeStorage buildVolume(int index) {
        return (SingleVolumeStorage)this.volumes.get(index).build();
    }

    @Override
    public SingleVolumeStorage buildFirstVolume() {
        return (SingleVolumeStorage)this.volumes.get(0).build();
    }

    @Override
    public SingleVolumeStorage buildLastVolume() {
        return (SingleVolumeStorage)this.volumes.get(this.volumes.size() - 1).build();
    }

    @Override
    public SingleVolumeStorage buildMatchingVolume(Predicate<VisitableBuilder<? extends SingleVolumeStorage, ?>> predicate) {
        for (VisitableBuilder<? extends SingleVolumeStorage, ?> visitableBuilder : this.volumes) {
            if (!predicate.test(visitableBuilder)) continue;
            return (SingleVolumeStorage)visitableBuilder.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<VisitableBuilder<? extends SingleVolumeStorage, ?>> predicate) {
        for (VisitableBuilder<? extends SingleVolumeStorage, ?> visitableBuilder : this.volumes) {
            if (!predicate.test(visitableBuilder)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<SingleVolumeStorage> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList();
            for (SingleVolumeStorage item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = null;
        }
        return (A)this;
    }

    @Override
    public A withVolumes(SingleVolumeStorage ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (SingleVolumeStorage item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    @Override
    public A addToPersistentClaimStorageVolumes(int index, PersistentClaimStorage item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);
        this._visitables.get((Object)"volumes").add(index >= 0 ? index : this._visitables.get((Object)"volumes").size(), builder);
        this.volumes.add(index >= 0 ? index : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPersistentClaimStorageVolumes(int index, PersistentClaimStorage item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumes").size()) {
            this._visitables.get((Object)"volumes").add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPersistentClaimStorageVolumes(PersistentClaimStorage ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (PersistentClaimStorage item : items) {
            PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPersistentClaimStorageVolumes(Collection<PersistentClaimStorage> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (PersistentClaimStorage item : items) {
            PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPersistentClaimStorageVolumes(PersistentClaimStorage ... items) {
        for (PersistentClaimStorage item : items) {
            PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPersistentClaimStorageVolumes(Collection<PersistentClaimStorage> items) {
        for (PersistentClaimStorage item : items) {
            PersistentClaimStorageBuilder builder = new PersistentClaimStorageBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPersistentClaimStorageVolumes(Predicate<VisitableBuilder<? extends SingleVolumeStorage, ?>> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VisitableBuilder<SingleVolumeStorage, ?>> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VisitableBuilder<? extends SingleVolumeStorage, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolume() {
        return new PersistentClaimStorageVolumesNestedImpl();
    }

    @Override
    public JbodStorageFluent.PersistentClaimStorageVolumesNested<A> addNewPersistentClaimStorageVolumeLike(PersistentClaimStorage item) {
        return new PersistentClaimStorageVolumesNestedImpl(-1, item);
    }

    @Override
    public JbodStorageFluent.PersistentClaimStorageVolumesNested<A> setNewPersistentClaimStorageVolumeLike(int index, PersistentClaimStorage item) {
        return new PersistentClaimStorageVolumesNestedImpl(index, item);
    }

    @Override
    public A addToEphemeralStorageVolumes(int index, EphemeralStorage item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);
        this._visitables.get((Object)"volumes").add(index >= 0 ? index : this._visitables.get((Object)"volumes").size(), builder);
        this.volumes.add(index >= 0 ? index : this.volumes.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEphemeralStorageVolumes(int index, EphemeralStorage item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"volumes").size()) {
            this._visitables.get((Object)"volumes").add(builder);
        } else {
            this._visitables.get((Object)"volumes").set(index, builder);
        }
        if (index < 0 || index >= this.volumes.size()) {
            this.volumes.add(builder);
        } else {
            this.volumes.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEphemeralStorageVolumes(EphemeralStorage ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (EphemeralStorage item : items) {
            EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEphemeralStorageVolumes(Collection<EphemeralStorage> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList();
        }
        for (EphemeralStorage item : items) {
            EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);
            this._visitables.get((Object)"volumes").add(builder);
            this.volumes.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEphemeralStorageVolumes(EphemeralStorage ... items) {
        for (EphemeralStorage item : items) {
            EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEphemeralStorageVolumes(Collection<EphemeralStorage> items) {
        for (EphemeralStorage item : items) {
            EphemeralStorageBuilder builder = new EphemeralStorageBuilder(item);
            this._visitables.get((Object)"volumes").remove(builder);
            if (this.volumes == null) continue;
            this.volumes.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEphemeralStorageVolumes(Predicate<VisitableBuilder<? extends SingleVolumeStorage, ?>> predicate) {
        if (this.volumes == null) {
            return (A)this;
        }
        Iterator<VisitableBuilder<SingleVolumeStorage, ?>> each = this.volumes.iterator();
        List visitables = this._visitables.get((Object)"volumes");
        while (each.hasNext()) {
            VisitableBuilder<? extends SingleVolumeStorage, ?> builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    public JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolume() {
        return new EphemeralStorageVolumesNestedImpl();
    }

    @Override
    public JbodStorageFluent.EphemeralStorageVolumesNested<A> addNewEphemeralStorageVolumeLike(EphemeralStorage item) {
        return new EphemeralStorageVolumesNestedImpl(-1, item);
    }

    @Override
    public JbodStorageFluent.EphemeralStorageVolumesNested<A> setNewEphemeralStorageVolumeLike(int index, EphemeralStorage item) {
        return new EphemeralStorageVolumesNestedImpl(index, item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JbodStorageFluentImpl that = (JbodStorageFluentImpl)o;
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public int hashCode() {
        return Objects.hash(this.volumes, super.hashCode());
    }

    public class EphemeralStorageVolumesNestedImpl<N>
    extends EphemeralStorageFluentImpl<JbodStorageFluent.EphemeralStorageVolumesNested<N>>
    implements JbodStorageFluent.EphemeralStorageVolumesNested<N>,
    Nested<N> {
        private final EphemeralStorageBuilder builder;
        private final int index;

        EphemeralStorageVolumesNestedImpl(int index, EphemeralStorage item) {
            this.index = index;
            this.builder = new EphemeralStorageBuilder(this, item);
        }

        EphemeralStorageVolumesNestedImpl() {
            this.index = -1;
            this.builder = new EphemeralStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)JbodStorageFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endEphemeralStorageVolume() {
            return this.and();
        }
    }

    public class PersistentClaimStorageVolumesNestedImpl<N>
    extends PersistentClaimStorageFluentImpl<JbodStorageFluent.PersistentClaimStorageVolumesNested<N>>
    implements JbodStorageFluent.PersistentClaimStorageVolumesNested<N>,
    Nested<N> {
        private final PersistentClaimStorageBuilder builder;
        private final int index;

        PersistentClaimStorageVolumesNestedImpl(int index, PersistentClaimStorage item) {
            this.index = index;
            this.builder = new PersistentClaimStorageBuilder(this, item);
        }

        PersistentClaimStorageVolumesNestedImpl() {
            this.index = -1;
            this.builder = new PersistentClaimStorageBuilder(this);
        }

        @Override
        public N and() {
            return (N)JbodStorageFluentImpl.this.setToVolumes(this.index, this.builder.build());
        }

        @Override
        public N endPersistentClaimStorageVolume() {
            return this.and();
        }
    }
}

