/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model.template;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.HostAlias;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.PodSecurityContext;
import io.fabric8.kubernetes.api.model.Toleration;
import io.fabric8.kubernetes.api.model.TopologySpreadConstraint;
import io.strimzi.api.kafka.model.UnknownPropertyPreserving;
import io.strimzi.api.kafka.model.template.MetadataTemplate;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.DescriptionFile;
import io.strimzi.crdgenerator.annotations.KubeLink;
import io.strimzi.crdgenerator.annotations.Minimum;
import io.strimzi.crdgenerator.annotations.Pattern;
import io.vertx.core.cli.annotations.DefaultValue;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"metadata", "imagePullSecrets", "securityContext", "terminationGracePeriodSeconds", "affinity", "tolerations", "topologySpreadConstraint", "priorityClassName", "schedulerName", "hostAliases", "tmpDirSizeLimit"})
@DescriptionFile
public class PodTemplate
implements Serializable,
UnknownPropertyPreserving {
    private static final long serialVersionUID = 1L;
    private MetadataTemplate metadata;
    private List<LocalObjectReference> imagePullSecrets;
    private PodSecurityContext securityContext;
    private int terminationGracePeriodSeconds = 30;
    private Affinity affinity;
    private List<Toleration> tolerations;
    private List<TopologySpreadConstraint> topologySpreadConstraints;
    private String priorityClassName;
    private String schedulerName;
    private List<HostAlias> hostAliases;
    private Boolean enableServiceLinks;
    private String tmpDirSizeLimit;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>(0);

    @Description(value="Metadata applied to the resource.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public MetadataTemplate getMetadata() {
        return this.metadata;
    }

    public void setMetadata(MetadataTemplate metadata) {
        this.metadata = metadata;
    }

    @Description(value="Configures pod-level security attributes and common container settings.")
    @KubeLink(group="core", version="v1", kind="podsecuritycontext")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public PodSecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(PodSecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    @Description(value="List of references to secrets in the same namespace to use for pulling any of the images used by this Pod. When the `STRIMZI_IMAGE_PULL_SECRETS` environment variable in Cluster Operator and the `imagePullSecrets` option are specified, only the `imagePullSecrets` variable is used and the `STRIMZI_IMAGE_PULL_SECRETS` variable is ignored.")
    @KubeLink(group="core", version="v1", kind="localobjectreference")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(List<LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    @Description(value="The grace period is the duration in seconds after the processes running in the pod are sent a termination signal, and the time when the processes are forcibly halted with a kill signal. Set this value to longer than the expected cleanup time for your process. Value must be a non-negative integer. A zero value indicates delete immediately. You might need to increase the grace period for very large Kafka clusters, so that the Kafka brokers have enough time to transfer their work to another broker before they are terminated. Defaults to 30 seconds.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @DefaultValue(value="30")
    @Minimum(value=0)
    public int getTerminationGracePeriodSeconds() {
        return this.terminationGracePeriodSeconds;
    }

    public void setTerminationGracePeriodSeconds(int terminationGracePeriodSeconds) {
        this.terminationGracePeriodSeconds = terminationGracePeriodSeconds;
    }

    @Description(value="The pod's affinity rules.")
    @KubeLink(group="core", version="v1", kind="affinity")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Affinity getAffinity() {
        return this.affinity;
    }

    public void setAffinity(Affinity affinity) {
        this.affinity = affinity;
    }

    @Description(value="The pod's tolerations.")
    @KubeLink(group="core", version="v1", kind="toleration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    @Description(value="The pod's topology spread constraints.")
    @KubeLink(group="core", version="v1", kind="topologyspreadconstraint")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<TopologySpreadConstraint> getTopologySpreadConstraints() {
        return this.topologySpreadConstraints;
    }

    public void setTopologySpreadConstraints(List<TopologySpreadConstraint> topologySpreadConstraints) {
        this.topologySpreadConstraints = topologySpreadConstraints;
    }

    @Description(value="The name of the priority class used to assign priority to the pods. For more information about priority classes, see {K8sPriorityClass}.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getPriorityClassName() {
        return this.priorityClassName;
    }

    public void setPriorityClassName(String priorityClassName) {
        this.priorityClassName = priorityClassName;
    }

    @Description(value="The name of the scheduler used to dispatch this `Pod`. If not specified, the default scheduler will be used.")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    @Description(value="The pod's HostAliases. HostAliases is an optional list of hosts and IPs that will be injected into the Pod's hosts file if specified.")
    @KubeLink(group="core", version="v1", kind="HostAlias")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<HostAlias> getHostAliases() {
        return this.hostAliases;
    }

    public void setHostAliases(List<HostAlias> hostAliases) {
        this.hostAliases = hostAliases;
    }

    @Description(value="Indicates whether information about services should be injected into Pod's environment variables.")
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public Boolean getEnableServiceLinks() {
        return this.enableServiceLinks;
    }

    public void setEnableServiceLinks(Boolean enableServiceLinks) {
        this.enableServiceLinks = enableServiceLinks;
    }

    @Pattern(value="^([0-9.]+)([eEinumkKMGTP]*[-+]?[0-9]*)$")
    @DefaultValue(value="1Mi")
    @Description(value="Defines the total amount (for example `1Gi`) of local storage required for temporary EmptyDir volume (`/tmp`). Default value is `1Mi`.")
    public String getTmpDirSizeLimit() {
        return this.tmpDirSizeLimit;
    }

    public void setTmpDirSizeLimit(String tmpDirSizeLimit) {
        this.tmpDirSizeLimit = tmpDirSizeLimit;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PodTemplate)) {
            return false;
        }
        PodTemplate other = (PodTemplate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MetadataTemplate this$metadata = this.getMetadata();
        MetadataTemplate other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        List<LocalObjectReference> this$imagePullSecrets = this.getImagePullSecrets();
        List<LocalObjectReference> other$imagePullSecrets = other.getImagePullSecrets();
        if (this$imagePullSecrets == null ? other$imagePullSecrets != null : !((Object)this$imagePullSecrets).equals(other$imagePullSecrets)) {
            return false;
        }
        PodSecurityContext this$securityContext = this.getSecurityContext();
        PodSecurityContext other$securityContext = other.getSecurityContext();
        if (this$securityContext == null ? other$securityContext != null : !this$securityContext.equals(other$securityContext)) {
            return false;
        }
        if (this.getTerminationGracePeriodSeconds() != other.getTerminationGracePeriodSeconds()) {
            return false;
        }
        Affinity this$affinity = this.getAffinity();
        Affinity other$affinity = other.getAffinity();
        if (this$affinity == null ? other$affinity != null : !this$affinity.equals(other$affinity)) {
            return false;
        }
        List<Toleration> this$tolerations = this.getTolerations();
        List<Toleration> other$tolerations = other.getTolerations();
        if (this$tolerations == null ? other$tolerations != null : !((Object)this$tolerations).equals(other$tolerations)) {
            return false;
        }
        List<TopologySpreadConstraint> this$topologySpreadConstraints = this.getTopologySpreadConstraints();
        List<TopologySpreadConstraint> other$topologySpreadConstraints = other.getTopologySpreadConstraints();
        if (this$topologySpreadConstraints == null ? other$topologySpreadConstraints != null : !((Object)this$topologySpreadConstraints).equals(other$topologySpreadConstraints)) {
            return false;
        }
        String this$priorityClassName = this.getPriorityClassName();
        String other$priorityClassName = other.getPriorityClassName();
        if (this$priorityClassName == null ? other$priorityClassName != null : !this$priorityClassName.equals(other$priorityClassName)) {
            return false;
        }
        String this$schedulerName = this.getSchedulerName();
        String other$schedulerName = other.getSchedulerName();
        if (this$schedulerName == null ? other$schedulerName != null : !this$schedulerName.equals(other$schedulerName)) {
            return false;
        }
        List<HostAlias> this$hostAliases = this.getHostAliases();
        List<HostAlias> other$hostAliases = other.getHostAliases();
        if (this$hostAliases == null ? other$hostAliases != null : !((Object)this$hostAliases).equals(other$hostAliases)) {
            return false;
        }
        Boolean this$enableServiceLinks = this.getEnableServiceLinks();
        Boolean other$enableServiceLinks = other.getEnableServiceLinks();
        if (this$enableServiceLinks == null ? other$enableServiceLinks != null : !((Object)this$enableServiceLinks).equals(other$enableServiceLinks)) {
            return false;
        }
        String this$tmpDirSizeLimit = this.getTmpDirSizeLimit();
        String other$tmpDirSizeLimit = other.getTmpDirSizeLimit();
        if (this$tmpDirSizeLimit == null ? other$tmpDirSizeLimit != null : !this$tmpDirSizeLimit.equals(other$tmpDirSizeLimit)) {
            return false;
        }
        Map<String, Object> this$additionalProperties = this.getAdditionalProperties();
        Map<String, Object> other$additionalProperties = other.getAdditionalProperties();
        return !(this$additionalProperties == null ? other$additionalProperties != null : !((Object)this$additionalProperties).equals(other$additionalProperties));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PodTemplate;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MetadataTemplate $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        List<LocalObjectReference> $imagePullSecrets = this.getImagePullSecrets();
        result = result * 59 + ($imagePullSecrets == null ? 43 : ((Object)$imagePullSecrets).hashCode());
        PodSecurityContext $securityContext = this.getSecurityContext();
        result = result * 59 + ($securityContext == null ? 43 : $securityContext.hashCode());
        result = result * 59 + this.getTerminationGracePeriodSeconds();
        Affinity $affinity = this.getAffinity();
        result = result * 59 + ($affinity == null ? 43 : $affinity.hashCode());
        List<Toleration> $tolerations = this.getTolerations();
        result = result * 59 + ($tolerations == null ? 43 : ((Object)$tolerations).hashCode());
        List<TopologySpreadConstraint> $topologySpreadConstraints = this.getTopologySpreadConstraints();
        result = result * 59 + ($topologySpreadConstraints == null ? 43 : ((Object)$topologySpreadConstraints).hashCode());
        String $priorityClassName = this.getPriorityClassName();
        result = result * 59 + ($priorityClassName == null ? 43 : $priorityClassName.hashCode());
        String $schedulerName = this.getSchedulerName();
        result = result * 59 + ($schedulerName == null ? 43 : $schedulerName.hashCode());
        List<HostAlias> $hostAliases = this.getHostAliases();
        result = result * 59 + ($hostAliases == null ? 43 : ((Object)$hostAliases).hashCode());
        Boolean $enableServiceLinks = this.getEnableServiceLinks();
        result = result * 59 + ($enableServiceLinks == null ? 43 : ((Object)$enableServiceLinks).hashCode());
        String $tmpDirSizeLimit = this.getTmpDirSizeLimit();
        result = result * 59 + ($tmpDirSizeLimit == null ? 43 : $tmpDirSizeLimit.hashCode());
        Map<String, Object> $additionalProperties = this.getAdditionalProperties();
        result = result * 59 + ($additionalProperties == null ? 43 : ((Object)$additionalProperties).hashCode());
        return result;
    }
}

