/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.api.kafka.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.strimzi.api.annotations.DeprecatedProperty;
import io.strimzi.api.kafka.model.AutoRestart;
import io.strimzi.api.kafka.model.ConnectorState;
import io.strimzi.api.kafka.model.Spec;
import io.strimzi.crdgenerator.annotations.Description;
import io.strimzi.crdgenerator.annotations.Minimum;
import java.util.HashMap;
import java.util.Map;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"pause", "tasksMax", "config", "state"})
public abstract class AbstractConnectorSpec
extends Spec {
    private static final long serialVersionUID = 1L;
    public static final String FORBIDDEN_PARAMETERS = "connector.class, tasks.max";
    private Integer tasksMax;
    private Boolean pause;
    private Map<String, Object> config = new HashMap<String, Object>(0);
    private ConnectorState state;
    private AutoRestart autoRestart;

    @Description(value="The maximum number of tasks for the Kafka Connector")
    @Minimum(value=1)
    public Integer getTasksMax() {
        return this.tasksMax;
    }

    public void setTasksMax(Integer tasksMax) {
        this.tasksMax = tasksMax;
    }

    @Description(value="The Kafka Connector configuration. The following properties cannot be set: connector.class, tasks.max")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, Object> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, Object> config) {
        this.config = config;
    }

    @Description(value="Whether the connector should be paused. Defaults to false.")
    @Deprecated
    @DeprecatedProperty(description="Deprecated in Strimzi 0.38.0, use state instead.")
    public Boolean getPause() {
        return this.pause;
    }

    @Deprecated
    public void setPause(Boolean pause) {
        this.pause = pause;
    }

    @Description(value="Automatic restart of connector and tasks configuration")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public AutoRestart getAutoRestart() {
        return this.autoRestart;
    }

    public void setAutoRestart(AutoRestart autoRestart) {
        this.autoRestart = autoRestart;
    }

    @Description(value="The state the connector should be in. Defaults to running.")
    public ConnectorState getState() {
        return this.state;
    }

    public void setState(ConnectorState state) {
        this.state = state;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractConnectorSpec)) {
            return false;
        }
        AbstractConnectorSpec other = (AbstractConnectorSpec)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$tasksMax = this.getTasksMax();
        Integer other$tasksMax = other.getTasksMax();
        if (this$tasksMax == null ? other$tasksMax != null : !((Object)this$tasksMax).equals(other$tasksMax)) {
            return false;
        }
        Boolean this$pause = this.getPause();
        Boolean other$pause = other.getPause();
        if (this$pause == null ? other$pause != null : !((Object)this$pause).equals(other$pause)) {
            return false;
        }
        Map<String, Object> this$config = this.getConfig();
        Map<String, Object> other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        ConnectorState this$state = this.getState();
        ConnectorState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        AutoRestart this$autoRestart = this.getAutoRestart();
        AutoRestart other$autoRestart = other.getAutoRestart();
        return !(this$autoRestart == null ? other$autoRestart != null : !((Object)this$autoRestart).equals(other$autoRestart));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AbstractConnectorSpec;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $tasksMax = this.getTasksMax();
        result = result * 59 + ($tasksMax == null ? 43 : ((Object)$tasksMax).hashCode());
        Boolean $pause = this.getPause();
        result = result * 59 + ($pause == null ? 43 : ((Object)$pause).hashCode());
        Map<String, Object> $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        ConnectorState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        AutoRestart $autoRestart = this.getAutoRestart();
        result = result * 59 + ($autoRestart == null ? 43 : ((Object)$autoRestart).hashCode());
        return result;
    }
}

